/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.leaderboard.SubmitScoreResult;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.de;
import com.google.android.gms.internal.dj;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.el;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.eq;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.es;
import com.google.android.gms.internal.et;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class em
extends de<er> {
    private final String mF;
    private final String it;
    private final Map<String, et> mG;
    private PlayerEntity mH;
    private GameEntity mI;
    private final es mJ;
    private boolean mK = false;
    private final Binder mL;
    private final long mM;
    private final boolean mN;

    public em(Context context, String string2, String string3, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.mF = string2;
        this.it = dm.e(string3);
        this.mL = new Binder();
        this.mG = new HashMap<String, et>();
        this.mJ = es.a(this, n2);
        this.setViewForPopups(view);
        this.mM = this.hashCode();
        this.mN = bl2;
    }

    public void setGravityForPopups(int gravity) {
        this.mJ.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.mJ.e(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            dm.a(!bl2, (Object)String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            dm.a(bl2, (Object)String.format("GamesClient requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.bR();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.mK = false;
        if (this.isConnected()) {
            try {
                er er2 = (er)this.bd();
                er2.bT();
                er2.g(this.mM);
                er2.f(this.mM);
            }
            catch (RemoteException remoteException) {
                ep.c("GamesClient", "Failed to notify client disconnect.");
            }
        }
        this.bS();
        super.disconnect();
    }

    @Override
    protected String ag() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String ah() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected er A(IBinder iBinder) {
        return er.a.C(iBinder);
    }

    @Override
    protected Bundle ba() {
        try {
            Bundle bundle = ((er)this.bd()).ba();
            if (bundle != null) {
                bundle.setClassLoader(em.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return null;
        }
    }

    private void bR() {
        this.mH = null;
    }

    @Override
    protected void a(dj dj2, de.d d2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.mN);
        dj2.a(d2, 4030500, this.getContext().getPackageName(), this.it, this.aY(), this.mF, this.mJ.bZ(), string2, bundle);
    }

    @Override
    protected void aZ() {
        super.aZ();
        if (this.mK) {
            this.mJ.bX();
            this.mK = false;
        }
    }

    @Override
    protected void a(ConnectionResult connectionResult) {
        super.a(connectionResult);
        this.mK = false;
    }

    public String getCurrentAccountName() {
        try {
            return ((er)this.bd()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((er)this.bd()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.bc();
        em em2 = this;
        synchronized (em2) {
            if (this.mH == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((er)this.bd()).bU());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.mH = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    ep.c("GamesClient", "service died");
                }
            }
        }
        return this.mH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.bc();
        em em2 = this;
        synchronized (em2) {
            if (this.mI == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((er)this.bd()).bW());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.mI = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    ep.c("GamesClient", "service died");
                }
            }
        }
        return this.mI;
    }

    public void loadPlayer(OnPlayersLoadedListener listener, String playerId) {
        try {
            ((er)this.bd()).c((eq)new ae(listener), playerId);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void a(OnPlayersLoadedListener onPlayersLoadedListener, int n2, boolean bl2, boolean bl3) {
        try {
            ((er)this.bd()).a((eq)new ae(onPlayersLoadedListener), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARDS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.mF);
        intent.addFlags(0x4000000);
        return eo.c(intent);
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARD_SCORES");
        intent.putExtra("com.google.android.gms.games.LEADERBOARD_ID", leaderboardId);
        intent.addFlags(0x4000000);
        return eo.c(intent);
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, boolean forceReload) {
        try {
            ((er)this.bd()).c((eq)new s(listener), forceReload);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, String leaderboardId, boolean forceReload) {
        try {
            ((er)this.bd()).c((eq)new s(listener), leaderboardId, forceReload);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((er)this.bd()).a(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((er)this.bd()).b(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void loadMoreScores(OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        try {
            ((er)this.bd()).a((eq)new q(listener), buffer.cb().cc(), maxResults, pageDirection);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void a(OnScoreSubmittedListener onScoreSubmittedListener, String string2, long l2, String string3) {
        try {
            ap ap2 = onScoreSubmittedListener == null ? null : new ap(onScoreSubmittedListener);
            ((er)this.bd()).a((eq)ap2, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_ACHIEVEMENTS");
        intent.addFlags(0x4000000);
        return eo.c(intent);
    }

    public void loadAchievements(OnAchievementsLoadedListener listener, boolean forceReload) {
        try {
            ((er)this.bd()).b((eq)new f(listener), forceReload);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((er)this.bd()).a((eq)d2, string2, this.mJ.bZ(), this.mJ.bY());
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void b(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((er)this.bd()).b((eq)d2, string2, this.mJ.bZ(), this.mJ.bY());
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2, int n2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((er)this.bd()).a((eq)d2, string2, n2, this.mJ.bZ(), this.mJ.bY());
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void b(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2, int n2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((er)this.bd()).b((eq)d2, string2, n2, this.mJ.bZ(), this.mJ.bY());
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public Intent getInvitationInboxIntent() {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_INVITATIONS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.mF);
        return eo.c(intent);
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            l l2 = new l(listener);
            ((er)this.bd()).a((eq)l2, this.mM);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((er)this.bd()).g(this.mM);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.SELECT_PLAYERS");
        intent.putExtra("com.google.android.gms.games.MIN_SELECTIONS", minPlayers);
        intent.putExtra("com.google.android.gms.games.MAX_SELECTIONS", maxPlayers);
        return eo.c(intent);
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_REAL_TIME_WAITING_ROOM");
        dm.a(room, (Object)"Room parameter must not be null");
        intent.putExtra("room", (Parcelable)room.freeze());
        dm.a(minParticipantsToStart >= 0, (Object)"minParticipantsToStart must be >= 0");
        intent.putExtra("com.google.android.gms.games.MIN_PARTICIPANTS_TO_START", minParticipantsToStart);
        return eo.c(intent);
    }

    public Intent getSettingsIntent() {
        this.bc();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_SETTINGS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.mF);
        intent.addFlags(0x4000000);
        return eo.c(intent);
    }

    public void loadGame(OnGamesLoadedListener listener) {
        try {
            ((er)this.bd()).d(new j(listener));
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void signOut(OnSignOutCompleteListener listener) {
        try {
            an an2 = listener == null ? null : new an(listener);
            ((er)this.bd()).a(an2);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public String getAppId() {
        try {
            return ((er)this.bd()).getAppId();
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return null;
        }
    }

    public void loadInvitations(OnInvitationsLoadedListener listener) {
        try {
            ((er)this.bd()).e(new n(listener));
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void i(String string2, int n2) {
        try {
            ((er)this.bd()).i(string2, n2);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void j(String string2, int n2) {
        try {
            ((er)this.bd()).j(string2, n2);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void createRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((er)this.bd()).a((eq)aj2, (IBinder)this.mL, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.mM);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((er)this.bd()).a((eq)aj2, (IBinder)this.mL, config.getInvitationId(), config.isSocketEnabled(), this.mM);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((er)this.bd()).e(new aj(listener), roomId);
            this.bS();
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public int sendReliableRealTimeMessage(RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        try {
            return ((er)this.bd()).a((eq)new ah(listener), messageData, roomId, recipientParticipantId);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        dm.a(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((er)this.bd()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((er)this.bd()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.Q(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        et et2 = this.mG.get(participantId);
        if (et2 == null || et2.isClosed()) {
            return this.K(participantId);
        }
        return et2;
    }

    private et K(String string2) {
        try {
            String string3 = ((er)this.bd()).M(string2);
            if (string3 == null) {
                return null;
            }
            ep.e("GamesClient", "Creating a socket to bind to:" + string3);
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                ep.d("GamesClient", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            et et2 = new et(localSocket, string2);
            this.mG.put(string2, et2);
            return et2;
        }
        catch (RemoteException remoteException) {
            ep.d("GamesClient", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((er)this.bd()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    public void setUseNewPlayerNotificationsFirstParty(boolean newPlayerStyle) {
        try {
            ((er)this.bd()).setUseNewPlayerNotificationsFirstParty(newPlayerStyle);
        }
        catch (RemoteException remoteException) {
            ep.c("GamesClient", "service died");
        }
    }

    private void bS() {
        for (et et2 : this.mG.values()) {
            try {
                et2.close();
            }
            catch (IOException iOException) {
                ep.a("GamesClient", "IOException:", iOException);
            }
        }
        this.mG.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((er)this.bd()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                ep.c("GamesClient", "service died");
            }
        }
    }

    public void bT() {
        if (this.isConnected()) {
            try {
                ((er)this.bd()).bT();
            }
            catch (RemoteException remoteException) {
                ep.c("GamesClient", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room x(com.google.android.gms.common.data.d d2) {
        com.google.android.gms.games.multiplayer.realtime.a a2 = new com.google.android.gms.games.multiplayer.realtime.a(d2);
        Room room = null;
        try {
            if (a2.getCount() > 0) {
                room = (Room)((Room)a2.get(0)).freeze();
            }
        }
        finally {
            a2.close();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.mK = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.A(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ao
    extends de.b<OnSignOutCompleteListener> {
        public ao(OnSignOutCompleteListener onSignOutCompleteListener) {
            super(em.this, onSignOutCompleteListener);
        }

        @Override
        public void a(OnSignOutCompleteListener onSignOutCompleteListener) {
            onSignOutCompleteListener.onSignOutComplete();
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends de.b<RealTimeReliableMessageSentListener> {
        private final int iC;
        private final String nf;
        private final int ng;

        ag(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener, int n2, int n3, String string2) {
            super(em.this, realTimeReliableMessageSentListener);
            this.iC = n2;
            this.ng = n3;
            this.nf = string2;
        }

        @Override
        public void a(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            if (realTimeReliableMessageSentListener != null) {
                realTimeReliableMessageSentListener.onRealTimeMessageSent(this.iC, this.ng, this.nf);
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends de.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage nc;

        v(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(em.this, realTimeMessageReceivedListener);
            this.nc = realTimeMessage;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            ep.b("GamesClient", "Deliver Message received callback");
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.nc);
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class x
    extends de.b<RoomStatusUpdateListener> {
        private final String nd;

        x(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(em.this, roomStatusUpdateListener);
            this.nd = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.nd);
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends de.b<RoomStatusUpdateListener> {
        private final String nd;

        w(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(em.this, roomStatusUpdateListener);
            this.nd = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.nd);
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends a {
        aa(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends a {
        y(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends a {
        z(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends a {
        ab(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class ai
    extends c {
        ai(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class al
    extends c {
        al(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ak
    extends b {
        ak(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends de.b<RoomUpdateListener> {
        private final int iC;
        private final String nb;

        u(RoomUpdateListener roomUpdateListener, int n2, String string2) {
            super(em.this, roomUpdateListener);
            this.iC = n2;
            this.nb = string2;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.iC, this.nb);
        }

        @Override
        protected void aF() {
        }
    }

    final class p
    extends b {
        public p(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class am
    extends b {
        public am(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> mO;

        a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2);
            this.mO = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mO.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.mO);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends de.c<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(em.this, roomStatusUpdateListener, d2);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            this.a(roomStatusUpdateListener, em.this.x(d2));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends de.c<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(em.this, roomUpdateListener, d2);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            this.a(roomUpdateListener, em.this.x(d2), d2.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aq
    extends de.b<OnScoreSubmittedListener> {
        private final SubmitScoreResult nn;

        public aq(OnScoreSubmittedListener onScoreSubmittedListener, SubmitScoreResult submitScoreResult) {
            super(em.this, onScoreSubmittedListener);
            this.nn = submitScoreResult;
        }

        @Override
        public void a(OnScoreSubmittedListener onScoreSubmittedListener) {
            onScoreSubmittedListener.onScoreSubmitted(this.nn.getStatusCode(), this.nn);
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends de.c<OnPlayersLoadedListener> {
        af(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.common.data.d d2) {
            super(em.this, onPlayersLoadedListener, d2);
        }

        @Override
        protected void a(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.common.data.d d2) {
            onPlayersLoadedListener.onPlayersLoaded(d2.getStatusCode(), new PlayerBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends de.b<OnInvitationReceivedListener> {
        private final Invitation mV;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(em.this, onInvitationReceivedListener);
            this.mV = invitation;
        }

        @Override
        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.mV);
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends de.c<OnInvitationsLoadedListener> {
        o(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.common.data.d d2) {
            super(em.this, onInvitationsLoadedListener, d2);
        }

        @Override
        protected void a(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.common.data.d d2) {
            onInvitationsLoadedListener.onInvitationsLoaded(d2.getStatusCode(), new InvitationBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends de.b<OnLeaderboardScoresLoadedListener> {
        private final com.google.android.gms.common.data.d mY;
        private final com.google.android.gms.common.data.d mZ;

        r(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener, com.google.android.gms.common.data.d d2, com.google.android.gms.common.data.d d3) {
            super(em.this, onLeaderboardScoresLoadedListener);
            this.mY = d2;
            this.mZ = d3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void a(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            com.google.android.gms.common.data.d d2 = this.mY;
            com.google.android.gms.common.data.d d3 = this.mZ;
            try {
                if (onLeaderboardScoresLoadedListener != null) {
                    LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(d2);
                    LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(d3);
                    onLeaderboardScoresLoadedListener.onLeaderboardScoresLoaded(d3.getStatusCode(), leaderboardBuffer, leaderboardScoreBuffer);
                    d2 = null;
                    d3 = null;
                }
            }
            finally {
                if (d2 != null) {
                    d2.close();
                }
                if (d3 != null) {
                    d3.close();
                }
            }
        }

        @Override
        protected void aF() {
            if (this.mY != null) {
                this.mY.close();
            }
            if (this.mZ != null) {
                this.mZ.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends de.c<OnLeaderboardMetadataLoadedListener> {
        t(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.common.data.d d2) {
            super(em.this, onLeaderboardMetadataLoadedListener, d2);
        }

        @Override
        protected void a(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.common.data.d d2) {
            onLeaderboardMetadataLoadedListener.onLeaderboardMetadataLoaded(d2.getStatusCode(), new LeaderboardBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends de.c<OnGamesLoadedListener> {
        k(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.common.data.d d2) {
            super(em.this, onGamesLoadedListener, d2);
        }

        @Override
        protected void a(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.common.data.d d2) {
            onGamesLoadedListener.onGamesLoaded(d2.getStatusCode(), new GameBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends de.b<OnAchievementUpdatedListener> {
        private final int iC;
        private final String mR;

        e(OnAchievementUpdatedListener onAchievementUpdatedListener, int n2, String string2) {
            super(em.this, onAchievementUpdatedListener);
            this.iC = n2;
            this.mR = string2;
        }

        @Override
        protected void a(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            onAchievementUpdatedListener.onAchievementUpdated(this.iC, this.mR);
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends de.c<OnAchievementsLoadedListener> {
        g(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.common.data.d d2) {
            super(em.this, onAchievementsLoadedListener, d2);
        }

        @Override
        protected void a(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.common.data.d d2) {
            onAchievementsLoadedListener.onAchievementsLoaded(d2.getStatusCode(), new AchievementBuffer(d2));
        }
    }

    final class an
    extends el {
        private final OnSignOutCompleteListener nl;

        public an(OnSignOutCompleteListener onSignOutCompleteListener) {
            this.nl = dm.a(onSignOutCompleteListener, (Object)"Listener must not be null");
        }

        public void onSignOutComplete() {
            em.this.a(new ao(this.nl));
        }
    }

    final class ah
    extends el {
        final RealTimeReliableMessageSentListener nh;

        public ah(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            this.nh = realTimeReliableMessageSentListener;
        }

        public void a(int n2, int n3, String string2) {
            em.this.a(new ag(this.nh, n2, n3, string2));
        }
    }

    final class aj
    extends el {
        private final RoomUpdateListener ni;
        private final RoomStatusUpdateListener nj;
        private final RealTimeMessageReceivedListener nk;

        public aj(RoomUpdateListener roomUpdateListener) {
            this.ni = dm.a(roomUpdateListener, (Object)"Callbacks must not be null");
            this.nj = null;
            this.nk = null;
        }

        public aj(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.ni = dm.a(roomUpdateListener, (Object)"Callbacks must not be null");
            this.nj = roomStatusUpdateListener;
            this.nk = realTimeMessageReceivedListener;
        }

        public void n(com.google.android.gms.common.data.d d2) {
            em.this.a(new am(this.ni, d2));
        }

        public void o(com.google.android.gms.common.data.d d2) {
            em.this.a(new p(this.ni, d2));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            em.this.a(new u(this.ni, statusCode, externalRoomId));
        }

        public void r(com.google.android.gms.common.data.d d2) {
            em.this.a(new ak(this.ni, d2));
        }

        public void p(com.google.android.gms.common.data.d d2) {
            em.this.a(new al(this.nj, d2));
        }

        public void q(com.google.android.gms.common.data.d d2) {
            em.this.a(new ai(this.nj, d2));
        }

        public void s(com.google.android.gms.common.data.d d2) {
            em.this.a(new h(this.nj, d2));
        }

        public void t(com.google.android.gms.common.data.d d2) {
            em.this.a(new i(this.nj, d2));
        }

        public void e(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new y(this.nj, d2, stringArray));
        }

        public void f(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new aa(this.nj, d2, stringArray));
        }

        public void a(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new ab(this.nj, d2, stringArray));
        }

        public void b(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new ac(this.nj, d2, stringArray));
        }

        public void c(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new ad(this.nj, d2, stringArray));
        }

        public void d(com.google.android.gms.common.data.d d2, String[] stringArray) {
            em.this.a(new z(this.nj, d2, stringArray));
        }

        public void onP2PConnected(String participantId) {
            em.this.a(new w(this.nj, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            em.this.a(new x(this.nj, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            ep.b("GamesClient", "RoomBinderCallbacks: onRealTimeMessageReceived");
            em.this.a(new v(this.nk, message));
        }
    }

    final class ap
    extends el {
        private final OnScoreSubmittedListener nm;

        public ap(OnScoreSubmittedListener onScoreSubmittedListener) {
            this.nm = dm.a(onScoreSubmittedListener, (Object)"Listener must not be null");
        }

        public void d(com.google.android.gms.common.data.d d2) {
            SubmitScoreResult submitScoreResult = new SubmitScoreResult(d2);
            em.this.a(new aq(this.nm, submitScoreResult));
        }
    }

    final class ae
    extends el {
        private final OnPlayersLoadedListener ne;

        ae(OnPlayersLoadedListener onPlayersLoadedListener) {
            this.ne = dm.a(onPlayersLoadedListener, (Object)"Listener must not be null");
        }

        public void e(com.google.android.gms.common.data.d d2) {
            em.this.a(new af(this.ne, d2));
        }
    }

    final class l
    extends el {
        private final OnInvitationReceivedListener mU;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.mU = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k(com.google.android.gms.common.data.d d2) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(d2);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.close();
            }
            if (invitation != null) {
                em.this.a(new m(this.mU, invitation));
            }
        }
    }

    final class n
    extends el {
        private final OnInvitationsLoadedListener mW;

        n(OnInvitationsLoadedListener onInvitationsLoadedListener) {
            this.mW = onInvitationsLoadedListener;
        }

        public void j(com.google.android.gms.common.data.d d2) {
            em.this.a(new o(this.mW, d2));
        }
    }

    final class q
    extends el {
        private final OnLeaderboardScoresLoadedListener mX;

        q(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            this.mX = dm.a(onLeaderboardScoresLoadedListener, (Object)"Listener must not be null");
        }

        public void a(com.google.android.gms.common.data.d d2, com.google.android.gms.common.data.d d3) {
            em.this.a(new r(this.mX, d2, d3));
        }
    }

    final class s
    extends el {
        private final OnLeaderboardMetadataLoadedListener na;

        s(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener) {
            this.na = dm.a(onLeaderboardMetadataLoadedListener, (Object)"Listener must not be null");
        }

        public void c(com.google.android.gms.common.data.d d2) {
            em.this.a(new t(this.na, d2));
        }
    }

    final class j
    extends el {
        private final OnGamesLoadedListener mT;

        j(OnGamesLoadedListener onGamesLoadedListener) {
            this.mT = dm.a(onGamesLoadedListener, (Object)"Listener must not be null");
        }

        public void g(com.google.android.gms.common.data.d d2) {
            em.this.a(new k(this.mT, d2));
        }
    }

    final class d
    extends el {
        private final OnAchievementUpdatedListener mQ;

        d(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            this.mQ = dm.a(onAchievementUpdatedListener, (Object)"Listener must not be null");
        }

        public void onAchievementUpdated(int statusCode, String achievementId) {
            em.this.a(new e(this.mQ, statusCode, achievementId));
        }
    }

    final class f
    extends el {
        private final OnAchievementsLoadedListener mS;

        f(OnAchievementsLoadedListener onAchievementsLoadedListener) {
            this.mS = dm.a(onAchievementsLoadedListener, (Object)"Listener must not be null");
        }

        public void b(com.google.android.gms.common.data.d d2) {
            em.this.a(new g(this.mS, d2));
        }
    }
}

