/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dl;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int iM;
    int mPriority;
    long oJ;
    long oK;
    boolean oL;
    long oC;
    int oM;
    float oN;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.iM = 1;
        this.mPriority = 102;
        this.oJ = 3600000L;
        this.oK = 600000L;
        this.oL = false;
        this.oC = Long.MAX_VALUE;
        this.oM = Integer.MAX_VALUE;
        this.oN = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.X(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.h(millis);
        this.oJ = millis;
        if (!this.oL) {
            this.oK = (long)((double)this.oJ / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.oJ;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.h(millis);
        this.oL = true;
        this.oK = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.oK;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.oC = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.oC < 0L) {
            this.oC = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.oC = millis;
        if (this.oC < 0L) {
            this.oC = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.oC;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.oM = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.oM;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.oN = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.oN;
    }

    private static void h(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void X(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.iM = versionCode;
        this.mPriority = priority;
        this.oJ = interval;
        this.oK = fastestInterval;
        this.oL = explicitFastestInterval;
        this.oC = expireAt;
        this.oM = numUpdates;
        this.oN = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String Y(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.Y(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.oJ + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.oK + "ms");
        if (this.oC != Long.MAX_VALUE) {
            long l2 = this.oC - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.oM != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.oM);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return dl.hashCode(this.mPriority, this.oJ, this.oK, this.oL, this.oC, this.oM, Float.valueOf(this.oN));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.oJ == locationRequest.oJ && this.oK == locationRequest.oK && this.oL == locationRequest.oL && this.oC == locationRequest.oC && this.oM == locationRequest.oM && this.oN == locationRequest.oN;
    }

    int getVersionCode() {
        return this.iM;
    }
}

