/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.internal;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public final class AudioUtils {
    private AudioUtils() {
    }

    public static void playSound(JComponent c, Object actionKey) {
        Action audioAction;
        ActionMap map;
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof BasicLookAndFeel && (map = c.getActionMap()) != null && (audioAction = map.get(actionKey)) != null) {
            AudioUtils.playSound(audioAction);
        }
    }

    public static void installSharedActionMap(JComponent c, String defaultsKey) {
        ActionMap map = (ActionMap)UIManager.get(defaultsKey);
        if (map == null) {
            map = new ActionMapUIResource();
            AudioUtils.installAudioActionMap(map);
            UIManager.getLookAndFeelDefaults().put(defaultsKey, map);
        }
        SwingUtilities.replaceUIActionMap(c, map);
    }

    static void installAudioActionMap(ActionMap map) {
        Method method;
        Class<?> clazz;
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (!"JGoodies Windows".equals(laf.getName())) {
            return;
        }
        try {
            clazz = Class.forName("com.jgoodies.looks.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            method = clazz.getDeclaredMethod("getAudioActionMap", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            ActionMap parentMap = (ActionMap)method.invoke((Object)laf, new Object[0]);
            map.setParent(parentMap);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    private static void playSound(Action audioAction) {
        Object[] audioStrings = (Object[])UIManager.get("AuditoryCues.playList");
        if (audioAction == null || audioStrings == null) {
            return;
        }
        String actionName = (String)audioAction.getValue("Name");
        for (Object audioString : audioStrings) {
            if (!audioString.equals(actionName)) continue;
            audioAction.actionPerformed(new ActionEvent(AudioUtils.class, 1001, actionName));
        }
    }
}

