/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.RollingMethods;
import plugin.initiative.DiceRollModel;

public class DiceRollDialog
extends JDialog {
    DiceRollModel m_model = null;
    protected JButton m_ok;
    protected JButton m_doRoll;
    protected JLabel m_result;
    protected JTextField m_roll;
    protected List<Component> m_fields = new ArrayList<Component>();
    protected List<Component> m_labels = new ArrayList<Component>();
    protected JPanel m_buttons;
    protected JPanel m_mainPanel;
    protected JPanel m_fieldPanel;
    protected JPanel m_labelPanel;

    public DiceRollDialog(DiceRollModel model) throws HeadlessException {
        this.m_model = model;
        this.initComponents();
    }

    protected void handleOk(ActionEvent e) {
        this.setVisible(false);
    }

    protected void handleRoll(ActionEvent e) {
        this.setResult(RollingMethods.roll((String)this.m_roll.getText()));
    }

    protected void initComponents() {
        this.setTitle(this.m_model.toString());
        this.addRollField("Roll:");
        this.initResult("Result:");
        this.initPanels();
        this.initButtons();
        this.initListeners();
        this.sizeAndLocate();
    }

    protected void sizeAndLocate() {
        this.pack();
        this.setLocationRelativeTo((Component)GMGenSystem.inst);
    }

    protected void initResult(String labelText) {
        this.m_result = new JLabel("<html><body><b>-</b></body></html>");
        this.m_result.setMinimumSize(new Dimension(100, (int)this.m_result.getMinimumSize().getWidth()));
        this.m_result.setPreferredSize(new Dimension(100, (int)this.m_result.getPreferredSize().getWidth()));
        JLabel label = null;
        label = new JLabel(labelText);
        label.setAlignmentX(1.0f);
        this.addComponent(this.m_result, label);
    }

    protected void initPanels() {
        this.m_mainPanel = new JPanel(new BorderLayout(5, 5));
        this.m_labelPanel = new JPanel(new GridLayout(0, 1));
        this.m_fieldPanel = new JPanel(new GridLayout(0, 1));
        for (Component label : this.m_labels) {
            this.m_labelPanel.add(label);
        }
        for (Component field : this.m_fields) {
            this.m_fieldPanel.add(field);
        }
        this.m_mainPanel.add((Component)this.m_labelPanel, "Center");
        this.m_mainPanel.add((Component)this.m_fieldPanel, "East");
        this.getContentPane().add((Component)this.m_mainPanel, "Center");
    }

    protected void addRollField(String labelText) {
        this.m_roll = new JTextField(this.m_model.getExpression());
        JLabel label = new JLabel(labelText);
        label.setAlignmentX(1.0f);
        this.addComponent(this.m_roll, label);
    }

    protected void initButtons() {
        this.m_buttons = new JPanel();
        this.m_buttons.setLayout(new BoxLayout(this.m_buttons, 0));
        this.m_buttons.add(Box.createHorizontalGlue());
        this.m_doRoll = new JButton("Roll");
        this.m_buttons.add(this.m_doRoll);
        this.m_buttons.add(this.m_doRoll);
        this.m_buttons.add(Box.createHorizontalStrut(10));
        this.m_ok = new JButton("Ok");
        this.m_buttons.add(this.m_ok);
        this.getContentPane().add((Component)this.m_buttons, "South");
    }

    protected void initListeners() {
        this.m_doRoll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiceRollDialog.this.handleRoll(e);
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiceRollDialog.this.handleOk(e);
            }
        });
    }

    protected void addComponent(Component field, Component label) {
        this.m_fields.add(field);
        this.m_labels.add(label);
    }

    protected void setResult(int result) {
        this.m_result.setText("<html><body><b>" + result + "</b></body></html>");
    }
}

