/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.graph.base.Edge;
import pcgen.base.graph.base.Graph;
import pcgen.base.graph.base.GraphChangeListener;
import pcgen.base.graph.inst.GraphChangeSupport;

public abstract class AbstractListMapGraph<N, ET extends Edge<N>>
implements Graph<N, ET> {
    private final List<N> nodeList;
    private final List<ET> edgeList = new ArrayList<ET>();
    private final transient Map<N, Set<ET>> nodeEdgeMap;
    private final GraphChangeSupport<N, ET> gcs;

    public AbstractListMapGraph() {
        this.nodeList = new ArrayList<N>();
        this.gcs = new GraphChangeSupport(this);
        this.nodeEdgeMap = new HashMap<N, Set<ET>>();
    }

    @Override
    public boolean addNode(N node) {
        if (node == null) {
            return false;
        }
        if (this.nodeEdgeMap.containsKey(node)) {
            return false;
        }
        this.nodeList.add(node);
        this.nodeEdgeMap.put(node, new HashSet());
        this.gcs.fireGraphNodeChangeEvent(node, 0);
        return true;
    }

    public N getInternalizedNode(N node) {
        if (node == null) {
            return null;
        }
        if (this.nodeEdgeMap.containsKey(node)) {
            return this.nodeList.get(this.nodeList.indexOf(node));
        }
        return null;
    }

    @Override
    public boolean addEdge(ET edge) {
        if (edge == null) {
            return false;
        }
        if (this.edgeList.contains(edge)) {
            return false;
        }
        List graphNodes = edge.getAdjacentNodes();
        for (Object node : graphNodes) {
            this.addNode(node);
            this.nodeEdgeMap.get(node).add(edge);
        }
        this.edgeList.add(edge);
        this.gcs.fireGraphEdgeChangeEvent(edge, 0);
        return true;
    }

    @Override
    public boolean containsNode(Object node) {
        return this.nodeEdgeMap.containsKey(node);
    }

    @Override
    public boolean containsEdge(Edge<?> edge) {
        return this.edgeList.contains(edge);
    }

    @Override
    public List<N> getNodeList() {
        return new ArrayList<N>(this.nodeList);
    }

    @Override
    public List<ET> getEdgeList() {
        return new ArrayList<ET>(this.edgeList);
    }

    @Override
    public boolean removeNode(N node) {
        if (node == null) {
            return false;
        }
        if (!this.containsNode(node)) {
            return false;
        }
        for (Edge edge : this.nodeEdgeMap.remove(node)) {
            this.removeEdge(edge);
        }
        this.nodeList.remove(node);
        this.gcs.fireGraphNodeChangeEvent(node, 1);
        return true;
    }

    @Override
    public boolean removeEdge(ET edge) {
        if (edge == null) {
            return false;
        }
        List adjacentNodes = edge.getAdjacentNodes();
        for (Object node : adjacentNodes) {
            Set<ET> adjacentEdges = this.nodeEdgeMap.get(node);
            if (adjacentEdges == null) continue;
            adjacentEdges.remove(edge);
        }
        if (this.edgeList.remove(edge)) {
            this.gcs.fireGraphEdgeChangeEvent(edge, 1);
            return true;
        }
        return false;
    }

    @Override
    public Set<ET> getAdjacentEdges(N node) {
        Set<ET> adjacentEdges = this.nodeEdgeMap.get(node);
        return adjacentEdges == null ? null : new HashSet<ET>(adjacentEdges);
    }

    @Override
    public void addGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.gcs.addGraphChangeListener(listener);
    }

    @Override
    public GraphChangeListener<N, ET>[] getGraphChangeListeners() {
        return this.gcs.getGraphChangeListeners();
    }

    @Override
    public void removeGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.gcs.removeGraphChangeListener(listener);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph otherGraph = (Graph)other;
        List otherNodeList = otherGraph.getNodeList();
        int thisNodeSize = this.nodeList.size();
        if (thisNodeSize != otherNodeList.size()) {
            return false;
        }
        if ((otherNodeList = new ArrayList(otherNodeList)).retainAll(this.nodeList)) {
            return false;
        }
        List otherEdgeList = otherGraph.getEdgeList();
        int thisEdgeSize = this.edgeList.size();
        if (thisEdgeSize != otherEdgeList.size()) {
            return false;
        }
        return !(otherEdgeList = new ArrayList(otherEdgeList)).retainAll(this.edgeList);
    }

    @Override
    public int hashCode() {
        return this.nodeList.size() + this.edgeList.size() * 23;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeList.isEmpty() && this.edgeList.isEmpty();
    }

    @Override
    public int getNodeCount() {
        return this.nodeList.size();
    }

    @Override
    public void clear() {
        this.nodeEdgeMap.clear();
        this.nodeList.clear();
        this.edgeList.clear();
    }
}

