/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinSlider;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinSlider;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingConstants;

final class GtkSlider
extends AbstractSkinSlider
implements SkinSlider,
SwingConstants {
    DefaultButton h_track;
    DefaultButton v_track;
    DefaultButton h_thumb;
    DefaultButton v_thumb;

    public GtkSlider(GtkParser parser) throws Exception {
        this.h_thumb = GtkUtils.newButton(parser, "GtkRange", new String[]{"function", "orientation"}, new String[]{"SLIDER", "HORIZONTAL"}, true);
        this.v_thumb = GtkUtils.newButton(parser, "GtkRange", new String[]{"function", "orientation"}, new String[]{"SLIDER", "VERTICAL"}, true);
        this.h_track = GtkUtils.newButton(parser, "GtkRange", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "HORIZONTAL"});
        this.v_track = GtkUtils.newButton(parser, "GtkRange", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "VERTICAL"});
    }

    public Dimension getPreferredSize(JSlider slider, Dimension uiPreferredSize) {
        if (slider.getOrientation() == 0) {
            uiPreferredSize.height = Math.max(uiPreferredSize.height, this.h_thumb.getHeight());
        } else {
            uiPreferredSize.width = Math.max(uiPreferredSize.width, this.v_thumb.getWidth());
        }
        return uiPreferredSize;
    }

    public Dimension getThumbSize(JSlider slider) {
        if (this.h_thumb != null) {
            if (slider.getOrientation() == 0) {
                return this.h_thumb.getPreferredSize();
            }
            return this.v_thumb.getPreferredSize();
        }
        return null;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        c.setOpaque(false);
        return true;
    }

    public boolean paintTrack(Graphics g, JSlider slider, Rectangle trackBounds) {
        if (this.h_track != null) {
            if (slider.getOrientation() == 0) {
                this.h_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, slider);
            } else {
                this.v_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, slider);
            }
            return true;
        }
        return false;
    }

    public boolean paintThumb(Graphics g, JSlider slider, Rectangle thumbBounds) {
        if (this.h_thumb != null) {
            if (slider.getOrientation() == 0) {
                this.h_thumb.paint(g, 0, 0, this.h_thumb.getWidth(), this.h_thumb.getHeight(), slider);
            } else {
                this.v_thumb.paint(g, 0, 0, this.v_thumb.getWidth(), this.v_thumb.getHeight(), slider);
            }
            return true;
        }
        return false;
    }
}

