/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.InitHolder;
import gmgen.plugin.State;
import gmgen.plugin.SystemInitiative;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import pcgen.util.Logging;

public class Event
implements InitHolder {
    public SystemInitiative init;
    protected String effect;
    protected String name;
    protected String player;
    protected State status = State.Active;
    protected boolean alert;
    protected int duration;

    public Event(String name, String player, String effect, int duration, int init, boolean alert) {
        this.setValues(name, player, this.status, effect, duration, init, alert);
    }

    public Event(String name, String player, State status, String effect, int duration, int init, boolean alert) {
        this.setValues(name, player, status, effect, duration, init, alert);
    }

    public Event() {
    }

    public Event(Element event) {
        try {
            String aName = event.getAttribute("name").getValue();
            String aPlayer = event.getAttribute("player").getValue();
            State aStatus = State.getState(event.getAttribute("status").getValue());
            String anEffect = event.getAttribute("effect").getValue();
            int aDuration = event.getChild("Initiative").getAttribute("duration").getIntValue();
            int anInit = event.getChild("Initiative").getAttribute("initiative").getIntValue();
            boolean anAlert = event.getChild("Initiative").getAttribute("alert").getBooleanValue();
            this.setValues(aName, aPlayer, aStatus, anEffect, aDuration, anInit, anAlert);
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public String getEffect() {
        return this.effect;
    }

    public String getEndText() {
        return MessageFormat.format("Event {0} Completed or Occurred", this.getName());
    }

    @Override
    public SystemInitiative getInitiative() {
        return this.init;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    @Override
    public String getPlayer() {
        return this.player;
    }

    @Override
    public Vector<Object> getRowVector(List<String> columnOrder) {
        Vector<Object> rowVector = new Vector<Object>();
        for (String columnName : columnOrder) {
            if (columnName.equals("Name")) {
                rowVector.add(this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add("Owner: " + this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add((Object)this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                rowVector.add("" + this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add("");
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add("-");
        }
        return rowVector;
    }

    @Override
    public Element getSaveElement() {
        Element retElement = new Element("Event");
        Element initiative = new Element("Initiative");
        initiative.setAttribute("initiative", this.init.getCurrentInitiative() + "");
        initiative.setAttribute("duration", this.getDuration() + "");
        initiative.setAttribute("alert", this.isAlert() + "");
        retElement.addContent((Content)initiative);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus().name());
        retElement.setAttribute("effect", this.getEffect());
        return retElement;
    }

    @Override
    public void setStatus(State status) {
        this.status = status;
    }

    @Override
    public State getStatus() {
        return this.status;
    }

    public int decDuration() {
        --this.duration;
        return this.duration;
    }

    @Override
    public void editRow(List<String> columnOrder, int colNumber, Object data) {
        String columnName = columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus(State.getStateLocalised(strData));
        } else if (columnName.equals("Init")) {
            Integer intData = Integer.valueOf(strData);
            this.init.setCurrentInitiative(intData);
        } else if (columnName.equals("Dur")) {
            Integer intData = Integer.valueOf(strData);
            this.setDuration(intData);
        }
    }

    @Override
    public void endRound() {
    }

    protected final void setValues(String name, String player, State status, String effect, int duration, int init, boolean alert) {
        this.name = name;
        this.player = player;
        this.effect = effect;
        this.duration = duration;
        this.init = new SystemInitiative(0);
        this.init.setCurrentInitiative(init);
        this.alert = alert;
        this.status = status;
    }
}

