/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.base.util.FormatManager;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.content.UserContent;
import pcgen.rules.context.LoadContext;
import pcgen.util.StringPClassUtil;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public abstract class ContentDefinition<T extends CDOMObject, F>
extends UserContent
implements Loadable {
    private String displayName;
    private Class<T> usableLocation;
    private FormatManager<F> formatManager;
    private Visibility visibility;
    private Boolean selectable;
    private Boolean required;

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Display Name cannot be null");
        }
        this.displayName = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setUsableLocation(Class<? extends Loadable> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Usable Location cannot be null");
        }
        this.usableLocation = cl;
    }

    public Class<T> getUsableLocation() {
        return this.usableLocation;
    }

    public FormatManager<?> setFormatManager(FormatManager<F> fmtMgr) {
        if (fmtMgr == null) {
            throw new IllegalArgumentException("Format Manager cannot be null");
        }
        FormatManager<F> returnValue = this.formatManager;
        this.formatManager = fmtMgr;
        return returnValue;
    }

    public FormatManager<F> getFormatManager() {
        return this.formatManager;
    }

    public void setVisibility(Visibility vis) {
        this.visibility = vis;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setSelectable(boolean set) {
        this.selectable = set;
    }

    public Boolean getSelectable() {
        return this.selectable;
    }

    public void setRequired(boolean set) {
        if (set && CDOMObject.class.equals(this.usableLocation)) {
            throw new UnsupportedOperationException("Global ContentDefinition cannot be required");
        }
        this.required = set;
    }

    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public String getLSTformat() {
        String loc = CDOMObject.class.equals(this.usableLocation) ? "GLOBAL" : StringPClassUtil.getStringFor(this.usableLocation);
        return loc + "|" + this.getKeyName();
    }

    public void activate(LoadContext context) {
        Visibility vis;
        this.activateKey();
        Visibility visibility = vis = this.visibility == null ? Visibility.HIDDEN : this.visibility;
        if (vis.isVisibleTo(View.VISIBLE_EXPORT)) {
            this.activateOutput();
        }
        this.activateTokens(context);
    }

    protected abstract void activateKey();

    protected abstract void activateOutput();

    protected abstract void activateTokens(LoadContext var1);
}

