/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import pcgen.base.util.RandomUtil;
import pcgen.util.Logging;

public final class RollingMethods {
    public static int roll(int times, int sides) {
        return RollingMethods.roll(times, sides, times, 0, 0);
    }

    public static int roll(int sides) {
        return RandomUtil.getRandomInt(sides) + 1;
    }

    public static int roll(int times, int sides, int[] keep) {
        int[] rolls = new int[times];
        while (--times >= 0) {
            rolls[times] = RandomUtil.getRandomInt(sides);
        }
        Arrays.sort(rolls);
        int total = keep.length;
        for (int i = 0; i < keep.length; ++i) {
            total += rolls[keep[i]];
        }
        return total;
    }

    public static int roll(int times, int[] shape) {
        int total = 0;
        while (--times >= 0) {
            total += shape[RandomUtil.getRandomInt(shape.length)];
        }
        return total;
    }

    public static int roll(int times, int[] shape, int[] keep) {
        int[] rolls = new int[times];
        while (--times >= 0) {
            rolls[times] = shape[RandomUtil.getRandomInt(shape.length)];
        }
        Arrays.sort(rolls);
        int total = 0;
        for (int i = 0; i < keep.length; ++i) {
            total += rolls[keep[i]];
        }
        return total;
    }

    private static int getLeftIndex(StringBuilder expression, int startIndex) {
        int parenth = 0;
        while (--startIndex >= 0) {
            char c = expression.charAt(startIndex);
            if (c == ')') {
                ++parenth;
            } else if (c == '(') {
                --parenth;
            }
            if (parenth > 0 || c == 'd' || c == '*' || c == '/' || c == ' ' || Character.isDigit(c)) continue;
        }
        return startIndex + 1;
    }

    private static int getRightIndex(StringBuilder expression, int startIndex) {
        int parenth = 0;
        while (++startIndex < expression.length()) {
            char c = expression.charAt(startIndex);
            if (c == '(') {
                ++parenth;
            } else if (c == ')') {
                --parenth;
            }
            if (parenth > 0 || c == '*' || c == '/' || c == ' ' || Character.isDigit(c)) continue;
        }
        return startIndex;
    }

    public static int roll(String method) {
        int r = 0;
        if (method.length() <= 0) {
            return r;
        }
        StringBuilder expression = new StringBuilder(method.replaceAll("d%", "1d100"));
        int index = expression.lastIndexOf("d");
        while (index != -1) {
            expression.insert(RollingMethods.getRightIndex(expression, index), ')');
            expression.setCharAt(index, ',');
            expression.insert(RollingMethods.getLeftIndex(expression, index), "roll(");
            index = expression.lastIndexOf("d", index + 4);
        }
        String exp = expression.toString();
        exp = exp.replaceAll("\\[", "list(").replaceAll("\\]", ")");
        JEP jep = new JEP();
        jep.addStandardFunctions();
        jep.addFunction("roll", (PostfixMathCommandI)new Roll());
        jep.addFunction("top", (PostfixMathCommandI)new Top());
        jep.addFunction("reroll", (PostfixMathCommandI)new Reroll());
        jep.addFunction("list", (PostfixMathCommandI)new List());
        jep.parseExpression(exp);
        if (!jep.hasError()) {
            r = (int)jep.getValue();
        } else {
            Logging.errorPrint("Bad dice: " + expression + ":" + jep.getErrorInfo());
        }
        return r;
    }

    private static int roll(int times, int sides, int numToKeep, int reroll, int modifier) {
        int[] dieRoll = new int[times];
        int total = 0;
        int keep = numToKeep > times ? times : numToKeep;
        for (int i = 0; i < times; ++i) {
            dieRoll[i] = RollingMethods.roll(sides - reroll) + reroll;
        }
        Arrays.sort(dieRoll);
        if (Logging.isDebugMode()) {
            StringBuilder rollString = new StringBuilder(times << 2);
            rollString.append(dieRoll[0]);
            if (times > 1) {
                for (int i = 1; i < times; ++i) {
                    rollString.append(" + ").append(dieRoll[i]);
                }
            }
            Logging.debugPrint(rollString.toString());
        }
        for (int j = times - keep; j < times; ++j) {
            total += dieRoll[j];
        }
        return total + modifier;
    }

    private static class Reroll
    extends PostfixMathCommand {
        public Reroll() {
            this.numberOfParameters = 1;
        }

        public void run(Stack inStack) throws ParseException {
            int iRolls;
            Object param = inStack.pop();
            if (param instanceof Double) {
                double dRolls = (Double)param;
                if (dRolls > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                iRolls = (int)Math.round(dRolls);
                if (iRolls <= 0) {
                    throw new ParseException("Values less than 1 are not allowed");
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            inStack.push(new Rerolls(iRolls));
        }

        public static class Rerolls {
            private Integer rolls;

            public Rerolls(Integer rolls) {
                this.rolls = rolls;
            }

            public Integer getRolls() {
                return this.rolls;
            }
        }
    }

    private static class Top
    extends PostfixMathCommand {
        public Top() {
            this.numberOfParameters = 1;
        }

        public void run(Stack inStack) throws ParseException {
            int iRolls;
            Object param = inStack.pop();
            if (param instanceof Double) {
                double dRolls = (Double)param;
                if (dRolls > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                iRolls = (int)Math.round(dRolls);
                if (iRolls <= 0) {
                    throw new ParseException("Values less than 1 are not allowed");
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            inStack.push(new TopRolls(iRolls));
        }

        public static class TopRolls {
            private Integer rolls;

            public TopRolls(Integer rolls) {
                this.rolls = rolls;
            }

            public Integer getRolls() {
                return this.rolls;
            }
        }
    }

    private static class Roll
    extends PostfixMathCommand {
        public Roll() {
            this.numberOfParameters = -1;
        }

        public void run(Stack inStack) throws ParseException {
            int iFaces;
            int iRolls;
            this.checkStack(inStack);
            if (this.curNumberOfParameters < 2) {
                throw new ParseException("Too few parameters");
            }
            if (this.curNumberOfParameters > 4) {
                throw new ParseException("Too many parameters");
            }
            int numToKeep = 0;
            int[] keep = null;
            int reroll = 0;
            while (this.curNumberOfParameters > 2) {
                Object param = inStack.pop();
                if (param instanceof Top.TopRolls && numToKeep == 0) {
                    numToKeep = ((Top.TopRolls)param).getRolls();
                } else if (param instanceof Reroll.Rerolls && reroll == 0) {
                    reroll = ((Reroll.Rerolls)param).getRolls();
                } else if (param instanceof Vector && this.curNumberOfParameters == 3) {
                    if (numToKeep != 0) {
                        throw new ParseException("Redundant Arugments");
                    }
                    if (reroll != 0) {
                        throw new ParseException("Reroll not compatable with older syntax, use top(NUMBER) instead");
                    }
                    Vector vec = (Vector)param;
                    keep = new int[vec.size()];
                    for (int x = 0; x < vec.size(); ++x) {
                        keep[x] = (int)Math.round((Double)vec.get(x)) - 1;
                    }
                } else {
                    throw new ParseException("Invalid parameter type");
                }
                --this.curNumberOfParameters;
            }
            Object faces = inStack.pop();
            Object numberOfRolls = inStack.pop();
            if (faces instanceof Vector) {
                Vector vec = (Vector)faces;
                faces = vec.get(RandomUtil.getRandomInt(vec.size()));
            }
            if (faces instanceof Double && numberOfRolls instanceof Double) {
                double dRolls = (Double)numberOfRolls;
                double dFaces = (Double)faces;
                if (dRolls > 2.147483647E9 || dFaces > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                iRolls = (int)Math.round((Double)numberOfRolls);
                iFaces = (int)Math.round((Double)faces);
                if (numToKeep == 0) {
                    numToKeep = iRolls;
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            double result = 0.0;
            result = keep == null ? (double)RollingMethods.roll(iRolls, iFaces, numToKeep, reroll, 0) : (double)RollingMethods.roll(iRolls, iFaces, keep);
            inStack.push(new Double(result));
        }
    }
}

