/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.equip;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.SpellBuilderFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.util.FacadeListModel;
import pcgen.system.LanguageBundle;

public class SpellChoicePanel
extends JPanel {
    private final JComboBox classComboBox;
    private final JComboBox spellLevelComboBox;
    private final JComboBox spellComboBox;
    private final JComboBox variantComboBox;
    private final JComboBox casterLevelComboBox;
    private final JComboBox spellTypeComboBox;
    private final JList metamagicList;
    private CharacterComboBoxModel<InfoFacade> classModel;
    private CharacterComboBoxModel<Integer> spellLevelModel;
    private CharacterComboBoxModel<InfoFacade> spellModel;
    private CharacterComboBoxModel<String> variantModel;
    private CharacterComboBoxModel<Integer> casterLevelModel;
    private CharacterComboBoxModel<String> spellTypeModel;
    private SpellBuilderFacade spellBuilderFacade;
    private MetamagicFeatListModel metamgicModel;

    public SpellChoicePanel(SpellBuilderFacade spellBuilderFacade) {
        this.spellBuilderFacade = spellBuilderFacade;
        this.classComboBox = new JComboBox();
        this.spellLevelComboBox = new JComboBox();
        this.spellComboBox = new JComboBox();
        this.variantComboBox = new JComboBox();
        this.casterLevelComboBox = new JComboBox();
        this.spellTypeComboBox = new JComboBox();
        this.metamagicList = new JList();
        this.initModels();
        this.initComponents();
    }

    private void initModels() {
        this.classModel = new CharacterComboBoxModel<InfoFacade>(){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setClass((InfoFacade)anItem);
            }
        };
        this.classModel.setListFacade(this.spellBuilderFacade.getClasses());
        this.classModel.setReference(this.spellBuilderFacade.getClassRef());
        this.classComboBox.setModel(this.classModel);
        this.spellLevelModel = new CharacterComboBoxModel<Integer>(){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setSpellLevel((Integer)anItem);
            }
        };
        this.spellLevelModel.setListFacade(this.spellBuilderFacade.getLevels());
        this.spellLevelModel.setReference(this.spellBuilderFacade.getSpellLevelRef());
        this.spellLevelComboBox.setModel(this.spellLevelModel);
        this.spellModel = new CharacterComboBoxModel<InfoFacade>(){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setSpell((InfoFacade)anItem);
            }
        };
        this.spellModel.setListFacade(this.spellBuilderFacade.getSpells());
        this.spellModel.setReference(this.spellBuilderFacade.getSpellRef());
        this.spellComboBox.setModel(this.spellModel);
        this.variantModel = new DisablingCharacterComboBoxModel(this.variantComboBox){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setVariant((String)anItem);
            }
        };
        this.variantModel.setListFacade(this.spellBuilderFacade.getVariants());
        this.variantModel.setReference(this.spellBuilderFacade.getVariantRef());
        this.variantComboBox.setModel(this.variantModel);
        this.casterLevelModel = new CharacterComboBoxModel<Integer>(){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setCasterLevel((Integer)anItem);
            }
        };
        this.casterLevelModel.setListFacade(this.spellBuilderFacade.getCasterLevels());
        this.casterLevelModel.setReference(this.spellBuilderFacade.getCasterLevelRef());
        this.casterLevelComboBox.setModel(this.casterLevelModel);
        this.spellTypeModel = new CharacterComboBoxModel<String>(){

            @Override
            public void setSelectedItem(Object anItem) {
                SpellChoicePanel.this.spellBuilderFacade.setSpellType((String)anItem);
            }
        };
        this.spellTypeModel.setListFacade(this.spellBuilderFacade.getSpellTypes());
        this.spellTypeModel.setReference(this.spellBuilderFacade.getSpellTypeRef());
        this.spellTypeComboBox.setModel(this.spellTypeModel);
        this.metamgicModel = new MetamagicFeatListModel();
        this.metamgicModel.setListFacade(this.spellBuilderFacade.getAvailMetamagicFeats());
        this.metamagicList.setModel(this.metamgicModel);
        this.metamagicList.addListSelectionListener(this.metamgicModel);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.addGridBagLayer(this, "in_sumClass", this.classComboBox);
        this.addGridBagLayer(this, "in_csdSpLvl", this.spellLevelComboBox);
        this.spellComboBox.setPrototypeDisplayValue("PrototypeDisplayValueForAVeryLongSpellName");
        this.addGridBagLayer(this, "in_spellName", this.spellComboBox);
        this.addGridBagLayer(this, "in_csdVariant", this.variantComboBox);
        if (this.metamgicModel.getSize() > 0) {
            this.metamagicList.setSelectionMode(2);
            this.metamagicList.setVisibleRowCount(4);
            JScrollPane listScroller = new JScrollPane(this.metamagicList);
            listScroller.setPreferredSize(new Dimension(250, 80));
            this.addGridBagLayer(this, "in_metaFeat", listScroller);
        }
        this.addGridBagLayer(this, "in_casterLvl", this.casterLevelComboBox);
        this.addGridBagLayer(this, "in_csdSpellType", this.spellTypeComboBox);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    private void addGridBagLayer(JPanel panel, String text, JComponent comp) {
        Insets insets = new Insets(0, 0, 3, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(LanguageBundle.getString(text));
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        panel.add((Component)label, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        if (insets != null) {
            gbc.insets = insets;
        }
        panel.add((Component)comp, gbc);
    }

    private class MetamagicFeatListModel
    extends FacadeListModel<AbilityFacade>
    implements ListSelectionListener {
        private MetamagicFeatListModel() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            List selectedValues = SpellChoicePanel.this.metamagicList.getSelectedValuesList();
            SpellChoicePanel.this.spellBuilderFacade.setSelectedMetamagicFeats(selectedValues.toArray());
        }
    }

    private abstract class DisablingCharacterComboBoxModel
    extends CharacterComboBoxModel<String> {
        private JComboBox box;

        DisablingCharacterComboBoxModel(JComboBox box) {
            this.box = box;
        }

        @Override
        public void elementsChanged(ListEvent<String> e) {
            super.elementsChanged(e);
            this.box.setEnabled(this.getSize() > 0);
        }
    }
}

