/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeViewTable;

class ClassInfoHandler
implements ListSelectionListener {
    private CharacterFacade character;
    private final JTreeViewTable<?> availableTable;
    private final JTreeViewTable<?> selectedTable;
    private final InfoPane classPane;
    private String text;

    public ClassInfoHandler(CharacterFacade character, JTreeViewTable<?> table1, JTreeViewTable<?> table2, InfoPane classPane) {
        this.character = character;
        this.classPane = classPane;
        this.availableTable = table1;
        this.selectedTable = table2;
        this.text = "";
    }

    public void install() {
        this.availableTable.getSelectionModel().addListSelectionListener(this);
        this.selectedTable.getSelectionModel().addListSelectionListener(this);
        this.classPane.setText(this.text);
    }

    public void uninstall() {
        this.availableTable.getSelectionModel().removeListSelectionListener(this);
        this.selectedTable.getSelectionModel().removeListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object[] objs;
            TreePath path = e.getSource() == this.availableTable.getSelectionModel() ? this.availableTable.getTree().getSelectionPath() : this.selectedTable.getTree().getSelectionPath();
            if (path == null) {
                return;
            }
            ClassFacade c = null;
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)path.getLastPathComponent();
            for (Object object : objs = treenode.getUserObjectPath()) {
                if (!(object instanceof ClassFacade)) continue;
                c = (ClassFacade)object;
                break;
            }
            if (c != null) {
                this.text = this.character.getSpellSupport().getClassInfo(c);
                this.classPane.setText(this.text);
            }
        }
    }
}

