/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.filters.CharacterFilter;
import pcgen.io.filters.OutputFilter;
import pcgen.io.filters.PatternFilter;

public final class FileAccess {
    private static OutputFilter outputFilter = null;
    private static int maxLength = -1;

    public static String filterString(String aString) {
        String outputString = aString;
        if (outputFilter != null) {
            outputString = outputFilter.filterString(aString);
        }
        return outputString;
    }

    public static void setCurrentOutputFilter(String templateFilename) {
        try {
            outputFilter = new PatternFilter(templateFilename);
        }
        catch (IOException e) {
            outputFilter = new CharacterFilter(templateFilename);
        }
    }

    public static void setCurrentOutputFilter(OutputFilter filter) {
        outputFilter = filter;
    }

    public static void encodeWrite(Writer output, String aString) {
        FileAccess.write(output, FileAccess.filterString(aString));
    }

    public static void maxLength(int anInt) {
        maxLength = anInt;
    }

    public static void newLine(BufferedWriter output) {
        try {
            output.newLine();
        }
        catch (IOException exception) {
            ShowMessageDelegate.showMessageDialog(exception.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    public static void write(Writer output, String aString) {
        String outputString = aString;
        if (aString == null) {
            return;
        }
        if (maxLength > 0 && aString.length() > maxLength) {
            outputString = aString.substring(0, maxLength);
        }
        try {
            output.write(outputString);
        }
        catch (IOException exception) {
            ShowMessageDelegate.showMessageDialog(exception.getMessage(), "PCGen", MessageType.ERROR);
        }
    }
}

