/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.StatAnalysis;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class StatToken
extends Token {
    public static final String TOKENNAME = "STAT";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        if (aTok.countTokens() < 2) {
            Logging.errorPrint("Invalid STAT token:" + tokenSource, new Throwable());
            return "";
        }
        aTok.nextToken();
        int indexOfStat = Integer.parseInt(aTok.nextToken());
        if (indexOfStat < 0 || indexOfStat >= pc.getDisplay().getStatCount()) {
            return "";
        }
        ArrayList<PCStat> statList = new ArrayList<PCStat>(pc.getDisplay().getStatSet());
        PCStat stat = (PCStat)statList.get(indexOfStat);
        String findType = TOKENNAME;
        boolean useBase = false;
        boolean useLevel = false;
        int aLevel = 0;
        boolean useEquip = true;
        boolean useTemp = true;
        boolean usePost = true;
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if ("NAME".equals(token)) {
                return stat.getKeyName();
            }
            if ("LONGNAME".equals(token)) {
                return stat.getDisplayName();
            }
            if ("ISNONABILITY".equals(token)) {
                return pc.getDisplay().isNonAbility(stat) ? "Y" : "N";
            }
            if (TOKENNAME.equals(token)) {
                findType = TOKENNAME;
                continue;
            }
            if ("MOD".equals(token)) {
                findType = "MOD";
                continue;
            }
            if ("BASE".equals(token)) {
                useBase = true;
                continue;
            }
            if ("BASEMOD".equals(token)) {
                findType = "MOD";
                useBase = true;
                continue;
            }
            if ("NOTEMP".equals(token)) {
                useTemp = false;
                continue;
            }
            if ("NOTEMPMOD".equals(token)) {
                findType = "MOD";
                useTemp = false;
                continue;
            }
            if ("NOEQUIP".equals(token)) {
                useEquip = false;
                continue;
            }
            if ("NOPOST".equals(token)) {
                usePost = false;
                continue;
            }
            if (!"LEVEL".equals(token)) continue;
            try {
                aLevel = Integer.parseInt(aTok.nextToken());
            }
            catch (NumberFormatException nfe) {
                Logging.errorPrint("Malformed LEVEL.x tag");
            }
            useLevel = true;
        }
        retString = findType.equals("MOD") ? (useBase ? StatToken.getBaseModToken(pc, stat) : StatToken.getModToken(pc, stat, useTemp, useEquip, usePost, useLevel, aLevel)) : (useBase ? StatToken.getBaseToken(pc, stat) : StatToken.getStatToken(pc, stat, useTemp, useEquip, usePost, useLevel, aLevel));
        return retString;
    }

    public static String getStatToken(PlayerCharacter pc, PCStat stat, boolean useTemp, boolean useEquip, boolean usePost, boolean useLevel, int aLevel) {
        return StatToken.getStatToken(pc, stat, useTemp, useEquip, usePost, useLevel, aLevel, true);
    }

    public static String getStatToken(PlayerCharacter pc, PCStat stat, boolean useTemp, boolean useEquip, boolean usePost, boolean useLevel, int aLevel, boolean checkGameMode) {
        if (pc.getDisplay().isNonAbility(stat)) {
            return "*";
        }
        int aTotal = 0;
        aTotal = useLevel ? (useEquip && useTemp ? pc.getTotalStatAtLevel(stat, aLevel, usePost) : pc.getPartialStatAtLevel(stat, aLevel, usePost, useTemp, useEquip)) : (useEquip && useTemp ? pc.getTotalStatFor(stat) : StatAnalysis.getPartialStatFor(pc, stat, useTemp, useEquip));
        if (checkGameMode) {
            return SettingsHandler.getGame().getStatDisplayText(aTotal);
        }
        return Integer.toString(aTotal);
    }

    public static String getModToken(PlayerCharacter pc, PCStat stat, boolean useTemp, boolean useEquip, boolean usePost, boolean useLevel, int aLevel) {
        if (pc.getDisplay().isNonAbility(stat)) {
            return "+0";
        }
        int aTotal = Integer.parseInt(StatToken.getStatToken(pc, stat, useTemp, useEquip, usePost, useLevel, aLevel, false));
        int temp = pc.getModForNumber(aTotal, stat);
        return Delta.toString(temp);
    }

    public static String getBaseToken(PlayerCharacter pc, PCStat stat) {
        if (pc.getDisplay().isNonAbility(stat)) {
            return "*";
        }
        return Integer.toString(pc.getBaseStatFor(stat));
    }

    public static String getBaseModToken(PlayerCharacter pc, PCStat stat) {
        if (pc.getDisplay().isNonAbility(stat)) {
            return "+0";
        }
        int aTotal = Integer.parseInt(StatToken.getBaseToken(pc, stat));
        int temp = pc.getModForNumber(aTotal, stat);
        return Delta.toString(temp);
    }

    public static String getModToken(PlayerCharacter pc, PCStat stat) {
        return StatToken.getModToken(pc, stat, true, true, true, false, 0);
    }
}

