/*
 * Decompiled with CFR 0.152.
 */
package pcgen.pluginmgr;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pcgen.base.lang.UnreachableError;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.MessageHandlerManager;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.system.PCGenSettings;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public final class PluginManager
implements PluginLoader {
    private static PluginManager instance;
    private final Map<InteractivePlugin, Boolean> pluginMap = new TreeMap<InteractivePlugin, Boolean>(PLUGIN_PRIORITY_SORTER);
    private final List<PluginInfo> infoList = new ArrayList<PluginInfo>();
    private final MessageHandlerManager msgHandlerMgr = new MessageHandlerManager();
    public static final Comparator<InteractivePlugin> PLUGIN_PRIORITY_SORTER;

    private PluginManager() {
    }

    public static synchronized PluginManager getInstance() {
        if (instance == null) {
            instance = new PluginManager();
        }
        return instance;
    }

    public List<PluginInfo> getPluginInfoList() {
        return new ArrayList<PluginInfo>(this.infoList);
    }

    public void startAllPlugins() {
        PCGenMessageHandler dispatcher = this.msgHandlerMgr.getPostbox();
        for (InteractivePlugin plugin : this.pluginMap.keySet()) {
            if (!this.pluginMap.get(plugin).booleanValue()) continue;
            plugin.start(dispatcher);
            this.msgHandlerMgr.addMember(plugin);
        }
    }

    private String getLogName(Class<?> clazz, InteractivePlugin pl) {
        String logName = null;
        try {
            Field f = clazz.getField("LOG_NAME");
            logName = (String)f.get(pl);
        }
        catch (SecurityException e) {
            throw new UnreachableError("Access to Class " + clazz + " should not be prohibited", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableError("Access to Method LOG_NAME in Class " + clazz + " should not be prohibited", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Logging.errorPrint(clazz.getName() + " does not have LOG_NAME defined, " + "Plugin class implemented improperly");
        }
        catch (IllegalArgumentException e) {
            Logging.errorPrint(clazz.getName() + " does not have LOG_NAME defined to " + "take a Plugin as the argument, " + "Plugin class implemented improperly");
        }
        return logName;
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        InteractivePlugin pl = (InteractivePlugin)clazz.newInstance();
        String logName = this.getLogName(clazz, pl);
        String plName = pl.getPluginName();
        boolean load = PCGenSettings.GMGEN_OPTIONS_CONTEXT.getBoolean(logName + ".Load", true);
        if (logName == null || plName == null) {
            Logging.log(Logging.WARNING, "Plugin " + clazz.getCanonicalName() + " needs" + " 'name' property.");
        } else {
            this.infoList.add(new PluginInfo(logName, plName));
            this.pluginMap.put(pl, load);
        }
    }

    @Override
    public Class<?>[] getPluginClasses() {
        return new Class[]{InteractivePlugin.class};
    }

    public void addMember(PCGenMessageHandler handler) {
        this.msgHandlerMgr.addMember(handler);
    }

    public PCGenMessageHandler getPostbox() {
        return this.msgHandlerMgr.getPostbox();
    }

    static {
        PLUGIN_PRIORITY_SORTER = new Comparator<InteractivePlugin>(){

            @Override
            public int compare(InteractivePlugin arg0, InteractivePlugin arg1) {
                return Integer.valueOf(arg0.getPriority()).compareTo(arg1.getPriority());
            }
        };
    }

    public static class PluginInfo {
        public final String logName;
        public final String pluginName;

        private PluginInfo(String logName, String pluginName) {
            this.logName = logName;
            this.pluginName = pluginName;
        }
    }
}

