/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterStubFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.PartyFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.gui2.facade.PartyFacadeImpl;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.PluginManager;
import pcgen.pluginmgr.messages.PlayerCharacterWasLoadedMessage;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.system.RecentFileList;
import pcgen.util.Logging;

public class CharacterManager {
    private static final PartyFacadeImpl characters = new PartyFacadeImpl();
    private static final RecentFileList recentCharacters = new RecentFileList("recentCharacters");
    private static final RecentFileList recentParties = new RecentFileList("recentParties");
    private static final PCGenMessageHandler messageHandler = PluginManager.getInstance().getPostbox();

    private CharacterManager() {
    }

    public static CharacterFacade createNewCharacter(UIDelegate delegate, DataSetFacade dataset) {
        List<CampaignFacade> campaigns = ListFacades.wrap(dataset.getCampaigns());
        try {
            PlayerCharacter pc = new PlayerCharacter(false, campaigns);
            Globals.getPCList().add(pc);
            CharacterFacadeImpl character = new CharacterFacadeImpl(pc, delegate, dataset);
            String name = CharacterManager.createNewCharacterName();
            character.setName(name);
            characters.addElement(character);
            Logging.log(Logging.INFO, "Created new character " + name + ".");
            messageHandler.handleMessage(new PlayerCharacterWasLoadedMessage(delegate, pc));
            return character;
        }
        catch (Exception e) {
            Logging.errorPrint("Unable to create character with data " + dataset, e);
            delegate.showErrorMessage(LanguageBundle.getString("in_cmCreateErrorTitle"), LanguageBundle.getFormattedString("in_cmCreateErrorMessage", e.getMessage()));
            return null;
        }
    }

    public static ListFacade<File> getRecentCharacters() {
        return recentCharacters;
    }

    public static ListFacade<File> getRecentParties() {
        return recentParties;
    }

    public static CharacterFacade openCharacter(File file, UIDelegate delegate, DataSetFacade dataset) {
        PlayerCharacter newPC = CharacterManager.openPcInternal(file, delegate, dataset, false);
        if (newPC == null) {
            return null;
        }
        return CharacterManager.createChracterFacade(delegate, dataset, newPC);
    }

    public static PlayerCharacter openPlayerCharacter(File file, UIDelegate delegate, DataSetFacade dataset, boolean blockLoadedMessage) {
        PlayerCharacter newPC = CharacterManager.openPcInternal(file, delegate, dataset, blockLoadedMessage);
        if (newPC == null) {
            return null;
        }
        CharacterManager.createChracterFacade(delegate, dataset, newPC);
        return newPC;
    }

    private static PlayerCharacter openPcInternal(File file, UIDelegate delegate, DataSetFacade dataset, boolean blockLoadedMessage) {
        List<CampaignFacade> campaigns = ListFacades.wrap(dataset.getCampaigns());
        PCGIOHandler ioHandler = new PCGIOHandler();
        try {
            PlayerCharacter newPC = new PlayerCharacter(false, campaigns);
            newPC.setFileName(file.getAbsolutePath());
            ioHandler.read(newPC, file.getAbsolutePath());
            dataset.refreshEquipment();
            if (!CharacterManager.showLoadNotices(true, ioHandler.getErrors(), file.getName(), delegate)) {
                return null;
            }
            if (!CharacterManager.showLoadNotices(false, ioHandler.getWarnings(), file.getName(), delegate)) {
                return null;
            }
            Logging.log(Logging.INFO, "Loaded character " + newPC.getName() + " - " + file.getAbsolutePath());
            Globals.getPCList().add(newPC);
            if (!blockLoadedMessage) {
                messageHandler.handleMessage(new PlayerCharacterWasLoadedMessage(delegate, newPC));
            }
            return newPC;
        }
        catch (Exception e) {
            Logging.errorPrint("Unable to load character " + file, e);
            delegate.showErrorMessage(LanguageBundle.getString("in_cmLoadErrorTitle"), LanguageBundle.getFormattedString("in_cmLoadErrorMessage", file, e.getMessage()));
            return null;
        }
    }

    private static CharacterFacade createChracterFacade(UIDelegate delegate, DataSetFacade dataset, PlayerCharacter newPC) {
        CharacterFacadeImpl character = new CharacterFacadeImpl(newPC, delegate, dataset);
        characters.addElement(character);
        return character;
    }

    private static boolean showLoadNotices(boolean errors, List<String> warnings, String fileName, UIDelegate delegate) {
        Level lvl;
        if (warnings.isEmpty()) {
            return true;
        }
        HtmlInfoBuilder warningMsg = new HtmlInfoBuilder();
        if (errors) {
            warningMsg.append(LanguageBundle.getString("in_cmErrorStart"));
            Logging.errorPrint("The following errors were encountered while loading " + fileName);
            lvl = Logging.ERROR;
        } else {
            warningMsg.append(LanguageBundle.getString("in_cmWarnStart"));
            Logging.log(Logging.WARNING, "The following warnings were encountered while loading " + fileName);
            lvl = Logging.WARNING;
        }
        warningMsg.appendLineBreak();
        warningMsg.append("<UL>");
        for (String string : warnings) {
            warningMsg.appendLineBreak();
            warningMsg.append("<li>");
            warningMsg.append(string);
            warningMsg.append("</li>");
            Logging.log(lvl, "* " + string);
        }
        warningMsg.append("</UL>");
        warningMsg.appendLineBreak();
        if (errors) {
            warningMsg.append(LanguageBundle.getString("in_cmErrorEnd"));
            delegate.showErrorMessage(fileName, warningMsg.toString());
            return false;
        }
        warningMsg.append(LanguageBundle.getString("in_cmWarnEnd"));
        return delegate.showWarningConfirm(fileName, warningMsg.toString());
    }

    public static PartyFacade openParty(File file, UIDelegate delegate, DataSetFacade dataset) {
        Logging.log(Logging.INFO, "Loading party " + file.getAbsolutePath());
        PCGIOHandler ioHandler = new PCGIOHandler();
        for (File charFile : ioHandler.readCharacterFileList(file)) {
            CharacterManager.openCharacter(charFile, delegate, dataset);
        }
        characters.setFile(file);
        return characters;
    }

    public static SourceSelectionFacade getRequiredSourcesForParty(File pcpFile, UIDelegate delegate) {
        PCGIOHandler ioHandler = new PCGIOHandler();
        List<File> files = ioHandler.readCharacterFileList(pcpFile);
        if (files == null || files.isEmpty()) {
            return null;
        }
        GameModeFacade gameMode = null;
        HashSet<CampaignFacade> campaignSet = new HashSet<CampaignFacade>();
        for (File file : files) {
            SourceSelectionFacade selection = CharacterManager.getRequiredSourcesForCharacter(file, delegate);
            if (selection == null) {
                Logging.errorPrint("Failed to find sources in: " + file.getAbsolutePath());
                continue;
            }
            GameModeFacade game = selection.getGameMode().getReference();
            if (gameMode == null) {
                gameMode = game;
            } else if (gameMode != game) {
                Logging.errorPrint("Characters in " + pcpFile.getAbsolutePath() + " do not share the same game mode");
                return null;
            }
            for (CampaignFacade campaign : selection.getCampaigns()) {
                campaignSet.add(campaign);
            }
        }
        return FacadeFactory.createSourceSelection(gameMode, new ArrayList(campaignSet));
    }

    public static SourceSelectionFacade getRequiredSourcesForCharacter(File pcgFile, UIDelegate delegate) {
        if (!PCGFile.isPCGenCharacterFile(pcgFile)) {
            throw new IllegalArgumentException();
        }
        PCGIOHandler ioHandler = new PCGIOHandler();
        SourceSelectionFacade selection = ioHandler.readSources(pcgFile);
        if (!ioHandler.getErrors().isEmpty()) {
            for (String msg : ioHandler.getErrors()) {
                delegate.showErrorMessage("PCGen", msg);
                Logging.errorPrint(msg);
            }
            return null;
        }
        return selection;
    }

    public static boolean characterFilenameValid(CharacterFacade character) {
        if (character.getFileRef().getReference() == null || StringUtils.isEmpty(character.getFileRef().getReference().getName())) {
            return false;
        }
        File file = character.getFileRef().getReference();
        if (StringUtils.isBlank(file.getName())) {
            return false;
        }
        return !file.isDirectory() && (!file.exists() || file.canWrite());
    }

    public static boolean saveCharacter(CharacterFacade character) {
        File file = character.getFileRef().getReference();
        if (StringUtils.isBlank(file.getName())) {
            return false;
        }
        Logging.log(Logging.INFO, "Saving character " + character.getNameRef().getReference() + " - " + file.getAbsolutePath());
        if (character instanceof CharacterFacadeImpl) {
            UIDelegate delegate = character.getUIDelegate();
            try {
                ((CharacterFacadeImpl)character).save();
            }
            catch (NullPointerException e) {
                Logging.errorPrint("Could not save " + character.getNameRef().getReference(), e);
                delegate.showErrorMessage("PCGen", "Could not save " + character.getNameRef().getReference());
                return false;
            }
            catch (IOException e) {
                Logging.errorPrint("Could not save " + character.getNameRef().getReference(), e);
                delegate.showErrorMessage("PCGen", "Could not save " + character.getNameRef().getReference() + " due to the error:\n" + e.getMessage());
                return false;
            }
        } else {
            Logging.errorPrint("Could not save " + character.getNameRef().getReference() + " due to unexpected class of character: " + character.getClass().getCanonicalName());
            return false;
        }
        recentCharacters.addRecentFile(file);
        return true;
    }

    public static boolean saveCurrentParty() {
        File file = characters.getFileRef().getReference();
        if (file == null) {
            return false;
        }
        Logging.log(Logging.INFO, "Saving party " + file.getAbsolutePath());
        characters.save();
        return true;
    }

    public static void removeCharacter(CharacterFacade character) {
        characters.removeElement(character);
        character.closeCharacter();
        File charFile = character.getFileRef().getReference();
        recentCharacters.addRecentFile(charFile);
        if (characters.isEmpty()) {
            recentParties.addRecentFile(characters.getFileRef().getReference());
            characters.setFile(null);
        }
        Logging.log(Logging.INFO, "Closed character " + character.getNameRef().getReference() + " - " + charFile.getAbsolutePath());
    }

    public static void removeAllCharacters() {
        for (CharacterFacade characterFacade : characters) {
            recentCharacters.addRecentFile(characterFacade.getFileRef().getReference());
            characterFacade.closeCharacter();
        }
        characters.clearContents();
        recentParties.addRecentFile(characters.getFileRef().getReference());
        characters.setFile(null);
        Logging.log(Logging.INFO, "Closed all characters");
    }

    public static PartyFacade getCharacters() {
        return characters;
    }

    public static CharacterFacade getCharacterMatching(CharacterStubFacade companion) {
        File compFile = companion.getFileRef().getReference();
        if (compFile == null || StringUtils.isEmpty(compFile.getName())) {
            String compName = companion.getNameRef().getReference();
            for (CharacterFacade character : CharacterManager.getCharacters()) {
                String charName = character.getNameRef().getReference();
                if (!ObjectUtils.equals(compName, charName)) continue;
                return character;
            }
        } else {
            for (CharacterFacade character : CharacterManager.getCharacters()) {
                File charFile = character.getFileRef().getReference();
                if (!compFile.equals(charFile)) continue;
                return character;
            }
        }
        return null;
    }

    private static String createNewCharacterName() {
        String name = "Unnamed ";
        int i = 1;
        while (CharacterManager.isNameUsed(name + i)) {
            ++i;
        }
        return name + i;
    }

    private static boolean isNameUsed(String name) {
        for (CharacterFacade character : characters) {
            if (!character.getNameRef().getReference().equals(name)) continue;
            return true;
        }
        return false;
    }
}

