/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ListMatchingReference;
import pcgen.cdom.reference.ObjectMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.FollowerOption;
import pcgen.core.Race;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class CompanionListLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    private static final String COMPANIONLIST = "COMPANIONLIST";
    private static final String FOLLOWERADJUSTMENT = "FOLLOWERADJUSTMENT";

    @Override
    public String getTokenName() {
        return COMPANIONLIST;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        String companionType = tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " requires more than just a Type: " + value, context);
        }
        String list = tok.nextToken();
        ParseResult pr = this.checkForIllegalSeparator(',', list);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer subTok = new StringTokenizer(list, ",");
        HashSet<CDOMReference<Race>> races = new HashSet<CDOMReference<Race>>();
        boolean foundAny = false;
        while (subTok.hasMoreTokens()) {
            String tokString = subTok.nextToken();
            if ("ANY".equalsIgnoreCase(tokString)) {
                foundAny = true;
                races.add(context.getReferenceContext().getCDOMAllReference(Race.class));
                continue;
            }
            if (tokString.startsWith("RACETYPE=")) {
                String raceType = tokString.substring(9);
                if (raceType.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " Error: RaceType was not specified.", context);
                }
                races.add(new ObjectMatchingReference<Race, RaceType>(tokString, Race.class, context.getReferenceContext().getCDOMAllReference(Race.class), ObjectKey.RACETYPE, RaceType.getConstant(raceType)));
                continue;
            }
            if (tokString.startsWith("RACESUBTYPE=")) {
                String raceSubType = tokString.substring(12);
                if (raceSubType.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " Error: RaceSubType was not specified.", context);
                }
                races.add(new ListMatchingReference<Race, RaceSubType>(tokString, Race.class, context.getReferenceContext().getCDOMAllReference(Race.class), ListKey.RACESUBTYPE, RaceSubType.getConstant(raceSubType)));
                continue;
            }
            if (this.looksLikeAPrerequisite(tokString)) {
                return new ParseResult.Fail(this.getTokenName() + " Error: " + tokString + " found where companion race expected.", context);
            }
            races.add(context.getReferenceContext().getCDOMReference(Race.class, tokString));
        }
        if (foundAny && races.size() > 1) {
            return new ParseResult.Fail("Non-sensical Race List includes Any and specific races: " + value, context);
        }
        if (!tok.hasMoreTokens()) {
            this.finish(context, obj, companionType, races, null, null);
            return ParseResult.SUCCESS;
        }
        Integer followerAdjustment = null;
        String optArg = tok.nextToken();
        while (true) {
            if (optArg.startsWith(FOLLOWERADJUSTMENT)) {
                if (followerAdjustment != null) {
                    return new ParseResult.Fail(this.getTokenName() + " Error: Multiple " + FOLLOWERADJUSTMENT + " tags specified.", context);
                }
                int faStringLength = FOLLOWERADJUSTMENT.length();
                if (optArg.length() <= faStringLength + 1) {
                    return new ParseResult.Fail("Empty FOLLOWERADJUSTMENT value in " + this.getTokenName() + " is prohibited", context);
                }
                String adj = optArg.substring(faStringLength + 1);
                try {
                    followerAdjustment = Integer.valueOf(adj);
                }
                catch (NumberFormatException nfe) {
                    ComplexParseResult cpr = new ComplexParseResult();
                    cpr.addErrorMessage("Expecting a number for FOLLOWERADJUSTMENT: " + adj);
                    cpr.addErrorMessage("  was parsing Token " + this.getTokenName());
                    return cpr;
                }
            } else {
                if (this.looksLikeAPrerequisite(optArg)) break;
                return new ParseResult.Fail(this.getTokenName() + ": Unknown argument (was expecting FOLLOWERADJUSTMENT: or PRExxx): " + optArg, context);
            }
            if (!tok.hasMoreTokens()) {
                this.finish(context, obj, companionType, races, followerAdjustment, null);
                return ParseResult.SUCCESS;
            }
            optArg = tok.nextToken();
        }
        ArrayList<Prerequisite> prereqs = new ArrayList<Prerequisite>();
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(optArg)) == null) {
                return new ParseResult.Fail("   (Did you put items after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            prereqs.add(prereq);
            if (!tok.hasMoreTokens()) break;
            optArg = tok.nextToken();
        }
        this.finish(context, obj, companionType, races, followerAdjustment, prereqs);
        return ParseResult.SUCCESS;
    }

    private void finish(LoadContext context, CDOMObject obj, String companionType, Set<CDOMReference<Race>> races, Integer followerAdjustment, List<Prerequisite> prereqs) {
        context.getReferenceContext().constructIfNecessary(CompanionList.class, companionType);
        CDOMSingleRef<CompanionList> ref = context.getReferenceContext().getCDOMReference(CompanionList.class, companionType);
        for (CDOMReference<Race> race : races) {
            FollowerOption option = new FollowerOption(race, ref);
            if (prereqs != null && !prereqs.isEmpty()) {
                option.addAllPrerequisites(prereqs);
            }
            if (followerAdjustment != null && followerAdjustment != 0) {
                option.setAdjustment(followerAdjustment);
            }
            context.getObjectContext().addToList(obj, ListKey.COMPANIONLIST, option);
        }
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<FollowerOption> changes = context.getObjectContext().getListChanges(obj, ListKey.COMPANIONLIST);
        Collection<FollowerOption> removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        Collection<FollowerOption> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TripleKeyMapToList m = new TripleKeyMapToList();
        for (FollowerOption fo : added) {
            m.addToListFor(new HashSet<Prerequisite>(fo.getPrerequisiteList()), fo.getListRef(), (Object)fo.getAdjustment(), fo.getRaceRef());
        }
        TreeSet<String> set = new TreeSet<String>();
        StringBuilder sb = new StringBuilder();
        for (Set prereqs : m.getKeySet()) {
            String prereqString = null;
            if (prereqs != null && !prereqs.isEmpty()) {
                prereqString = this.getPrerequisiteString(context, prereqs);
            }
            for (CDOMReference cl : m.getSecondaryKeySet((Object)prereqs)) {
                for (Integer fa : m.getTertiaryKeySet((Object)prereqs, (Object)cl)) {
                    sb.setLength(0);
                    sb.append(cl.getLSTformat(false));
                    sb.append("|");
                    TreeSet raceSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
                    raceSet.addAll(m.getListFor((Object)prereqs, (Object)cl, (Object)fa));
                    sb.append(ReferenceUtilities.joinLstFormat(raceSet, ",", true));
                    if (fa != null && fa != 0) {
                        sb.append("|");
                        sb.append("FOLLOWERADJUSTMENT:");
                        sb.append(fa);
                    }
                    if (prereqString != null) {
                        sb.append("|");
                        sb.append(prereqString);
                    }
                    set.add(sb.toString());
                }
            }
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

