/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractSpellListToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class SpellknownLst
extends AbstractSpellListToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SPELLKNOWN";
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        String workingValue = value;
        ArrayList<Prerequisite> prereqs = new ArrayList<Prerequisite>();
        while (true) {
            int lastPipeLoc;
            if ((lastPipeLoc = workingValue.lastIndexOf(124)) == -1) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + " not enough tokens: " + value, context);
            }
            String lastToken = workingValue.substring(lastPipeLoc + 1);
            if (!this.looksLikeAPrerequisite(lastToken)) break;
            workingValue = workingValue.substring(0, lastPipeLoc);
            Prerequisite prerequisite = this.getPrerequisite(lastToken);
            if (prerequisite == null) {
                return new ParseResult.Fail("Invalid prerequisite " + lastToken + " in " + this.getTokenName() + " tag: " + value, context);
            }
            prereqs.add(prerequisite);
        }
        StringTokenizer tok = new StringTokenizer(workingValue, "|");
        if (tok.countTokens() < 3) {
            return new ParseResult.Fail("Insufficient values in SPELLKNOWN tag: " + value, context);
        }
        String tagType = tok.nextToken();
        while (tok.hasMoreTokens()) {
            String tokString = tok.nextToken();
            String spellString = tok.nextToken();
            if (tagType.equalsIgnoreCase("CLASS")) {
                if (this.subParse(context, obj, ClassSpellList.class, tokString, spellString, prereqs)) continue;
                return ParseResult.INTERNAL_ERROR;
            }
            return new ParseResult.Fail("First token of " + this.getTokenName() + " must be CLASS: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private <CL extends Loadable & CDOMList<Spell>> boolean subParse(LoadContext context, CDOMObject obj, Class<CL> tagType, String tokString, String spellString, List<Prerequisite> prereqs) {
        Integer splLevel;
        int equalLoc = tokString.indexOf("=");
        if (equalLoc == -1) {
            Logging.errorPrint((String)("Expected an = in SPELLKNOWN definition: " + tokString));
            return false;
        }
        String casterString = tokString.substring(0, equalLoc);
        String spellLevel = tokString.substring(equalLoc + 1);
        try {
            splLevel = Integer.decode(spellLevel);
        }
        catch (NumberFormatException nfe) {
            Logging.errorPrint((String)("Expected a number for SPELLKNOWN, found: " + spellLevel));
            return false;
        }
        if (this.isEmpty(casterString) || this.hasIllegalSeparator(',', casterString)) {
            return false;
        }
        StringTokenizer clTok = new StringTokenizer(casterString, ",");
        ArrayList<CDOMSingleRef> slList = new ArrayList<CDOMSingleRef>();
        while (clTok.hasMoreTokens()) {
            String classString = clTok.nextToken();
            Object ref = classString.startsWith("SPELLCASTER.") ? context.getReferenceContext().getCDOMTypeReference(tagType, new String[]{classString.substring(12)}) : context.getReferenceContext().getCDOMReference(tagType, classString);
            slList.add((CDOMSingleRef)ref);
        }
        if (this.hasIllegalSeparator(',', spellString)) {
            return false;
        }
        StringTokenizer spTok = new StringTokenizer(spellString, ",");
        while (spTok.hasMoreTokens()) {
            String spellName = spTok.nextToken();
            CDOMSingleRef sp = context.getReferenceContext().getCDOMReference(Spell.class, spellName);
            for (CDOMReference cDOMReference : slList) {
                AssociatedPrereqObject tpr = context.getListContext().addToList(this.getTokenName(), obj, cDOMReference, (CDOMReference)sp);
                tpr.setAssociation(AssociationKey.SPELL_LEVEL, (Object)splLevel);
                tpr.setAssociation(AssociationKey.KNOWN, (Object)Boolean.TRUE);
                tpr.addAllPrerequisites(prereqs);
            }
        }
        return true;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        TreeSet<String> set = new TreeSet<String>();
        Collection changedClassLists = context.getListContext().getChangedLists(obj, ClassSpellList.class);
        TripleKeyMapToList classMap = this.getMap(context, obj, changedClassLists, true);
        for (String prereqs : classMap.getKeySet()) {
            set.add(this.processUnparse("CLASS", classMap, prereqs).toString());
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

