/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.datastructure;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.onemind.commons.java.lang.reflect.ReflectUtils;
import org.onemind.commons.java.xml.digest.ElementCreatorDigester;
import org.onemind.commons.java.xml.digest.ElementDigester;
import org.onemind.commons.java.xml.digest.ElementListener;
import org.onemind.commons.java.xml.digest.SaxDigesterHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlProperties
extends HashMap {
    static /* synthetic */ Class class$org$onemind$commons$java$xml$digest$ElementDigester;

    public XmlProperties(String filename) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        this(new FileInputStream(filename));
    }

    public XmlProperties(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(is, (DefaultHandler)new XmlPropertiesHandler(this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class XmlPropertiesHandler
    extends SaxDigesterHandler
    implements ElementDigester {
        private static final Map _typeMap = new HashMap();
        private final XmlProperties _prop;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startDigest(SaxDigesterHandler handler, Attributes attrs) throws SAXException {
            String name = attrs.getValue("name");
            String type = attrs.getValue("type");
            String value = attrs.getValue("value");
            String clazz = attrs.getValue("class");
            if (name == null) {
                throw new SAXException("name attribute must exists on property");
            }
            if (type != null && clazz != null) {
                throw new SAXException("Both type and class cannot be specified on same property");
            }
            if (clazz != null) {
                try {
                    Class c = ReflectUtils.getClass(clazz);
                    if (clazz == null) return;
                    if (!(class$org$onemind$commons$java$xml$digest$ElementDigester == null ? (class$org$onemind$commons$java$xml$digest$ElementDigester = XmlProperties.class$("org.onemind.commons.java.xml.digest.ElementDigester")) : class$org$onemind$commons$java$xml$digest$ElementDigester).isAssignableFrom(c)) {
                        throw new SAXException("Class " + clazz + " is not a subclass of ElementDigester");
                    }
                    ElementDigester dig = (ElementDigester)ReflectUtils.newInstance(c, null);
                    handler.addSubDigester(dig);
                    if (dig instanceof ElementCreatorDigester) {
                        ((ElementCreatorDigester)dig).addListener(new NameSetter(this._prop, name));
                        return;
                    }
                    this._prop.put(name, dig);
                    return;
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage(), e);
                }
            } else if (type != null) {
                Object v = null;
                Integer typeInt = (Integer)_typeMap.get(type);
                if (typeInt == null) {
                    throw new SAXException("Unrecognized property type " + type);
                }
                switch (typeInt) {
                    case 5: {
                        v = Short.valueOf(value);
                        break;
                    }
                    case 4: {
                        v = Integer.valueOf(value);
                        break;
                    }
                    case -5: {
                        v = Long.valueOf(value);
                        break;
                    }
                    case 6: {
                        v = Float.valueOf(value);
                        break;
                    }
                    case 8: {
                        v = Double.valueOf(value);
                        break;
                    }
                    case 16: {
                        v = Boolean.valueOf(value);
                        break;
                    }
                    case 1: {
                        v = new Character(value.charAt(0));
                        break;
                    }
                    case 12: {
                        v = value;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized property type " + type);
                    }
                }
                this._prop.put(name, v);
                return;
            } else {
                this._prop.put(name, value);
            }
        }

        public XmlPropertiesHandler(XmlProperties prop) {
            this._prop = prop;
            this.addDigester("Properties", this);
        }

        public void endDigest(SaxDigesterHandler handler) throws SAXException {
        }

        public void characters(SaxDigesterHandler handler, char[] chars, int offset, int length) throws SAXException {
        }

        public String getElementName() {
            return "Property";
        }

        static {
            _typeMap.put("short", new Integer(5));
            _typeMap.put("int", new Integer(4));
            _typeMap.put("long", new Integer(-5));
            _typeMap.put("float", new Integer(6));
            _typeMap.put("double", new Integer(8));
            _typeMap.put("boolean", new Integer(16));
            _typeMap.put("char", new Integer(1));
            _typeMap.put("string", new Integer(12));
        }

        private class NameSetter
        implements ElementListener {
            private Map _m;
            private String _name;

            public NameSetter(Map m, String name) {
                this._m = m;
                this._name = name;
            }

            public void objectCreated(Object obj) {
                this._m.put(this._name, obj);
            }
        }
    }
}

