/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete.inprocess;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannelFactory;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.common.TelemetryBuffer;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LimitsEnforcer;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class InProcessTelemetryChannel
implements TelemetryChannel {
    private static final String INSTANT_RETRY_NAME = "MaxInstantRetry";
    public static final int DEFAULT_MAX_INSTANT_RETRY = 3;
    public static final int DEFAULT_MAX_TELEMETRY_BUFFER_CAPACITY = 500;
    private static final int MIN_MAX_TELEMETRY_BUFFER_CAPACITY = 1;
    private static final int MAX_MAX_TELEMETRY_BUFFER_CAPACITY = 1000;
    private static final String MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME = "MaxTelemetryBufferCapacity";
    public static final int DEFAULT_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 5;
    private static final int MIN_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 1;
    private static final int MAX_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 300;
    private static final String FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME = "FlushIntervalInSeconds";
    private static final String DEVELOPER_MODE_SYSTEM_PROPRETY_NAME = "APPLICATION_INSIGHTS_DEVELOPER_MODE";
    private static final String DEVELOPER_MODE_NAME = "DeveloperMode";
    private static final String ENDPOINT_ADDRESS_NAME = "EndpointAddress";
    private static final String MAX_TRANSMISSION_STORAGE_CAPACITY_NAME = "MaxTransmissionStorageFilesCapacityInMB";
    private boolean developerMode = false;
    private static TransmitterFactory s_transmitterFactory;
    private boolean stopped = false;
    private TelemetriesTransmitter telemetriesTransmitter;
    private TelemetryBuffer telemetryBuffer;
    private TelemetrySampler telemetrySampler;
    private static AtomicLong itemsSent;

    public InProcessTelemetryChannel() {
        boolean developerMode = false;
        try {
            String developerModeAsString = System.getProperty(DEVELOPER_MODE_SYSTEM_PROPRETY_NAME);
            if (!LocalStringsUtils.isNullOrEmpty(developerModeAsString)) {
                developerMode = Boolean.valueOf(developerModeAsString);
            }
        }
        catch (Exception e) {
            developerMode = false;
            InternalLogger.INSTANCE.trace("%s generated exception in parsing, stack trace is %s", DEVELOPER_MODE_SYSTEM_PROPRETY_NAME, ExceptionUtils.getStackTrace(e));
        }
        this.initialize(null, null, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(null), this.createDefaultSendIntervalInSecondsEnforcer(null), true);
    }

    public InProcessTelemetryChannel(String endpointAddress, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis) {
        this(endpointAddress, null, developerMode, maxTelemetryBufferCapacity, sendIntervalInMillis, true, 3);
    }

    public InProcessTelemetryChannel(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis, boolean throttling, int maxInstantRetries) {
        this.initialize(endpointAddress, maxTransmissionStorageCapacity, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(maxTelemetryBufferCapacity), this.createDefaultSendIntervalInSecondsEnforcer(sendIntervalInMillis), throttling, maxInstantRetries);
    }

    public InProcessTelemetryChannel(Map<String, String> namesAndValues) {
        boolean developerMode = false;
        String endpointAddress = null;
        int maxInstantRetries = 3;
        LimitsEnforcer maxTelemetryBufferCapacityEnforcer = this.createDefaultMaxTelemetryBufferCapacityEnforcer(null);
        LimitsEnforcer sendIntervalInSecondsEnforcer = this.createDefaultSendIntervalInSecondsEnforcer(null);
        boolean throttling = true;
        if (namesAndValues != null) {
            throttling = Boolean.valueOf(namesAndValues.get("Throttling"));
            developerMode = Boolean.valueOf(namesAndValues.get(DEVELOPER_MODE_NAME));
            try {
                String instantRetryValue = namesAndValues.get(INSTANT_RETRY_NAME);
                if (instantRetryValue != null) {
                    maxInstantRetries = Integer.parseInt(instantRetryValue);
                }
            }
            catch (NumberFormatException e) {
                InternalLogger.INSTANCE.error("Unable to parse configuration setting %s to integer value.%nStack Trace:%n%s", INSTANT_RETRY_NAME, ExceptionUtils.getStackTrace(e));
            }
            if (!developerMode) {
                developerMode = Boolean.valueOf(System.getProperty(DEVELOPER_MODE_SYSTEM_PROPRETY_NAME));
            }
            endpointAddress = namesAndValues.get(ENDPOINT_ADDRESS_NAME);
            maxTelemetryBufferCapacityEnforcer.normalizeStringValue(namesAndValues.get(MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME));
            sendIntervalInSecondsEnforcer.normalizeStringValue(namesAndValues.get(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME));
        }
        String maxTransmissionStorageCapacity = namesAndValues.get(MAX_TRANSMISSION_STORAGE_CAPACITY_NAME);
        this.initialize(endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacityEnforcer, sendIntervalInSecondsEnforcer, throttling, maxInstantRetries);
    }

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean developerMode) {
        if (developerMode != this.developerMode) {
            this.developerMode = developerMode;
            int maxTelemetriesInBatch = this.developerMode ? 1 : 500;
            this.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
        }
    }

    @Override
    public void send(Telemetry telemetry) {
        Preconditions.checkNotNull(telemetry, "Telemetry item must be non null");
        if (this.isDeveloperMode()) {
            telemetry.getContext().getProperties().put(DEVELOPER_MODE_NAME, "true");
        }
        if (this.telemetrySampler != null && !this.telemetrySampler.isSampledIn(telemetry)) {
            return;
        }
        StringWriter writer = new StringWriter();
        JsonTelemetryDataSerializer jsonWriter = null;
        try {
            jsonWriter = new JsonTelemetryDataSerializer(writer);
            telemetry.serialize(jsonWriter);
            jsonWriter.close();
            String asJson = writer.toString();
            this.telemetryBuffer.add(asJson);
            telemetry.reset();
            if (itemsSent.incrementAndGet() % 10000L == 0L) {
                InternalLogger.INSTANCE.info("items sent till now %d", itemsSent.get());
            }
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to serialize Telemetry", new Object[0]);
            InternalLogger.INSTANCE.trace("Stack trace is %s", ExceptionUtils.getStackTrace(e));
            return;
        }
        if (this.isDeveloperMode()) {
            this.writeTelemetryToDebugOutput(telemetry);
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        try {
            if (this.stopped) {
                return;
            }
            this.telemetriesTransmitter.stop(timeout, timeUnit);
            this.stopped = true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Exception generated while stopping telemetry transmitter", new Object[0]);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        this.telemetryBuffer.flush();
    }

    @Override
    public void setSampler(TelemetrySampler telemetrySampler) {
        if (this.telemetrySampler == null) {
            this.telemetrySampler = telemetrySampler;
        }
    }

    public void setMaxTelemetriesInBatch(int maxTelemetriesInBatch) {
        this.telemetryBuffer.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
    }

    public void setTransmitBufferTimeoutInSeconds(int transmitBufferTimeoutInSeconds) {
        this.telemetryBuffer.setTransmitBufferTimeoutInSeconds(transmitBufferTimeoutInSeconds);
    }

    private void writeTelemetryToDebugOutput(Telemetry telemetry) {
        InternalLogger.INSTANCE.trace("InProcessTelemetryChannel sending telemetry", new Object[0]);
    }

    private synchronized void initialize(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, LimitsEnforcer maxTelemetryBufferCapacityEnforcer, LimitsEnforcer sendIntervalInSeconds, boolean throttling) {
        this.initialize(endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacityEnforcer, sendIntervalInSeconds, throttling, 3);
    }

    private synchronized void initialize(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, LimitsEnforcer maxTelemetryBufferCapacityEnforcer, LimitsEnforcer sendIntervalInSeconds, boolean throttling, int maxInstantRetry) {
        this.makeSureEndpointAddressIsValid(endpointAddress);
        if (s_transmitterFactory == null) {
            s_transmitterFactory = new InProcessTelemetryChannelFactory();
        }
        this.telemetriesTransmitter = s_transmitterFactory.create(endpointAddress, maxTransmissionStorageCapacity, throttling, maxInstantRetry);
        this.telemetryBuffer = new TelemetryBuffer(this.telemetriesTransmitter, maxTelemetryBufferCapacityEnforcer, sendIntervalInSeconds);
        this.setDeveloperMode(developerMode);
    }

    private void makeSureEndpointAddressIsValid(String endpointAddress) {
        if (Strings.isNullOrEmpty(endpointAddress)) {
            return;
        }
        URI uri = Sanitizer.sanitizeUri(endpointAddress);
        if (uri == null) {
            String errorMessage = String.format("Endpoint address %s is not a valid uri", endpointAddress);
            InternalLogger.INSTANCE.error(errorMessage, new Object[0]);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private LimitsEnforcer createDefaultMaxTelemetryBufferCapacityEnforcer(Integer currentValue) {
        LimitsEnforcer maxItemsInBatchEnforcer = LimitsEnforcer.createWithClosestLimitOnError(MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME, 1, 1000, 500, currentValue == null ? 500 : currentValue);
        return maxItemsInBatchEnforcer;
    }

    private LimitsEnforcer createDefaultSendIntervalInSecondsEnforcer(Integer currentValue) {
        LimitsEnforcer sendIntervalInSecondsEnforcer = LimitsEnforcer.createWithClosestLimitOnError(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME, 1, 300, 5, currentValue == null ? 5 : currentValue);
        return sendIntervalInSecondsEnforcer;
    }

    static {
        itemsSent = new AtomicLong(0L);
    }
}

