/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.heartbeat;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPayloadProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.MiscUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class WebAppsHeartbeatProvider
implements HeartBeatPayloadProviderInterface {
    private final String name = "webapps";
    private final Set<String> defaultFields = new HashSet<String>();
    private Map<String, String> environmentMap = System.getenv();
    private final String WEBSITE_SITE_NAME = "appSrv_SiteName";
    private final String WEBSITE_HOSTNAME = "appSrv_wsHost";
    private final String WEBSITE_HOME_STAMPNAME = "appSrv_wsStamp";

    public WebAppsHeartbeatProvider() {
        this.initializeDefaultFields(this.defaultFields);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKeyword(String keyword) {
        return this.defaultFields.contains(keyword);
    }

    @Override
    public Callable<Boolean> setDefaultPayload(final List<String> disableFields, final HeartBeatProviderInterface provider) {
        return new Callable<Boolean>(){
            Set<String> enabledProperties;
            {
                this.enabledProperties = MiscUtils.except(disableFields, WebAppsHeartbeatProvider.this.defaultFields);
            }

            @Override
            public Boolean call() {
                boolean hasSetValues = false;
                WebAppsHeartbeatProvider.this.updateEnvironmentVariableMap();
                for (String fieldName : this.enabledProperties) {
                    try {
                        switch (fieldName) {
                            case "appSrv_SiteName": {
                                String webSiteName = WebAppsHeartbeatProvider.this.getWebsiteSiteName();
                                if (webSiteName == null) break;
                                provider.addHeartBeatProperty(fieldName, webSiteName, true);
                                hasSetValues = true;
                                break;
                            }
                            case "appSrv_wsHost": {
                                String webSiteHostName = WebAppsHeartbeatProvider.this.getWebsiteHostName();
                                if (webSiteHostName == null) break;
                                provider.addHeartBeatProperty(fieldName, webSiteHostName, true);
                                hasSetValues = true;
                                break;
                            }
                            case "appSrv_wsStamp": {
                                String websiteHomeStampName = WebAppsHeartbeatProvider.this.getWebsiteHomeStampName();
                                if (websiteHomeStampName == null) break;
                                provider.addHeartBeatProperty(fieldName, websiteHomeStampName, true);
                                hasSetValues = true;
                                break;
                            }
                            default: {
                                InternalLogger.INSTANCE.trace("Unknown web apps property encountered", new Object[0]);
                            }
                        }
                    }
                    catch (Exception e) {
                        InternalLogger.INSTANCE.warn("Failed to obtain heartbeat property, stack traceis: %s", ExceptionUtils.getStackTrace(e));
                    }
                }
                return hasSetValues;
            }
        };
    }

    private void initializeDefaultFields(Set<String> defaultFields) {
        if (defaultFields == null) {
            defaultFields = new HashSet<String>();
        }
        defaultFields.add("appSrv_SiteName");
        defaultFields.add("appSrv_wsHost");
        defaultFields.add("appSrv_wsStamp");
    }

    private String getWebsiteSiteName() {
        return this.environmentMap.get("WEBSITE_SITE_NAME");
    }

    private String getWebsiteHostName() {
        return this.environmentMap.get("WEBSITE_HOSTNAME ");
    }

    private String getWebsiteHomeStampName() {
        return this.environmentMap.get("WEBSITE_HOME_STAMPNAME");
    }

    private void updateEnvironmentVariableMap() {
        this.environmentMap = System.getenv();
    }
}

