/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.DataPoint;
import com.microsoft.applicationinsights.internal.schemav2.DataPointType;
import com.microsoft.applicationinsights.internal.schemav2.MetricData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;

public final class MetricTelemetry
extends BaseTelemetry<MetricData> {
    private final MetricData data = new MetricData();
    private final DataPoint metric = new DataPoint();
    private static final String ENVELOPE_NAME = "Metric";
    private static final String BASE_TYPE = "MetricData";

    public MetricTelemetry() {
        this.initialize(this.data.getProperties());
        this.data.getMetrics().add(this.metric);
    }

    public MetricTelemetry(String name, double value) {
        this();
        this.setName(name);
        this.metric.setValue(value);
    }

    public void markAsCustomPerfCounter() {
        this.data.getProperties().putIfAbsent("CustomPerfCounter", "true");
    }

    public String getName() {
        return this.metric.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The metric name cannot be null or empty");
        }
        this.metric.setName(name);
    }

    public double getValue() {
        return this.metric.getValue();
    }

    public void setValue(double value) {
        this.metric.setValue(value);
    }

    public Integer getCount() {
        return this.metric.getCount();
    }

    public void setCount(Integer count) {
        this.metric.setCount(count);
        this.updateKind();
    }

    public Double getMin() {
        return this.metric.getMin();
    }

    public void setMin(Double value) {
        this.metric.setMin(value);
        this.updateKind();
    }

    public Double getMax() {
        return this.metric.getMax();
    }

    public void setMax(Double value) {
        this.metric.setMax(value);
        this.updateKind();
    }

    public Double getStandardDeviation() {
        return this.metric.getStdDev();
    }

    public void setStandardDeviation(Double value) {
        this.metric.setStdDev(value);
        this.updateKind();
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.metric.setName(Sanitizer.sanitizeName(this.metric.getName()));
    }

    @Override
    protected MetricData getData() {
        return this.data;
    }

    private void updateKind() {
        boolean isAggregation;
        boolean bl = isAggregation = this.metric.getCount() != null || this.metric.getMin() != null || this.metric.getMax() != null || this.metric.getStdDev() != null;
        if (this.metric.getCount() != null && this.metric.getCount() == 1) {
            isAggregation = false;
        }
        this.metric.setKind(isAggregation ? DataPointType.Aggregation : DataPointType.Measurement);
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

