/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.svggen.font.table.GlyfCompositeComp;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private List components = new ArrayList();
    protected boolean beingResolved = false;
    protected boolean resolved = false;

    public GlyfCompositeDescript(GlyfTable glyfTable, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)-1, byteArrayInputStream);
        GlyfCompositeComp glyfCompositeComp;
        do {
            glyfCompositeComp = new GlyfCompositeComp(byteArrayInputStream);
            this.components.add(glyfCompositeComp);
        } while ((glyfCompositeComp.getFlags() & 0x20) != 0);
        if ((glyfCompositeComp.getFlags() & 0x100) != 0) {
            this.readInstructions(byteArrayInputStream, byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
        }
    }

    @Override
    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            System.err.println("Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int n = 0;
        int n2 = 0;
        for (GlyfCompositeComp glyfCompositeComp : this.components) {
            glyfCompositeComp.setFirstIndex(n);
            glyfCompositeComp.setFirstContour(n2);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfDescript == null) continue;
            glyfDescript.resolve();
            n += glyfDescript.getPointCount();
            n2 += glyfDescript.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    @Override
    public int getEndPtOfContours(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getEndPtOfContours(n - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getFlags(n - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s2 = glyfDescript.getXCoordinate(n2);
            short s3 = glyfDescript.getYCoordinate(n2);
            short s4 = (short)glyfCompositeComp.scaleX(s2, s3);
            s4 = (short)(s4 + glyfCompositeComp.getXTranslate());
            return s4;
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s2 = glyfDescript.getXCoordinate(n2);
            short s3 = glyfDescript.getYCoordinate(n2);
            short s4 = (short)glyfCompositeComp.scaleY(s2, s3);
            s4 = (short)(s4 + glyfCompositeComp.getYTranslate());
            return s4;
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        if (!this.resolved) {
            System.err.println("getPointCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return glyfCompositeComp.getFirstIndex() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getPointCount();
    }

    @Override
    public int getContourCount() {
        if (!this.resolved) {
            System.err.println("getContourCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return glyfCompositeComp.getFirstContour() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int n) {
        return ((GlyfCompositeComp)this.components.get(n)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int n) {
        for (int i = 0; i < this.components.size(); ++i) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(i);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() > n || n >= glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int n) {
        for (int i = 0; i < this.components.size(); ++i) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(i);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() > n || n >= glyfCompositeComp.getFirstContour() + glyfDescript.getContourCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }
}

