/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javafx.event.Event;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.internal.PrefixTree;

class InputHandlerMap<E extends Event> {
    private final BiFunction<InputHandler<? super E>, InputHandler<? super E>, InputHandler<E>> SEQ = (h1, h2) -> evt -> {
        switch (h1.process(evt)) {
            case PROCEED: {
                return h2.process(evt);
            }
            case CONSUME: {
                return InputHandler.Result.CONSUME;
            }
            case IGNORE: {
                return InputHandler.Result.IGNORE;
            }
        }
        throw new AssertionError((Object)"unreachable code");
    };
    private final PrefixTree.Ops<EventType<? extends E>, InputHandler<? super E>> OPS = new PrefixTree.Ops<EventType<? extends E>, InputHandler<? super E>>(){

        @Override
        public boolean isPrefixOf(EventType<? extends E> t1, EventType<? extends E> t2) {
            for (EventType t = t2; t != null; t = t.getSuperType()) {
                if (!t.equals(t1)) continue;
                return true;
            }
            return false;
        }

        @Override
        public EventType<? extends E> commonPrefix(EventType<? extends E> t1, EventType<? extends E> t2) {
            Iterator i1 = InputHandlerMap.toList(t1).iterator();
            Iterator i2 = InputHandlerMap.toList(t2).iterator();
            EventType common = null;
            while (i1.hasNext() && i2.hasNext()) {
                EventType c2;
                EventType c1 = (EventType)i1.next();
                if (!Objects.equals(c1, c2 = (EventType)i2.next())) continue;
                common = c1;
            }
            return common;
        }

        @Override
        public InputHandler<? super E> promote(InputHandler<? super E> h2, EventType<? extends E> subTpe, EventType<? extends E> supTpe) {
            if (Objects.equals(subTpe, supTpe)) {
                return h2;
            }
            return evt -> {
                if (this.isPrefixOf(subTpe, evt.getEventType())) {
                    return h2.process((Object)evt);
                }
                return InputHandler.Result.PROCEED;
            };
        }

        @Override
        public InputHandler<E> squash(InputHandler<? super E> v1, InputHandler<? super E> v2) {
            return (InputHandler)InputHandlerMap.this.SEQ.apply(v1, v2);
        }
    };
    private PrefixTree<EventType<? extends E>, InputHandler<? super E>> handlerTree = PrefixTree.empty(this.OPS);

    InputHandlerMap() {
    }

    private static final List<EventType<?>> toList(EventType<?> t) {
        ArrayList l = new ArrayList();
        while (t != null) {
            l.add(t);
            t = t.getSuperType();
        }
        Collections.reverse(l);
        return l;
    }

    public <F extends E> void insertAfter(EventType<? extends F> t, InputHandler<? super F> h2) {
        InputHandler<? super F> handler = h2;
        this.handlerTree = this.handlerTree.insert(t, handler, this.SEQ);
    }

    void forEach(InputMap.HandlerConsumer<? super E> f) {
        this.handlerTree.entries().forEach((? super T th) -> f.accept((EventType)th.getKey(), (InputHandler)th.getValue()));
    }
}

