/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.entryeditor.DeprecatedFieldsTab;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.EntryEditorTabList;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.entryeditor.MathSciNetTab;
import org.jabref.gui.entryeditor.OptionalFields2Tab;
import org.jabref.gui.entryeditor.OptionalFieldsTab;
import org.jabref.gui.entryeditor.OtherFieldsTab;
import org.jabref.gui.entryeditor.RelatedArticlesTab;
import org.jabref.gui.entryeditor.RequiredFieldsTab;
import org.jabref.gui.entryeditor.SourceTab;
import org.jabref.gui.entryeditor.UserDefinedFieldsTab;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTab;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.menus.ChangeEntryTypeMenu;
import org.jabref.gui.mergeentries.EntryFetchAndMergeWorker;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.TypedBibEntry;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.search.SearchQueryHighlightListener;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public class EntryEditor
extends BorderPane {
    private final BibDatabaseContext bibDatabaseContext;
    private final CountingUndoManager undoManager;
    private final BasePanel panel;
    private final List<SearchQueryHighlightListener> searchListeners = new ArrayList<SearchQueryHighlightListener>();
    private Subscription typeSubscription;
    private final List<EntryEditorTab> tabs;
    private BibEntry entry;
    private SourceTab sourceTab;
    @FXML
    private TabPane tabbed;
    @FXML
    private Button typeChangeButton;
    @FXML
    private Button fetcherButton;
    @FXML
    private Label typeLabel;

    public EntryEditor(BasePanel panel) {
        this.panel = panel;
        this.bibDatabaseContext = panel.getBibDatabaseContext();
        this.undoManager = panel.getUndoManager();
        ControlHelper.loadFXMLForControl((Parent)this);
        this.getStylesheets().add((Object)EntryEditor.class.getResource("EntryEditor.css").toExternalForm());
        this.setStyle("-fx-font-size: " + Globals.prefs.getFontSizeFX() + "pt;");
        EasyBind.subscribe(this.tabbed.getSelectionModel().selectedItemProperty(), tab -> {
            EntryEditorTab activeTab = (EntryEditorTab)((Object)tab);
            if (activeTab != null) {
                activeTab.notifyAboutFocus(this.entry);
            }
        });
        this.setupKeyBindings();
        this.tabs = this.createTabs();
    }

    private void setupKeyBindings() {
        this.tabbed.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = Globals.getKeyPrefs().mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case ENTRY_EDITOR_NEXT_PANEL: 
                    case ENTRY_EDITOR_NEXT_PANEL_2: {
                        this.tabbed.getSelectionModel().selectNext();
                        event.consume();
                        break;
                    }
                    case ENTRY_EDITOR_PREVIOUS_PANEL: 
                    case ENTRY_EDITOR_PREVIOUS_PANEL_2: {
                        this.tabbed.getSelectionModel().selectPrevious();
                        event.consume();
                        break;
                    }
                    case HELP: {
                        HelpAction.openHelpPage(HelpFile.ENTRY_EDITOR);
                        event.consume();
                        break;
                    }
                    case CLOSE_ENTRY_EDITOR: {
                        this.close();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    @FXML
    public void close() {
        this.panel.entryEditorClosing(this);
    }

    @FXML
    public void generateKey() {
        new BibtexKeyGenerator(this.bibDatabaseContext, Globals.prefs.getBibtexKeyPatternPreferences()).generateAndSetKey(this.entry).ifPresent(change -> this.undoManager.addEdit(new UndoableKeyChange((FieldChange)change)));
    }

    @FXML
    private void deleteEntry() {
        this.panel.delete(this.entry);
    }

    @FXML
    private void navigateToPreviousEntry() {
        this.panel.selectPreviousEntry();
    }

    @FXML
    private void navigateToNextEntry() {
        this.panel.selectNextEntry();
    }

    private List<EntryEditorTab> createTabs() {
        LinkedList<EntryEditorTab> tabs = new LinkedList<EntryEditorTab>();
        tabs.add(new RequiredFieldsTab(this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        tabs.add(new OptionalFieldsTab(this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        tabs.add(new OptionalFields2Tab(this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        tabs.add(new DeprecatedFieldsTab(this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        tabs.add(new OtherFieldsTab(this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < tabList.getTabCount(); ++i) {
            tabs.add(new UserDefinedFieldsTab(tabList.getTabName(i), tabList.getTabFields(i), this.panel.getBibDatabaseContext(), this.panel.getSuggestionProviders(), this.undoManager));
        }
        tabs.add(new MathSciNetTab());
        tabs.add(new FileAnnotationTab(this.panel.getAnnotationCache()));
        tabs.add(new RelatedArticlesTab(Globals.prefs));
        this.sourceTab = new SourceTab(this.bibDatabaseContext, this.undoManager, Globals.prefs.getLatexFieldFormatterPreferences(), Globals.prefs, Globals.getFileUpdateMonitor());
        tabs.add(this.sourceTab);
        return tabs;
    }

    private void recalculateVisibleTabs() {
        List visibleTabs = this.tabs.stream().filter(tab -> tab.shouldShow(this.entry)).collect(Collectors.toList());
        List toBeRemoved = this.tabs.stream().filter(tab -> !tab.shouldShow(this.entry)).collect(Collectors.toList());
        this.tabbed.getTabs().removeAll(toBeRemoved);
        for (int i = 0; i < visibleTabs.size(); ++i) {
            Tab toBeAdded = (Tab)visibleTabs.get(i);
            Tab shown = null;
            if (i < this.tabbed.getTabs().size()) {
                shown = (Tab)this.tabbed.getTabs().get(i);
            }
            if (toBeAdded.equals(shown)) continue;
            this.tabbed.getTabs().add(i, (Object)toBeAdded);
        }
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public void setEntry(BibEntry entry) {
        Objects.requireNonNull(entry);
        if (this.typeSubscription != null) {
            this.typeSubscription.unsubscribe();
        }
        this.entry = entry;
        DefaultTaskExecutor.runInJavaFXThread(() -> {
            this.recalculateVisibleTabs();
            if (Globals.prefs.getBoolean("defaultShowSource")) {
                this.tabbed.getSelectionModel().select((Object)this.sourceTab);
            }
            EntryEditorTab selectedTab = (EntryEditorTab)((Object)((Object)this.tabbed.getSelectionModel().getSelectedItem()));
            selectedTab.notifyAboutFocus(entry);
            this.setupToolBar();
        });
        this.typeSubscription = EasyBind.subscribe(this.entry.typeProperty(), type -> DefaultTaskExecutor.runInJavaFXThread(() -> {
            this.typeLabel.setText(new TypedBibEntry(entry, this.bibDatabaseContext.getMode()).getTypeForDisplay());
            this.recalculateVisibleTabs();
            EntryEditorTab selectedTab = (EntryEditorTab)((Object)((Object)((Object)this.tabbed.getSelectionModel().getSelectedItem())));
            selectedTab.notifyAboutFocus(entry);
        }));
    }

    private void setupToolBar() {
        TypedBibEntry typedEntry = new TypedBibEntry(this.entry, this.bibDatabaseContext.getMode());
        this.typeLabel.setText(typedEntry.getTypeForDisplay());
        ContextMenu typeMenu = new ChangeEntryTypeMenu().getChangeEntryTypePopupMenu(this.entry, this.bibDatabaseContext, this.undoManager);
        this.typeLabel.setOnMouseClicked(event -> typeMenu.show((Node)this.typeLabel, Side.RIGHT, 0.0, 0.0));
        this.typeChangeButton.setOnMouseClicked(event -> typeMenu.show((Node)this.typeChangeButton, Side.RIGHT, 0.0, 0.0));
        ContextMenu fetcherMenu = new ContextMenu();
        for (EntryBasedFetcher fetcher : WebFetchers.getEntryBasedFetchers(Globals.prefs.getImportFormatPreferences())) {
            MenuItem fetcherMenuItem = new MenuItem(fetcher.getName());
            fetcherMenuItem.setOnAction(event -> new EntryFetchAndMergeWorker(this.panel, this.getEntry(), fetcher).execute());
            fetcherMenu.getItems().add((Object)fetcherMenuItem);
        }
        this.fetcherButton.setOnMouseClicked(event -> fetcherMenu.show((Node)this.fetcherButton, Side.RIGHT, 0.0, 0.0));
    }

    void addSearchListener(SearchQueryHighlightListener listener) {
        this.searchListeners.add(listener);
        this.panel.frame().getGlobalSearchBar().getSearchQueryHighlightObservable().addSearchListener(listener);
    }

    public void setFocusToField(String fieldName) {
        DefaultTaskExecutor.runInJavaFXThread(() -> {
            for (Tab tab : this.tabbed.getTabs()) {
                if (!(tab instanceof FieldsEditorTab) || !((FieldsEditorTab)tab).getShownFields().contains(fieldName)) continue;
                FieldsEditorTab fieldsEditorTab = (FieldsEditorTab)tab;
                this.tabbed.getSelectionModel().select((Object)tab);
                fieldsEditorTab.requestFocus(fieldName);
            }
        });
    }
}

