/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.nio.file.Paths;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;

public class ExternalFileTypeEntryEditor {
    private JFrame fParent;
    private JDialog dParent;
    private JDialog diag;
    private final JTextField extension = new JTextField();
    private final JTextField name = new JTextField();
    private final JTextField mimeType = new JTextField();
    private final JTextField application = new JTextField();
    private final JLabel icon = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private final JRadioButton useDefault = new JRadioButton(Localization.lang("Default", new String[0]));
    private final JRadioButton other = new JRadioButton("");
    private final String editFileTitle = Localization.lang("Edit file type", new String[0]);
    private final String newFileTitle = Localization.lang("Add new file type", new String[0]);
    private ExternalFileType entry;
    private boolean okPressed;
    private final ActionListener browsePressed = e -> {
        String appDir = this.application.getText().trim();
        if (appDir.isEmpty()) {
            appDir = Globals.prefs.get("workingDirectory");
        }
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(Paths.get(appDir, new String[0])).build();
        FXDialogService ds = new FXDialogService();
        Optional path = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
        path.ifPresent(applicationDir -> {
            if (applicationDir.getParent() != null) {
                Globals.prefs.put("workingDirectory", applicationDir.getParent().toString());
            }
            this.application.setText(applicationDir.toString());
        });
    };

    public ExternalFileTypeEntryEditor(JFrame parent, ExternalFileType entry) {
        this.fParent = parent;
        this.init(entry);
    }

    public ExternalFileTypeEntryEditor(JDialog parent, ExternalFileType entry) {
        this.dParent = parent;
        this.init(entry);
    }

    private void init(ExternalFileType inEntry) {
        this.entry = inEntry;
        this.icon.setText(null);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useDefault);
        bg.add(this.other);
        FormBuilder builder = FormBuilder.create();
        builder.layout(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p"));
        builder.add(Localization.lang("Icon", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.icon).xy(3, 1);
        builder.add(Localization.lang("Name", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.name).xy(3, 3);
        builder.add(Localization.lang("Extension", new String[0]), new Object[0]).xy(1, 5);
        builder.add(this.extension).xy(3, 5);
        builder.add(Localization.lang("MIME type", new String[0]), new Object[0]).xy(1, 7);
        builder.add(this.mimeType).xy(3, 7);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.add(Localization.lang("Application", new String[0]), new Object[0]).xy(1, 9);
        JButton browseBut = new JButton(Localization.lang("Browse", new String[0]));
        if (OS.WINDOWS) {
            builder.add(this.useDefault).xy(3, 9);
            builder.appendRows("2dlu, p", new Object[0]);
            JPanel p1 = new JPanel();
            builder.add(p1).xy(1, 11);
            JPanel p2 = new JPanel();
            this.application.setPreferredSize(new Dimension(300, this.application.getPreferredSize().height));
            BorderLayout bl = new BorderLayout();
            bl.setHgap(4);
            p2.setLayout(bl);
            p2.add((Component)this.other, "West");
            p2.add((Component)this.application, "Center");
            builder.add(p2).xy(3, 11);
            builder.add(browseBut).xy(5, 11);
        } else {
            builder.add(this.application).xy(3, 9);
            builder.add(browseBut).xy(5, 9);
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        this.ok.addActionListener(e -> {
            this.okPressed = true;
            this.storeSettings(this.entry);
            this.diag.dispose();
        });
        this.cancel.addActionListener(e -> this.diag.dispose());
        if (OS.WINDOWS) {
            this.application.getDocument().addDocumentListener(new DocumentListener(){

                private void handle() {
                    if (ExternalFileTypeEntryEditor.this.application.getText().isEmpty()) {
                        ExternalFileTypeEntryEditor.this.useDefault.setSelected(true);
                    } else {
                        ExternalFileTypeEntryEditor.this.other.setSelected(true);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.handle();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.handle();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.handle();
                }
            });
        }
        String title = this.editFileTitle;
        if (this.entry.getName().isEmpty()) {
            title = this.newFileTitle;
        }
        this.diag = this.dParent == null ? new JDialog(this.fParent, title, true) : new JDialog(this.dParent, title, true);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        browseBut.addActionListener(this.browsePressed);
        if (this.dParent == null) {
            this.diag.setLocationRelativeTo(this.fParent);
        } else {
            this.diag.setLocationRelativeTo(this.dParent);
        }
        this.setValues(this.entry);
    }

    public void setEntry(ExternalFileType entry) {
        this.entry = entry;
        if (entry.getName().isEmpty()) {
            this.diag.setTitle(this.newFileTitle);
        } else {
            this.diag.setTitle(this.editFileTitle);
        }
        this.setValues(entry);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.okPressed = false;
        }
        this.diag.setVisible(visible);
    }

    private void setValues(ExternalFileType entry) {
        this.name.setText(entry.getName());
        this.extension.setText(entry.getExtension());
        this.mimeType.setText(entry.getMimeType());
        this.application.setText(entry.getOpenWithApplication());
        this.icon.setIcon(entry.getIcon());
        if (this.application.getText().isEmpty()) {
            this.useDefault.setSelected(true);
        } else {
            this.other.setSelected(true);
        }
    }

    private void storeSettings(ExternalFileType fileTypeEntry) {
        fileTypeEntry.setName(this.name.getText().trim());
        fileTypeEntry.setMimeType(this.mimeType.getText().trim());
        String ext = this.extension.getText().trim();
        if (!ext.isEmpty() && ext.charAt(0) == '.') {
            fileTypeEntry.setExtension(ext.substring(1));
        } else {
            fileTypeEntry.setExtension(ext);
        }
        if (OS.WINDOWS) {
            if (this.useDefault.isSelected() || this.application.getText().trim().isEmpty()) {
                fileTypeEntry.setOpenWith("");
            } else {
                fileTypeEntry.setOpenWith(this.application.getText().trim());
            }
        } else {
            fileTypeEntry.setOpenWith(this.application.getText().trim());
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

