/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.jabref.gui.AbstractController;
import org.jabref.gui.DialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.journals.AbbreviationViewModel;
import org.jabref.gui.journals.AbbreviationsFileViewModel;
import org.jabref.gui.journals.ManageJournalAbbreviationsViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.preferences.PreferencesService;

public class ManageJournalAbbreviationsController
extends AbstractController<ManageJournalAbbreviationsViewModel> {
    @FXML
    public Label loadingLabel;
    @FXML
    public ProgressIndicator progressIndicator;
    @FXML
    private TableView<AbbreviationViewModel> journalAbbreviationsTable;
    @FXML
    private TableColumn<AbbreviationViewModel, String> journalTableNameColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, String> journalTableAbbreviationColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, Boolean> journalTableEditColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, Boolean> journalTableDeleteColumn;
    @FXML
    private Button cancelButton;
    @FXML
    private ComboBox<AbbreviationsFileViewModel> journalFilesBox;
    @FXML
    private Button addJournalFileButton;
    @FXML
    private Button addNewJournalFileButton;
    @FXML
    private Button removeJournalAbbreviationsButton;
    @Inject
    private PreferencesService preferences;
    @Inject
    private DialogService dialogService;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private JournalAbbreviationLoader journalAbbreviationLoader;

    @FXML
    private void initialize() {
        this.viewModel = new ManageJournalAbbreviationsViewModel(this.preferences, this.dialogService, this.taskExecutor, this.journalAbbreviationLoader);
        this.setUpTable();
        this.setBindings();
        this.setButtonStyles();
        ((ManageJournalAbbreviationsViewModel)this.viewModel).init();
    }

    private void setButtonStyles() {
        this.addJournalFileButton.setGraphic(IconTheme.JabRefIcon.OPEN.getGraphicNode());
        this.addNewJournalFileButton.setGraphic(IconTheme.JabRefIcon.NEW.getGraphicNode());
        this.removeJournalAbbreviationsButton.setGraphic(IconTheme.JabRefIcon.CLOSE.getGraphicNode());
    }

    private void setUpTable() {
        this.journalAbbreviationsTable.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                ((ManageJournalAbbreviationsViewModel)this.viewModel).deleteAbbreviation();
            }
        });
        this.journalTableNameColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).nameProperty());
        this.journalTableNameColumn.setCellFactory(cell -> new JournalAbbreviationsNameTableEditingCell());
        this.journalTableAbbreviationColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).abbreviationProperty());
        this.journalTableAbbreviationColumn.setCellFactory(cell -> new JournalAbbreviationsAbbreviationTableEditingCell());
        this.journalTableEditColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).isPseudoAbbreviationProperty());
        this.journalTableDeleteColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).isPseudoAbbreviationProperty());
        this.journalTableEditColumn.setCellFactory(new ValueTableCellFactory().withGraphic(isPseudoAbbreviation -> {
            if (isPseudoAbbreviation.booleanValue()) {
                return IconTheme.JabRefIcon.ADD.getGraphicNode();
            }
            return ((ManageJournalAbbreviationsViewModel)this.viewModel).isAbbreviationEditableAndRemovable() ? IconTheme.JabRefIcon.EDIT.getGraphicNode() : null;
        }).withOnMouseClickedEvent(isPseudoAbbreviation -> {
            if (isPseudoAbbreviation.booleanValue()) {
                return evt -> this.addAbbreviation();
            }
            return ((ManageJournalAbbreviationsViewModel)this.viewModel).isAbbreviationEditableAndRemovable() ? evt -> this.editAbbreviation() : evt -> {};
        }));
        this.journalTableDeleteColumn.setCellFactory(new ValueTableCellFactory().withGraphic(isPseudoAbbreviation -> {
            if (!isPseudoAbbreviation.booleanValue() && ((ManageJournalAbbreviationsViewModel)this.viewModel).isAbbreviationEditableAndRemovable()) {
                return IconTheme.JabRefIcon.DELETE_ENTRY.getGraphicNode();
            }
            return null;
        }).withOnMouseClickedEvent(isPseudoAbbreviation -> {
            if (!isPseudoAbbreviation.booleanValue() && ((ManageJournalAbbreviationsViewModel)this.viewModel).isAbbreviationEditableAndRemovable()) {
                return evt -> this.removeAbbreviation();
            }
            return evt -> {};
        }));
    }

    private void setBindings() {
        this.journalAbbreviationsTable.itemsProperty().bindBidirectional(((ManageJournalAbbreviationsViewModel)this.viewModel).abbreviationsProperty());
        this.journalFilesBox.itemsProperty().bindBidirectional(((ManageJournalAbbreviationsViewModel)this.viewModel).journalFilesProperty());
        ((ManageJournalAbbreviationsViewModel)this.viewModel).currentFileProperty().addListener((observable, oldvalue, newvalue) -> this.journalFilesBox.getSelectionModel().select(newvalue));
        this.journalFilesBox.getSelectionModel().selectedItemProperty().addListener((observable, oldvalue, newvalue) -> ((ManageJournalAbbreviationsViewModel)this.viewModel).currentFileProperty().set(newvalue));
        ((ManageJournalAbbreviationsViewModel)this.viewModel).currentAbbreviationProperty().addListener((observable, oldvalue, newvalue) -> this.journalAbbreviationsTable.getSelectionModel().select(newvalue));
        this.journalAbbreviationsTable.getSelectionModel().selectedItemProperty().addListener((observable, oldvalue, newvalue) -> ((ManageJournalAbbreviationsViewModel)this.viewModel).currentAbbreviationProperty().set(newvalue));
        this.removeJournalAbbreviationsButton.disableProperty().bind((ObservableValue)((ManageJournalAbbreviationsViewModel)this.viewModel).isFileRemovableProperty().not());
        this.loadingLabel.visibleProperty().bind((ObservableValue)((ManageJournalAbbreviationsViewModel)this.viewModel).isLoadingProperty());
        this.progressIndicator.visibleProperty().bind((ObservableValue)((ManageJournalAbbreviationsViewModel)this.viewModel).isLoadingProperty());
    }

    @FXML
    private void addNewFile() {
        ((ManageJournalAbbreviationsViewModel)this.viewModel).addNewFile();
    }

    @FXML
    private void openFile() {
        ((ManageJournalAbbreviationsViewModel)this.viewModel).openFile();
    }

    @FXML
    private void removeList() {
        ((ManageJournalAbbreviationsViewModel)this.viewModel).removeCurrentFile();
    }

    @FXML
    private void addAbbreviation() {
        ((ManageJournalAbbreviationsViewModel)this.viewModel).addAbbreviation();
        this.selectNewAbbreviation();
    }

    @FXML
    private void editAbbreviation() {
        this.journalAbbreviationsTable.edit(this.journalAbbreviationsTable.getSelectionModel().getSelectedIndex(), this.journalTableNameColumn);
    }

    private void selectNewAbbreviation() {
        int lastRow = ((ManageJournalAbbreviationsViewModel)this.viewModel).abbreviationsCountProperty().get() - 1;
        this.journalAbbreviationsTable.scrollTo(lastRow);
        this.journalAbbreviationsTable.getSelectionModel().select(lastRow);
        this.journalAbbreviationsTable.getFocusModel().focus(lastRow);
    }

    @FXML
    private void removeAbbreviation() {
        ((ManageJournalAbbreviationsViewModel)this.viewModel).deleteAbbreviation();
    }

    @FXML
    private void closeDialog() {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void saveAbbreviationsAndCloseDialog() {
        Task<Void> task = new Task<Void>(){

            protected Void call() {
                ((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).saveEverythingAndUpdateAutoCompleter();
                return null;
            }
        };
        new Thread((Runnable)task).start();
        this.closeDialog();
    }

    public class JournalAbbreviationsAbbreviationTableEditingCell
    extends TableCell<AbbreviationViewModel, String> {
        private TextField textField;
        private String oldAbbreviation;
        private int editingIndex;

        public void startEdit() {
            if (!this.isEmpty() && ((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).isAbbreviationEditableAndRemovableProperty().get()) {
                this.oldAbbreviation = ((AbbreviationViewModel)((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).currentAbbreviationProperty().get()).getAbbreviation();
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.editingIndex = ManageJournalAbbreviationsController.this.journalAbbreviationsTable.getSelectionModel().getSelectedIndex();
                this.textField.requestFocus();
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
            ((AbbreviationViewModel)((ObservableList)ManageJournalAbbreviationsController.this.journalAbbreviationsTable.itemsProperty().get()).get(this.editingIndex)).setAbbreviation(this.oldAbbreviation);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        public void commitEdit(String abbreviation) {
            ManageJournalAbbreviationsController.this.journalAbbreviationsTable.getSelectionModel().select(this.editingIndex);
            AbbreviationViewModel current = (AbbreviationViewModel)((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).currentAbbreviationProperty().get();
            super.commitEdit((Object)abbreviation);
            current.setAbbreviation(this.oldAbbreviation);
            ((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).editAbbreviation(current.getName(), abbreviation);
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
            this.textField.setOnKeyPressed(t -> {
                if (t.getCode() == KeyCode.ENTER) {
                    if (this.isEditing()) {
                        ManageJournalAbbreviationsController.this.journalAbbreviationsTable.requestFocus();
                    } else {
                        this.startEdit();
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    this.cancelEdit();
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }

    public class JournalAbbreviationsNameTableEditingCell
    extends TableCell<AbbreviationViewModel, String> {
        private TextField textField;
        private String oldName;
        private int editingIndex;

        public void startEdit() {
            if (!this.isEmpty() && ((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).isAbbreviationEditableAndRemovableProperty().get()) {
                this.oldName = ((AbbreviationViewModel)((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).currentAbbreviationProperty().get()).getName();
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.editingIndex = ManageJournalAbbreviationsController.this.journalAbbreviationsTable.getSelectionModel().getSelectedIndex();
                this.textField.requestFocus();
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
            ((AbbreviationViewModel)((ObservableList)ManageJournalAbbreviationsController.this.journalAbbreviationsTable.itemsProperty().get()).get(this.editingIndex)).setName(this.oldName);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        public void commitEdit(String name) {
            ManageJournalAbbreviationsController.this.journalAbbreviationsTable.getSelectionModel().select(this.editingIndex);
            AbbreviationViewModel current = (AbbreviationViewModel)((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).currentAbbreviationProperty().get();
            super.commitEdit((Object)name);
            current.setName(this.oldName);
            ((ManageJournalAbbreviationsViewModel)ManageJournalAbbreviationsController.this.viewModel).editAbbreviation(name, current.getAbbreviation());
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
            this.textField.setOnKeyPressed(t -> {
                if (t.getCode() == KeyCode.ENTER) {
                    if (this.isEditing()) {
                        ManageJournalAbbreviationsController.this.journalAbbreviationsTable.requestFocus();
                    } else {
                        this.startEdit();
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    this.cancelEdit();
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

