/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import ca.odell.glazedlists.gui.TableFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.maintable.MainTableColumn;
import org.jabref.gui.maintable.SpecialMainTableColumnsBuilder;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class MainTableFormat
implements TableFormat<BibEntry> {
    private static final List<String> URL_FIRST = Arrays.asList("url", "doi");
    private static final List<String> DOI_FIRST = Arrays.asList("doi", "url");
    private static final List<String> ARXIV = Collections.singletonList("eprint");
    private final BibDatabase database;
    private final List<MainTableColumn> tableColumns = new ArrayList<MainTableColumn>();

    public MainTableFormat(BibDatabase database) {
        this.database = database;
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.tableColumns.get(col).getDisplayName();
    }

    public MainTableColumn getTableColumn(int index) {
        return this.tableColumns.get(index);
    }

    public int getColumnIndex(String colName) {
        for (MainTableColumn tableColumn : this.tableColumns) {
            if (!tableColumn.getColumnName().equalsIgnoreCase(colName)) continue;
            return this.tableColumns.lastIndexOf(tableColumn);
        }
        return -1;
    }

    @Override
    public Object getColumnValue(BibEntry be, int col) {
        return this.tableColumns.get(col).getColumnValue(be);
    }

    public void updateTableFormat() {
        this.tableColumns.clear();
        SpecialMainTableColumnsBuilder builder = new SpecialMainTableColumnsBuilder();
        this.tableColumns.add(builder.buildNumberColumn());
        if (Globals.prefs.getBoolean("fileColumn")) {
            this.tableColumns.add(builder.buildFileColumn());
        }
        if (Globals.prefs.getBoolean("urlColumn")) {
            if (Globals.prefs.getBoolean("preferUrlDoi")) {
                this.tableColumns.add(builder.createIconColumn("urlColumn", DOI_FIRST, new JLabel(IconTheme.JabRefIcon.DOI.getSmallIcon())));
            } else {
                this.tableColumns.add(builder.createIconColumn("urlColumn", URL_FIRST, new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon())));
            }
        }
        if (Globals.prefs.getBoolean("arxivColumn")) {
            this.tableColumns.add(builder.createIconColumn("arxivColumn", ARXIV, new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon())));
        }
        if (Globals.prefs.getBoolean("extraFileColumns")) {
            List<String> desiredColumns = Globals.prefs.getStringList("listOfFileColumns");
            for (String desiredColumn : desiredColumns) {
                this.tableColumns.add(builder.createFileIconColumn(desiredColumn));
            }
        }
        List<String> colSettings = Globals.prefs.getStringList("columnNames");
        for (String columnName : colSettings) {
            String[] fields = columnName.split("/");
            this.tableColumns.add(new MainTableColumn(columnName, Arrays.asList(fields), this.database));
        }
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                this.tableColumns.add(builder.buildRankingColumn());
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.tableColumns.add(builder.buildRelevanceColumn());
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.tableColumns.add(builder.buildQualityColumn());
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                this.tableColumns.add(builder.buildPriorityColumn());
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.tableColumns.add(builder.buildPrintedColumn());
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                this.tableColumns.add(builder.buildReadStatusColumn());
            }
        }
    }
}

