/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.strings.QuotedStringTokenizer;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;

public class GroupsParser {
    private GroupsParser() {
    }

    public static GroupTreeNode importGroups(List<String> orderedData, Character keywordSeparator, FileUpdateMonitor fileMonitor) throws ParseException {
        try {
            GroupTreeNode cursor = null;
            GroupTreeNode root = null;
            for (String string : orderedData) {
                if ((string = string.trim()).isEmpty()) continue;
                int spaceIndex = string.indexOf(32);
                if (spaceIndex <= 0) {
                    throw new ParseException("Expected \"" + string + "\" to contain whitespace");
                }
                int level = Integer.parseInt(string.substring(0, spaceIndex));
                AbstractGroup group = GroupsParser.fromString(string.substring(spaceIndex + 1), keywordSeparator, fileMonitor);
                GroupTreeNode newNode = GroupTreeNode.fromGroup(group);
                if (cursor == null) {
                    root = cursor = newNode;
                    continue;
                }
                while (level <= cursor.getLevel() && cursor.getParent().isPresent()) {
                    cursor = (GroupTreeNode)cursor.getParent().get();
                }
                cursor.addChild(newNode);
                cursor = newNode;
            }
            return root;
        }
        catch (ParseException e) {
            throw new ParseException(Localization.lang("Group tree could not be parsed. If you save the BibTeX library, all groups will be lost.", new String[0]), e);
        }
    }

    public static AbstractGroup fromString(String s2, Character keywordSeparator, FileUpdateMonitor fileMonitor) throws ParseException {
        if (s2.startsWith("KeywordGroup:")) {
            return GroupsParser.keywordGroupFromString(s2, keywordSeparator);
        }
        if (s2.startsWith("AllEntriesGroup:")) {
            return GroupsParser.allEntriesGroupFromString(s2);
        }
        if (s2.startsWith("SearchGroup:")) {
            return GroupsParser.searchGroupFromString(s2);
        }
        if (s2.startsWith("StaticGroup:")) {
            return GroupsParser.explicitGroupFromString(s2, keywordSeparator);
        }
        if (s2.startsWith("ExplicitGroup:")) {
            return GroupsParser.legacyExplicitGroupFromString(s2, keywordSeparator);
        }
        if (s2.startsWith("AutomaticPersonsGroup:")) {
            return GroupsParser.automaticPersonsGroupFromString(s2);
        }
        if (s2.startsWith("AutomaticKeywordGroup:")) {
            return GroupsParser.automaticKeywordGroupFromString(s2);
        }
        if (s2.startsWith("TexGroup:")) {
            return GroupsParser.texGroupFromString(s2, fileMonitor);
        }
        throw new ParseException("Unknown group: " + s2);
    }

    private static AbstractGroup texGroupFromString(String string, FileUpdateMonitor fileMonitor) throws ParseException {
        QuotedStringTokenizer tok = new QuotedStringTokenizer(string.substring("TexGroup:".length()), ";", '\\');
        String name = StringUtil.unquote(tok.nextToken(), '\\');
        GroupHierarchyType context = GroupHierarchyType.getByNumberOrDefault(Integer.parseInt(tok.nextToken()));
        try {
            Path path = Paths.get(tok.nextToken(), new String[0]);
            TexGroup newGroup = new TexGroup(name, context, path, new DefaultAuxParser(new BibDatabase()), fileMonitor);
            GroupsParser.addGroupDetails(tok, newGroup);
            return newGroup;
        }
        catch (IOException | InvalidPathException ex) {
            throw new ParseException(ex);
        }
    }

    private static AbstractGroup automaticPersonsGroupFromString(String string) {
        if (!string.startsWith("AutomaticPersonsGroup:")) {
            throw new IllegalArgumentException("KeywordGroup cannot be created from \"" + string + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(string.substring("AutomaticPersonsGroup:".length()), ";", '\\');
        String name = StringUtil.unquote(tok.nextToken(), '\\');
        GroupHierarchyType context = GroupHierarchyType.getByNumberOrDefault(Integer.parseInt(tok.nextToken()));
        String field2 = StringUtil.unquote(tok.nextToken(), '\\');
        AutomaticPersonsGroup newGroup = new AutomaticPersonsGroup(name, context, field2);
        GroupsParser.addGroupDetails(tok, newGroup);
        return newGroup;
    }

    private static AbstractGroup automaticKeywordGroupFromString(String string) {
        if (!string.startsWith("AutomaticKeywordGroup:")) {
            throw new IllegalArgumentException("KeywordGroup cannot be created from \"" + string + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(string.substring("AutomaticKeywordGroup:".length()), ";", '\\');
        String name = StringUtil.unquote(tok.nextToken(), '\\');
        GroupHierarchyType context = GroupHierarchyType.getByNumberOrDefault(Integer.parseInt(tok.nextToken()));
        String field2 = StringUtil.unquote(tok.nextToken(), '\\');
        Character delimiter = Character.valueOf(tok.nextToken().charAt(0));
        Character hierarchicalDelimiter = Character.valueOf(tok.nextToken().charAt(0));
        AutomaticKeywordGroup newGroup = new AutomaticKeywordGroup(name, context, field2, delimiter, hierarchicalDelimiter);
        GroupsParser.addGroupDetails(tok, newGroup);
        return newGroup;
    }

    private static KeywordGroup keywordGroupFromString(String s2, Character keywordSeparator) throws ParseException {
        if (!s2.startsWith("KeywordGroup:")) {
            throw new IllegalArgumentException("KeywordGroup cannot be created from \"" + s2 + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s2.substring("KeywordGroup:".length()), ";", '\\');
        String name = StringUtil.unquote(tok.nextToken(), '\\');
        GroupHierarchyType context = GroupHierarchyType.getByNumberOrDefault(Integer.parseInt(tok.nextToken()));
        String field2 = StringUtil.unquote(tok.nextToken(), '\\');
        String expression = StringUtil.unquote(tok.nextToken(), '\\');
        boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
        boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
        KeywordGroup newGroup = regExp ? new RegexKeywordGroup(name, context, field2, expression, caseSensitive) : new WordKeywordGroup(name, context, field2, expression, caseSensitive, keywordSeparator, false);
        GroupsParser.addGroupDetails(tok, newGroup);
        return newGroup;
    }

    private static ExplicitGroup explicitGroupFromString(String input, Character keywordSeparator) throws ParseException {
        if (!input.startsWith("StaticGroup:")) {
            throw new IllegalArgumentException("ExplicitGroup cannot be created from \"" + input + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(input.substring("StaticGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        try {
            int context = Integer.parseInt(tok.nextToken());
            ExplicitGroup newGroup = new ExplicitGroup(name, GroupHierarchyType.getByNumberOrDefault(context), keywordSeparator);
            GroupsParser.addGroupDetails(tok, newGroup);
            return newGroup;
        }
        catch (NumberFormatException exception) {
            throw new ParseException("Could not parse context in " + input);
        }
    }

    private static ExplicitGroup legacyExplicitGroupFromString(String input, Character keywordSeparator) throws ParseException {
        if (!input.startsWith("ExplicitGroup:")) {
            throw new IllegalArgumentException("ExplicitGroup cannot be created from \"" + input + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(input.substring("ExplicitGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        try {
            int context = Integer.parseInt(tok.nextToken());
            ExplicitGroup newGroup = new ExplicitGroup(name, GroupHierarchyType.getByNumberOrDefault(context), keywordSeparator);
            GroupsParser.addLegacyEntryKeys(tok, newGroup);
            return newGroup;
        }
        catch (NumberFormatException exception) {
            throw new ParseException("Could not parse context in " + input);
        }
    }

    private static void addLegacyEntryKeys(QuotedStringTokenizer tok, ExplicitGroup group) {
        while (tok.hasMoreTokens()) {
            String key = StringUtil.unquote(tok.nextToken(), '\\');
            group.addLegacyEntryKey(key);
        }
    }

    private static AbstractGroup allEntriesGroupFromString(String s2) {
        if (!s2.startsWith("AllEntriesGroup:")) {
            throw new IllegalArgumentException("AllEntriesGroup cannot be created from \"" + s2 + "\".");
        }
        return DefaultGroupsFactory.getAllEntriesGroup();
    }

    private static AbstractGroup searchGroupFromString(String s2) {
        if (!s2.startsWith("SearchGroup:")) {
            throw new IllegalArgumentException("SearchGroup cannot be created from \"" + s2 + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s2.substring("SearchGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        int context = Integer.parseInt(tok.nextToken());
        String expression = tok.nextToken();
        boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
        boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
        return new SearchGroup(StringUtil.unquote(name, '\\'), GroupHierarchyType.getByNumberOrDefault(context), StringUtil.unquote(expression, '\\'), caseSensitive, regExp);
    }

    private static void addGroupDetails(QuotedStringTokenizer tokenizer, AbstractGroup group) {
        if (tokenizer.hasMoreTokens()) {
            group.setExpanded(Integer.parseInt(tokenizer.nextToken()) == 1);
            group.setColor(tokenizer.nextToken());
            group.setIconName(tokenizer.nextToken());
            group.setDescription(tokenizer.nextToken());
        }
    }
}

