/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class TypeChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("pages");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        if ("proceedings".equalsIgnoreCase(entry.getType())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("wrong entry type as proceedings has page numbers", new String[0]), entry, "pages"));
        }
        return Collections.emptyList();
    }
}

