/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.model.entry.Keyword;
import org.jabref.model.strings.StringUtil;

public class KeywordList
implements Iterable<Keyword> {
    private final List<Keyword> keywordChains = new ArrayList<Keyword>();

    public KeywordList() {
    }

    public KeywordList(Collection<Keyword> keywordChains) {
        keywordChains.forEach(this::add);
    }

    public KeywordList(List<String> keywordChains) {
        this(keywordChains.stream().map(Keyword::new).collect(Collectors.toList()));
    }

    public KeywordList(String ... keywordChains) {
        this(Arrays.stream(keywordChains).map(Keyword::new).collect(Collectors.toList()));
    }

    public KeywordList(Keyword ... keywordChains) {
        this((Collection<Keyword>)Arrays.asList(keywordChains));
    }

    public static KeywordList parse(String keywordString, Character delimiter, Character hierarchicalDelimiter) {
        if (StringUtil.isBlank(keywordString)) {
            return new KeywordList();
        }
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(hierarchicalDelimiter);
        KeywordList keywordList = new KeywordList();
        StringTokenizer tok = new StringTokenizer(keywordString, delimiter.toString());
        while (tok.hasMoreTokens()) {
            String chain = tok.nextToken();
            Keyword chainRoot = Keyword.of(chain.split(hierarchicalDelimiter.toString()));
            keywordList.add(chainRoot);
        }
        return keywordList;
    }

    public static KeywordList parse(String keywordString, Character delimiter) {
        return KeywordList.parse(keywordString, delimiter, Keyword.DEFAULT_HIERARCHICAL_DELIMITER);
    }

    public KeywordList createClone() {
        return new KeywordList((Collection<Keyword>)this.keywordChains);
    }

    public void replaceAll(KeywordList keywordsToReplace, Keyword newValue) {
        Objects.requireNonNull(newValue);
        int foundPosition = -1;
        for (Keyword specialFieldKeyword : keywordsToReplace) {
            int pos = this.keywordChains.indexOf(specialFieldKeyword);
            if (pos < 0) continue;
            foundPosition = pos;
            this.keywordChains.remove(pos);
        }
        if (foundPosition == -1) {
            this.add(newValue);
        } else {
            this.keywordChains.add(foundPosition, newValue);
        }
    }

    public void removeAll(KeywordList keywordsToRemove) {
        this.keywordChains.removeAll(keywordsToRemove.keywordChains);
    }

    public boolean add(Keyword keyword) {
        if (this.contains(keyword)) {
            return false;
        }
        return this.keywordChains.add(keyword);
    }

    public String getAsString(Character delimiter) {
        return this.keywordChains.stream().map(Keyword::toString).collect(Collectors.joining(delimiter + " "));
    }

    public void add(String keywordsString) {
        this.add(new Keyword(keywordsString));
    }

    @Override
    public Iterator<Keyword> iterator() {
        return this.keywordChains.iterator();
    }

    public int size() {
        return this.keywordChains.size();
    }

    public boolean isEmpty() {
        return this.keywordChains.isEmpty();
    }

    public boolean contains(Keyword o) {
        return this.keywordChains.contains(o);
    }

    public boolean remove(Keyword o) {
        return this.keywordChains.remove(o);
    }

    public boolean remove(String keywordsString) {
        return this.keywordChains.remove(new Keyword(keywordsString));
    }

    public void addAll(KeywordList keywordsToAdd) {
        this.keywordChains.addAll(keywordsToAdd.keywordChains);
    }

    public void retainAll(KeywordList keywordToRetain) {
        this.keywordChains.retainAll(keywordToRetain.keywordChains);
    }

    public void clear() {
        this.keywordChains.clear();
    }

    public Keyword get(int index) {
        return this.keywordChains.get(index);
    }

    public Stream<Keyword> stream() {
        return this.keywordChains.stream();
    }

    public String toString() {
        return this.getAsString(Character.valueOf(','));
    }

    public Set<String> toStringList() {
        return this.keywordChains.stream().map(Keyword::toString).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordList keywords1 = (KeywordList)o;
        return Objects.equals(this.keywordChains, keywords1.keywordChains);
    }

    public int hashCode() {
        return Objects.hash(this.keywordChains);
    }
}

