/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOI
implements Identifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOI.class);
    private static final URI RESOLVER = URI.create("https://doi.org");
    private static final String DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))";
    private static final String FIND_DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s]+))";
    private static final String HTTP_EXP = "https?://[^\\s]+?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))";
    private static final Pattern EXACT_DOI_PATT = Pattern.compile("^(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:%](?:.+))$", 2);
    private static final Pattern DOI_PATT = Pattern.compile("(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s]+))", 2);
    private final String doi;

    public DOI(String doi) {
        Matcher matcher;
        Objects.requireNonNull(doi);
        String trimmedDoi = doi.trim();
        if (doi.matches(HTTP_EXP)) {
            try {
                URI url = new URI(trimmedDoi);
                trimmedDoi = url.getScheme() + "://" + url.getHost() + url.getPath();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(doi + " is not a valid HTTP DOI.");
            }
        }
        if (!(matcher = EXACT_DOI_PATT.matcher(trimmedDoi)).find()) {
            throw new IllegalArgumentException(trimmedDoi + " is not a valid DOI.");
        }
        this.doi = matcher.group(1);
    }

    public static Optional<DOI> parse(String doi) {
        try {
            String cleanedDOI = doi.trim();
            cleanedDOI = doi.replaceAll(" ", "");
            return Optional.of(new DOI(cleanedDOI));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static boolean isValid(String doi) {
        return DOI.parse(doi).isPresent();
    }

    public static Optional<DOI> findInText(String text) {
        Optional<DOI> result = Optional.empty();
        Matcher matcher = DOI_PATT.matcher(text);
        if (matcher.find()) {
            result = Optional.of(new DOI(matcher.group(1)));
        }
        return result;
    }

    public String toString() {
        return "DOI{doi='" + this.doi + '\'' + '}';
    }

    public String getDOI() {
        return this.doi;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            URI uri = new URI(RESOLVER.getScheme(), RESOLVER.getHost(), "/" + this.doi, null);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOGGER.error(this.doi + " could not be encoded as URI.", e);
            return Optional.empty();
        }
    }

    public String getURIAsASCIIString() {
        return this.getExternalURI().map(URI::toASCIIString).orElse("");
    }

    @Override
    public String getDefaultField() {
        return "doi";
    }

    @Override
    public String getNormalized() {
        return this.doi;
    }
}

