/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SentenceAnalyzer;

public class ContainBasedSearchRule
implements SearchRule {
    private final boolean caseSensitive;

    public ContainBasedSearchRule(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean validateSearchStrings(String query) {
        return true;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        String searchString = query;
        if (!this.caseSensitive) {
            searchString = searchString.toLowerCase(Locale.ROOT);
        }
        List<String> unmatchedWords = new SentenceAnalyzer(searchString).getWords();
        for (String fieldKey : bibEntry.getFieldNames()) {
            String formattedFieldContent = bibEntry.getLatexFreeField(fieldKey).get();
            if (!this.caseSensitive) {
                formattedFieldContent = formattedFieldContent.toLowerCase(Locale.ROOT);
            }
            Iterator<String> unmatchedWordsIterator = unmatchedWords.iterator();
            while (unmatchedWordsIterator.hasNext()) {
                String word = unmatchedWordsIterator.next();
                if (!formattedFieldContent.contains(word)) continue;
                unmatchedWordsIterator.remove();
            }
            if (!unmatchedWords.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

