/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0001J\u0011\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0096\u0001J\u0013\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0096\u0001J\u0011\u0010(\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0096\u0001J\u0011\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0096\u0001J\u0011\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0096\u0001J\u0011\u00102\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u00103\u001a\u00020\u001b2\u0006\u00100\u001a\u000204H\u0096\u0001J\u0011\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\b\u00107\u001a\u000208H\u0002J\u001a\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u00062\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "parent", "currentBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "currentScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;)V", "continuation", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getContinuation", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCurrentBlock", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getCurrentScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isCoroutineDoResume", "", "newDeclaration", "scope", "func", "backend.js"})
public final class JsGenerationContext
implements IrNamer {
    @Nullable
    private final JsGenerationContext parent;
    @NotNull
    private final JsBlock currentBlock;
    @NotNull
    private final JsScope currentScope;
    @Nullable
    private final IrFunction currentFunction;
    @NotNull
    private final JsStaticContext staticContext;

    @NotNull
    public final JsGenerationContext newDeclaration(@NotNull JsScope scope, @Nullable IrFunction func) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        return new JsGenerationContext(this, func != null ? new JsBlock() : (JsBlock)new JsGlobalBlock(), scope, func, this.staticContext);
    }

    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, JsScope jsScope, IrFunction irFunction, int n, Object object) {
        if ((n & 2) != 0) {
            irFunction = null;
        }
        return jsGenerationContext.newDeclaration(jsScope, irFunction);
    }

    @NotNull
    public final JsExpression getContinuation() {
        JsExpression jsExpression;
        if (this.isCoroutineDoResume()) {
            jsExpression = new JsThisRef();
        } else {
            JsNameRef jsNameRef;
            IrFunction irFunction = this.currentFunction;
            if (irFunction == null) {
                Intrinsics.throwNpe();
            }
            if (irFunction.getDescriptor().isSuspend()) {
                jsNameRef = new JsNameRef(this.currentScope.declareName(Namer.INSTANCE.getCONTINUATION()));
            } else {
                JsNameRef jsNameRef2 = this.getNameForValueDeclaration((IrValueDeclaration)CollectionsKt.last(this.currentFunction.getValueParameters())).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"getNameForValueDeclarati\u2026ameters.last()).makeRef()");
            }
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private final boolean isCoroutineDoResume() {
        Object object;
        IrFunction irFunction = this.currentFunction;
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        if ((object = (IrSimpleFunction)irFunction) == null || (object = object.getOverriddenSymbols()) == null) {
            return false;
        }
        Object overriddenSymbols2 = object;
        return overriddenSymbols2.contains(this.staticContext.getDoResumeFunctionSymbol());
    }

    @Nullable
    public final JsGenerationContext getParent() {
        return this.parent;
    }

    @NotNull
    public final JsBlock getCurrentBlock() {
        return this.currentBlock;
    }

    @NotNull
    public final JsScope getCurrentScope() {
        return this.currentScope;
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    public JsGenerationContext(@Nullable JsGenerationContext parent2, @NotNull JsBlock currentBlock, @NotNull JsScope currentScope2, @Nullable IrFunction currentFunction, @NotNull JsStaticContext staticContext) {
        Intrinsics.checkParameterIsNotNull((Object)currentBlock, (String)"currentBlock");
        Intrinsics.checkParameterIsNotNull((Object)currentScope2, (String)"currentScope");
        Intrinsics.checkParameterIsNotNull((Object)staticContext, (String)"staticContext");
        this.parent = parent2;
        this.currentBlock = currentBlock;
        this.currentScope = currentScope2;
        this.currentFunction = currentFunction;
        this.staticContext = staticContext;
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        return this.staticContext.getNameForClass(klass2);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
        return this.staticContext.getNameForConstructor(constructor2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field2) {
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        return this.staticContext.getNameForField(field2);
    }

    @Override
    @Nullable
    public String getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        return this.staticContext.getNameForLoop(loop2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field2) {
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        return this.staticContext.getNameForMemberField(field2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.staticContext.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        return this.staticContext.getNameForProperty(property2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.staticContext.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.staticContext.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.staticContext.getNameForValueDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        return this.staticContext.getRefForExternalClass(klass2);
    }
}

