/*
 * Decompiled with CFR 0.152.
 */
package deepview2;

import deepview2.dvNode;
import deepview2.dvPrpRootObject;
import deepview2.guiTree;
import deepview2.nodeinfo;
import java.util.Vector;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import shared.m;

public class dvPrp
extends dvNode {
    String pagename;

    public dvPrp(nodeinfo info) {
        this.info = info;
        this.pagename = info.prp.header.pagename.toString();
        Vector<Vector<PrpRootObject>> oo = info.prp.getOrderedObjects();
        for (Vector<PrpRootObject> type : oo) {
            nodeinfo childinfo = new nodeinfo();
            childinfo.prp = info.prp;
            childinfo.root = info.root;
            this.children.add(new dvPrpType(childinfo, type));
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public void onDoubleClick(guiTree tree) {
        tree.expandCurrentSelection();
    }

    public String toString() {
        return this.pagename;
    }

    public void onSave() throws Exception {
        if (this.info.prp.hasChanged()) {
            m.status("Saving prp: " + this.info.prp.filename);
            this.info.prp.saveAsFile(this.info.prp.filename);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class dvPrpType
    extends dvNode {
        Typeid type;
        Vector<PrpRootObject> objects;

        public dvPrpType(nodeinfo info, Vector<PrpRootObject> type) {
            this.info = info;
            this.objects = type;
            this.type = this.objects.get((int)0).header.objecttype;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void onDoubleClick(guiTree tree) {
            tree.expandCurrentSelection();
        }

        @Override
        public void loadChildren() {
            this.children.clear();
            for (PrpRootObject ro : this.objects) {
                nodeinfo childinfo = new nodeinfo();
                childinfo.name = ro.header.desc.objectname.toString();
                childinfo.rootobject = ro;
                childinfo.prp = this.info.prp;
                childinfo.root = this.info.root;
                dvPrpRootObject child = new dvPrpRootObject(childinfo);
                this.children.add(child);
            }
        }

        public String toString() {
            return this.type.toString();
        }
    }
}

