/*
 * Decompiled with CFR 0.152.
 */
package gui;

import auto.AllGames;
import filesearcher.search;
import gui.Gui;
import gui.ThreadedTasks;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import shared.FileUtils;
import shared.GetResource;
import shared.State.AllStates;
import shared.State.ButtongroupState;
import shared.delegate;
import shared.m;
import shared.sevenzip;
import shared.translation;
import uam.ThreadDownloadAndProcess;
import uam.Uam;
import uam.UamConfigNew;

public class UamGui {
    public static JList agelist;
    public static JList verlist;
    public static JList mirlist;
    public static Gui guiform;
    public static JButton downloadbutton;
    public static JButton deletebutton;
    public static JButton versionbutton;
    public static JLabel AgeLabel;
    public static ButtongroupState startup;
    static final boolean updateWhileAdjusting = false;

    public static void init() {
        agelist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                if (((JList)e2.getSource()).getSelectedValue() == null) {
                    ((JList)e2.getSource()).setSelectedIndex(0);
                }
                String age = ((AgeListItemInfo)((JList)e2.getSource()).getSelectedValue()).agename;
                UamGui.GetVersionListGui(age);
            }

            public String toString() {
                return "test";
            }
        });
        agelist.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String agename = ((AgeListItemInfo)value).agename;
                Uam.InstallStatus status = Uam.installInfo.ages.get((Object)agename).installationStatus;
                String properagename = Uam.ageList.getAgeProperName(agename);
                AgeListItem ali = new AgeListItem(properagename, status, agename);
                if (isSelected) {
                    ali.setBorder(BorderFactory.createLineBorder(Color.black));
                }
                return ali;
            }
        });
        verlist.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object o = agelist.getSelectedValue();
                String agename = ((AgeListItemInfo)o).agename;
                String version = (String)value;
                Uam.InstallStatus status = Uam.installInfo.ages.get((Object)agename).versions.get(version);
                AgeListItem ali = new AgeListItem(version, status, null);
                if (isSelected) {
                    ali.setBorder(BorderFactory.createLineBorder(Color.black));
                }
                return ali;
            }
        });
        verlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                String age2 = ((AgeListItemInfo)UamGui.agelist.getSelectedValue()).agename;
                String ver = (String)verlist.getSelectedValue();
                UamGui.GetMirrorListGui(age2, ver);
            }
        });
        mirlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                String age2 = ((AgeListItemInfo)UamGui.agelist.getSelectedValue()).agename;
                String ver2 = (String)verlist.getSelectedValue();
                String mir = (String)mirlist.getSelectedValue();
                UamGui.OnMirrorSelected(age2, ver2, mir);
            }
        });
        mirlist.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String version = (String)value;
                Uam.InstallStatus status = Uam.InstallStatus.notInCache;
                AgeListItem ali = new AgeListItem(version, status, null);
                ali.showicon = false;
                if (isSelected) {
                    ali.setBorder(BorderFactory.createLineBorder(Color.black));
                }
                return ali;
            }
        });
        AllStates.addCallbackAfterInit(new delegate(){

            public void callback(Object arg) {
                int startuptype = AllStates.getStateAsInt("uamStartup");
                switch (startuptype) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String potsfolder = AllStates.getStateAsString("uamRoot");
                        UamGui.GetAgeListGuiOffline(potsfolder);
                        break;
                    }
                    case 2: {
                        String uamserver = AllStates.getStateAsString("uamServer2");
                        String potsfolder2 = AllStates.getStateAsString("uamRoot");
                        ThreadedTasks.uamDownloadAgeList(uamserver, potsfolder2);
                        break;
                    }
                    default: {
                        m.err("Unhandled UAM startup type.");
                    }
                }
            }
        });
    }

    public static String GetCurrentlySelectedAge() {
        Object selobj = agelist.getSelectedValue();
        AgeListItemInfo item = (AgeListItemInfo)selobj;
        return item.agename;
    }

    public static void ReportVersion() {
        String agename = UamGui.GetCurrentlySelectedAge();
        if (Uam.installInfo.getAge((String)agename).installationStatus.isInstalled()) {
            String installedVersion = Uam.TryToFindInstalledVersionOfAge(agename);
            if (installedVersion != null) {
                m.msg("Installed Version: ", installedVersion);
            } else {
                m.warn("Unable to figure out which version is installed for Age: ", agename);
            }
        } else {
            m.msg("This Age isn't installed: ", agename);
        }
    }

    public static void GetLocalInfo(String potsfolder) {
        Uam.InstallInfo ii = new Uam.InstallInfo();
        boolean numAgesNotInstalled = false;
        boolean numAgesNeedUpdate = false;
        for (UamConfigNew.UamConfigData.Age ageobj : Uam.ageList.data.ages) {
            String age = ageobj.filename;
            boolean hasagefile = FileUtils.Exists(potsfolder + "/" + ageobj.getMainfile());
            boolean isInCache = false;
            boolean haslatest = false;
            boolean someversionexists = false;
            Uam.AgeInstallInfo ageinfo = ii.getOrCreateAge(age);
            boolean first = true;
            for (UamConfigNew.UamConfigData.Age.Version verobj : ageobj.versions) {
                someversionexists = true;
                String version = verobj.name;
                boolean hasversion = FileUtils.Exists(potsfolder + "/agearchives/" + age + "--" + version + ".7z");
                ageinfo.versions.put(version, hasversion ? Uam.InstallStatus.latestVersionInCache : Uam.InstallStatus.notInstalled);
                if (hasversion) {
                    isInCache = true;
                    if (first) {
                        haslatest = true;
                    }
                }
                first = false;
            }
            if (someversionexists) {
                if (hasagefile) {
                    if (isInCache) {
                        if (haslatest) {
                            ii.getOrCreateAge((String)age).installationStatus = Uam.InstallStatus.latestVersionInCache;
                            continue;
                        }
                        ii.getOrCreateAge((String)age).installationStatus = Uam.InstallStatus.nonLatestVersionInCache;
                        continue;
                    }
                    ii.getOrCreateAge((String)age).installationStatus = Uam.InstallStatus.notInCache;
                    continue;
                }
                ii.getOrCreateAge((String)age).installationStatus = Uam.InstallStatus.notInstalled;
                continue;
            }
            ii.getOrCreateAge((String)age).installationStatus = Uam.InstallStatus.noVersionsExist;
        }
        Uam.installInfo = ii;
    }

    public static void RefreshInfo() {
        UamGui.RefreshInfo(Uam.getPotsFolder());
    }

    public static void RefreshInfo(String potsfolder2) {
        String welcomeMessage = Uam.ageList.getWelcomeMessage();
        m.msg(welcomeMessage);
        UamGui.GetLocalInfo(potsfolder2);
        Vector<AgeListItemInfo> ages = new Vector<AgeListItemInfo>();
        for (UamConfigNew.UamConfigData.Age age : Uam.ageList.data.ages) {
            Uam.InstallStatus is = Uam.installInfo.ages.get((Object)age.filename).installationStatus;
            ages.add(new AgeListItemInfo(age.propername, is, age.filename));
        }
        final Vector<AgeListItemInfo> ages2 = ages;
        Object selection = agelist.getSelectedValue();
        agelist.setValueIsAdjusting(true);
        verlist.setValueIsAdjusting(true);
        mirlist.setValueIsAdjusting(true);
        mirlist.setModel(new DefaultListModel());
        verlist.setModel(new DefaultListModel());
        agelist.setModel(new ListModel(){

            public int getSize() {
                return ages2.size();
            }

            public Object getElementAt(int index) {
                return ages2.get(index);
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        if (selection == null) {
            if (agelist.getModel().getSize() > 0) {
                agelist.setSelectedIndex(0);
            }
        } else {
            agelist.setSelectedValue(selection, true);
        }
        agelist.setValueIsAdjusting(false);
        verlist.setValueIsAdjusting(false);
        mirlist.setValueIsAdjusting(false);
        if (Uam.ageList.getDrizzleVersion() > 31) {
            m.msg("(", "A new version of Drizzle is available: ", "Drizzle" + Integer.toString(Uam.ageList.getDrizzleVersion()), ")");
        }
        Uam.installInfo.printStatsMessage();
        Uam.CheckForProblems(false);
    }

    public static void GetAgeListGuiOffline(String potsfolder) {
        UamConfigNew ageList;
        FileInputStream in;
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return;
        }
        try {
            in = new FileInputStream(potsfolder + "/agearchives/" + "uam.status.xml");
        }
        catch (FileNotFoundException e2) {
            m.err("Couldn't find cached list.");
            return;
        }
        Uam.ageList = ageList = new UamConfigNew(in);
        UamGui.RefreshInfo(potsfolder);
    }

    public static void GetAgeListGui(String server, String potsfolder) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return;
        }
        if (!Uam.HasPermissions(potsfolder)) {
            return;
        }
        final String potsfolder2 = potsfolder;
        ThreadDownloadAndProcess.downloadConfig(server, potsfolder, new delegate(){

            public void callback(Object arg) {
                UamConfigNew ageList;
                byte[] result = (byte[])arg;
                ByteArrayInputStream in = new ByteArrayInputStream(result);
                Uam.ageList = ageList = new UamConfigNew(in);
                UamGui.RefreshInfo(potsfolder2);
            }
        });
    }

    public static void GetVersionListGui(String age) {
        String age2 = age;
        if (age != null) {
            boolean deletable = Uam.ageList.getDeletable(age) && Uam.installInfo.getAge((String)age).installationStatus.isInstalled();
            deletebutton.setEnabled(deletable);
            String info = Uam.ageList.getAgeInfo(age);
            AgeLabel.setText("<html>" + info + "</html>");
            boolean doversion = Uam.installInfo.getAge((String)age).installationStatus.isInstalled();
            versionbutton.setEnabled(doversion);
        } else {
            deletebutton.setEnabled(false);
            AgeLabel.setText(translation.translate("<html>", "(Select an Age, or click \"Get Latest List\" to get the latest list of Ages.)", "</html>"));
        }
        final Vector<UamConfigNew.UamConfigData.Age.Version> vers = Uam.ageList.getAllVersions(age);
        verlist.setModel(new ListModel(){

            public int getSize() {
                return vers.size();
            }

            public Object getElementAt(int index) {
                return ((UamConfigNew.UamConfigData.Age.Version)vers.get((int)index)).name;
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        mirlist.setModel(new DefaultListModel());
        if (verlist.getModel().getSize() > 0) {
            verlist.setSelectedIndex(0);
        }
    }

    public static void GetMirrorListGui(String age, String ver) {
        String age2 = age;
        String ver2 = ver;
        final Vector<UamConfigNew.UamConfigData.Age.Version.Mirror> mirs = Uam.ageList.getAllMirrors(age, ver);
        mirlist.setModel(new ListModel(){

            public int getSize() {
                return mirs.size();
            }

            public Object getElementAt(int index) {
                return ((UamConfigNew.UamConfigData.Age.Version.Mirror)mirs.get((int)index)).url;
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        if (mirlist.getModel().getSize() > 0) {
            mirlist.setSelectedIndex(0);
        }
    }

    public static void OnMirrorSelected(String age, String ver, String mir) {
        if (mir != null) {
            downloadbutton.setEnabled(true);
        } else {
            downloadbutton.setEnabled(false);
        }
    }

    public static void PerformDeletionAction() {
        String potsfolder = AllStates.getStateAsString("uamRoot");
        if (UamGui.PerformDeletion(potsfolder)) {
            UamGui.RefreshInfo(potsfolder);
        }
    }

    public static boolean PerformDeletion(String potsfolder) {
        String age = ((AgeListItemInfo)UamGui.agelist.getSelectedValue()).agename;
        return UamGui.PerformDeletion(potsfolder, age);
    }

    public static boolean PerformDeletion(String potsfolder, String age) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return false;
        }
        if (!Uam.HasPermissions(potsfolder)) {
            return false;
        }
        if (age == null) {
            m.msg("You must select an Age.");
            return false;
        }
        for (String del : Uam.ageList.getDels(age)) {
            String absfilename = potsfolder + "/" + del;
            FileUtils.DeleteFile2(absfilename);
        }
        if (Uam.ageList.getDeletable(age)) {
            Vector<File> files = search.getAllFilesWithExtension(potsfolder + "/agearchives/", false, ".7z");
            for (File f : files) {
                if (!f.getName().startsWith(age + "--") || f.length() == 0L) continue;
                sevenzip.delete(f.getAbsolutePath(), potsfolder);
            }
        } else {
            m.msg("This Age is listed as not being safely deletable; performing upgrade only.");
        }
        return true;
    }

    public static boolean PerformDownload() {
        String potsfolder = AllStates.getStateAsString("uamRoot");
        Object[] ages = agelist.getSelectedValues();
        if (ages.length > 1) {
            boolean success = true;
            for (Object age2 : ages) {
                String mir;
                boolean result;
                String age = ((AgeListItemInfo)age2).agename;
                UamConfigNew.UamConfigData.Age a = Uam.ageList.data.getAge(age);
                if (a.versions.size() == 0) continue;
                UamConfigNew.UamConfigData.Age.Version ver2 = a.versions.get(0);
                String ver = ver2.name;
                if (ver2.mirrors.size() == 0 || (result = UamGui.PerformDownload(potsfolder, age, ver, mir = ver2.mirrors.get((int)0).url))) continue;
                success = false;
            }
            return success;
        }
        String age = ((AgeListItemInfo)UamGui.agelist.getSelectedValue()).agename;
        String ver = (String)verlist.getSelectedValue();
        String mir = (String)mirlist.getSelectedValue();
        return UamGui.PerformDownload(potsfolder, age, ver, mir);
    }

    public static boolean PerformDownload(String potsfolder, String age, String ver, String mir) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return false;
        }
        if (!Uam.HasPermissions(potsfolder)) {
            return false;
        }
        if (age == null || ver == null || mir == null) {
            m.msg("You must select an Age, Version, and Mirror.");
            return false;
        }
        String archiveType = Uam.ageList.getArchiveType(age, ver);
        if (!archiveType.equals("7z")) {
            m.err("This version is in a archive type not currently supported: ", archiveType);
            return false;
        }
        m.msg("Cleaning up any previous version...");
        if (!UamGui.PerformDeletion(potsfolder, age)) {
            return false;
        }
        m.status("Checking to see if we already have this version in the cache...");
        if (FileUtils.Exists(potsfolder + "/agearchives/" + age + "--" + ver + ".7z")) {
            m.status("Using cached version of Age: ", age, ", Version: ", ver, " ...");
            String hash = Uam.ageList.getSha1(age, ver);
            ThreadDownloadAndProcess.extractAge(age, ver, potsfolder, hash);
        } else {
            m.msg("Attempting to download Age: ", age, ", Version: ", ver, ", Mirror: ", mir);
            String hash = Uam.ageList.getSha1(age, ver);
            ThreadDownloadAndProcess.downloadAge(age, ver, mir, potsfolder, hash);
        }
        return true;
    }

    public static class AgeListItem
    extends JPanel {
        String agename2;
        String FriendlyAgename;
        Uam.InstallStatus status;
        static Image check = GetResource.getResourceAsImage("/gui/check.png");
        static Image up = GetResource.getResourceAsImage("/gui/up.png");
        static Image unknown = GetResource.getResourceAsImage("/gui/unknown.png");
        static Image dashred = GetResource.getResourceAsImage("/gui/dashred.png");
        Image img;
        public boolean showicon = true;
        int width;

        public String toString() {
            return this.FriendlyAgename;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AgeListItem)) {
                return false;
            }
            AgeListItem o2 = (AgeListItem)o;
            boolean result = this.FriendlyAgename.equals(o2.FriendlyAgename);
            return result;
        }

        public int hashCode() {
            return this.FriendlyAgename.hashCode();
        }

        public AgeListItem(String friendlyAgename, Uam.InstallStatus status, String agename) {
            this.agename2 = agename;
            this.FriendlyAgename = friendlyAgename;
            this.status = status;
            this.setOpaque(true);
            if (status == null) {
                return;
            }
            switch (status) {
                case noVersionsExist: {
                    this.setForeground(new Color(170));
                    this.img = null;
                    break;
                }
                case notInstalled: {
                    this.setForeground(new Color(0x770000));
                    this.img = dashred;
                    break;
                }
                case latestVersionInCache: {
                    this.setForeground(new Color(30464));
                    this.img = check;
                    break;
                }
                case nonLatestVersionInCache: {
                    this.setForeground(new Color(0x777700));
                    this.img = up;
                    break;
                }
                case notInCache: {
                    this.setForeground(Color.black);
                    this.img = unknown;
                    break;
                }
                default: {
                    this.setForeground(Color.black);
                    this.img = unknown;
                }
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int h = this.getHeight();
            String str = this.FriendlyAgename;
            int offset = this.showicon ? 20 : 3;
            g.drawString(str, offset, h - 3);
            if (this.showicon && this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }

        public Dimension getPreferredSize() {
            int w;
            this.setFont(this.getFont().deriveFont(12.0f));
            Graphics g = this.getGraphics();
            if (g != null) {
                FontMetrics fm = g.getFontMetrics();
                w = (this.showicon ? 20 : 3) + fm.stringWidth(this.FriendlyAgename) + 3;
            } else {
                w = 40;
            }
            int h = 16;
            Dimension result = new Dimension(w, h);
            return result;
        }
    }

    public static class AgeListItemInfo {
        String agename;
        String FriendlyAgename;
        Uam.InstallStatus status;

        public AgeListItemInfo(String friendlyAgename, Uam.InstallStatus status, String agename) {
            this.agename = agename;
            this.status = status;
            this.FriendlyAgename = friendlyAgename;
        }

        public String toString() {
            return this.FriendlyAgename;
        }

        public int hashCode() {
            return this.FriendlyAgename.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AgeListItemInfo)) {
                return false;
            }
            AgeListItemInfo o2 = (AgeListItemInfo)obj;
            if (!this.agename.equals(o2.agename)) {
                return false;
            }
            return this.FriendlyAgename.equals(o2.FriendlyAgename);
        }
    }
}

