/*
 * Decompiled with CFR 0.152.
 */
package mystProxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mystProxy.ICustomSite;
import mystProxy.fileHandler;
import shared.m;

public class packageInfo {
    String name;
    boolean isZip;
    Vector<String> domainsHandled;
    Vector<String> startPages;
    ICustomSite customSiteHandler = null;

    public packageInfo(File file, boolean isZip) {
        this.name = file.getName();
        this.isZip = isZip;
        this.domainsHandled = new Vector();
        this.startPages = new Vector();
        Properties props = new Properties();
        if (!isZip) {
            try {
                File configfile = fileHandler.findFileCaseInsensitive(file, "/DrizzleServer.txt");
                props.load(new FileInputStream(configfile));
            }
            catch (Exception e2) {
                m.err("Unable to find/read DrizzleServer.txt in dir:", file.getPath());
            }
        } else {
            try {
                ZipFile zip2 = new ZipFile(new File(file.getPath()), 1);
                ZipEntry entry = fileHandler.findEntryCaseInsensitive(zip2, "DrizzleServer.txt");
                InputStream instream = zip2.getInputStream(entry);
                props.load(instream);
            }
            catch (Exception e3) {
                m.err("Unable to find/read DrizzleServer.txt in zip:", file.getPath());
            }
        }
        for (Map.Entry<Object, Object> e4 : props.entrySet()) {
            String key = ((String)e4.getKey()).toLowerCase();
            String value = (String)e4.getValue();
            if (key.startsWith("domain")) {
                this.domainsHandled.add(value);
                continue;
            }
            if (key.startsWith("start")) {
                this.startPages.add(value);
                continue;
            }
            if (!key.equals("customclass")) continue;
            try {
                ICustomSite customSite;
                String classname = value;
                Class<?> customclass = Class.forName("mystProxy." + value);
                Object obj = customclass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.customSiteHandler = customSite = (ICustomSite)obj;
            }
            catch (Exception e2) {
                m.warn("Unable to load custom site handler for site: ", this.name);
            }
        }
    }

    public boolean handlesDomain(String domain) {
        for (String s : this.domainsHandled) {
            if (!domain.toLowerCase().equals(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

