/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import shared.b;
import shared.m;

public class Mfs {
    int format;
    Vector<MfsEntry> base = new Vector();
    Vector<MfsEntry> pages = new Vector();
    Vector<MfsEntry> other = new Vector();
    private static SimpleDateFormat dateformatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss");

    public static Mfs readFromString(String data) {
        Mfs result = new Mfs();
        String[] lines = data.split("\n");
        BlockType currentBlock = BlockType.none;
        for (String line : lines) {
            if ((line = line.trim()).equals("")) continue;
            if (line.equals("[version]")) {
                currentBlock = BlockType.version;
                continue;
            }
            if (line.equals("[base]")) {
                currentBlock = BlockType.base;
                continue;
            }
            if (line.equals("[pages]")) {
                currentBlock = BlockType.pages;
                continue;
            }
            if (line.equals("[other]")) {
                currentBlock = BlockType.other;
                continue;
            }
            if (currentBlock == BlockType.version) {
                if (line.startsWith("format=")) {
                    result.format = Integer.parseInt(line.substring("format=".length()));
                    continue;
                }
                m.warn("Unhandled line in mfs file: ", line);
                continue;
            }
            if (currentBlock == BlockType.base) {
                result.base.add(new MfsEntry(line));
                continue;
            }
            if (currentBlock == BlockType.pages) {
                result.pages.add(new MfsEntry(line));
                continue;
            }
            if (currentBlock == BlockType.other) {
                result.other.add(new MfsEntry(line));
                continue;
            }
            m.warn("Unhandled line in mfs file: ", line);
        }
        return result;
    }

    public static class MfsEntry {
        String filename;
        int filesize;
        Date moddate;
        byte[] md5;
        int flag;
        int compressedSize;

        public MfsEntry(String line) {
            String[] parts = line.split(",");
            this.filename = parts[0];
            this.filesize = Integer.parseInt(parts[1]);
            try {
                this.moddate = dateformatter.parse(parts[2]);
            }
            catch (Exception e2) {
                m.err("Unable to parse date in Manifest file.");
            }
            this.md5 = b.HexStringToBytes(parts[3]);
            this.flag = Integer.parseInt(parts[4]);
            if (this.flag == 8) {
                this.compressedSize = Integer.parseInt(parts[5]);
            }
        }

        public String generateLine() {
            StringBuilder s = new StringBuilder();
            s.append(this.filename);
            s.append(",");
            s.append(Integer.toString(this.filesize));
            s.append(",");
            s.append(dateformatter.format(this.moddate));
            s.append(",");
            s.append(b.BytesToHexString(this.md5));
            s.append(",");
            s.append(Integer.toString(this.flag));
            if (this.flag == 8) {
                s.append(",");
                s.append(Integer.toString(this.compressedSize));
            }
            return s.toString();
        }
    }

    public static enum BlockType {
        version,
        base,
        pages,
        other,
        none;

    }
}

