/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.io.XmlStreamParsingException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.XmlUtils;

public class OsmReader
extends AbstractReader {
    protected XMLStreamReader parser;
    protected final Collection<Options> options;
    private static final Set<String> COMMON_XML_ATTRIBUTES = new TreeSet<String>();

    protected OsmReader() {
        this(new Options[]{null});
    }

    protected OsmReader(Options ... options) {
        this.options = options == null ? Collections.emptyList() : Arrays.asList(options);
    }

    protected void setParser(XMLStreamReader parser) {
        this.parser = parser;
    }

    protected void throwException(Throwable th) throws XMLStreamException {
        throw new XmlStreamParsingException(th.getMessage(), this.parser.getLocation(), th);
    }

    protected void throwException(String msg, Throwable th) throws XMLStreamException {
        throw new XmlStreamParsingException(msg, this.parser.getLocation(), th);
    }

    protected void throwException(String msg) throws XMLStreamException {
        throw new XmlStreamParsingException(msg, this.parser.getLocation());
    }

    protected void parse() throws XMLStreamException {
        int event = this.parser.getEventType();
        while (true) {
            if (event == 1) {
                this.parseRoot();
            } else if (event == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            event = this.parser.next();
        }
        this.parser.close();
    }

    protected void parseRoot() throws XMLStreamException {
        if ("osm".equals(this.parser.getLocalName())) {
            this.parseOsm();
        } else {
            this.parseUnknown();
        }
    }

    private void parseOsm() throws XMLStreamException {
        try {
            this.parseVersion(this.parser.getAttributeValue(null, "version"));
            this.parseDownloadPolicy("download", this.parser.getAttributeValue(null, "download"));
            this.parseUploadPolicy("upload", this.parser.getAttributeValue(null, "upload"));
            this.parseLocked(this.parser.getAttributeValue(null, "locked"));
        }
        catch (IllegalDataException e) {
            this.throwException(e);
        }
        String generator = this.parser.getAttributeValue(null, "generator");
        Long uploadChangesetId = null;
        if (this.parser.getAttributeValue(null, "upload-changeset") != null) {
            uploadChangesetId = this.getLong("upload-changeset");
        }
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (this.cancel) {
                this.cancel = false;
                throw new OsmParsingCanceledException(I18n.tr("Reading was canceled", new Object[0]), this.parser.getLocation());
            }
            if (event == 1) {
                switch (this.parser.getLocalName()) {
                    case "bounds": {
                        this.parseBounds(generator);
                        break;
                    }
                    case "node": {
                        this.parseNode();
                        break;
                    }
                    case "way": {
                        this.parseWay();
                        break;
                    }
                    case "relation": {
                        this.parseRelation();
                        break;
                    }
                    case "changeset": {
                        this.parseChangeset(uploadChangesetId);
                        break;
                    }
                    case "remark": {
                        this.parseRemark();
                        break;
                    }
                    default: {
                        this.parseUnknown();
                        break;
                    }
                }
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    private void handleIllegalDataException(IllegalDataException e) throws XMLStreamException {
        Throwable cause = e.getCause();
        if (cause instanceof XMLStreamException) {
            throw (XMLStreamException)cause;
        }
        this.throwException(e);
    }

    private void parseRemark() throws XMLStreamException {
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 4) {
                this.ds.setRemark(this.parser.getText());
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    private void parseBounds(String generator) throws XMLStreamException {
        String minlon = this.parser.getAttributeValue(null, "minlon");
        String minlat = this.parser.getAttributeValue(null, "minlat");
        String maxlon = this.parser.getAttributeValue(null, "maxlon");
        String maxlat = this.parser.getAttributeValue(null, "maxlat");
        String origin = this.parser.getAttributeValue(null, "origin");
        try {
            this.parseBounds(generator, minlon, minlat, maxlon, maxlat, origin);
        }
        catch (IllegalDataException e) {
            this.handleIllegalDataException(e);
        }
        this.jumpToEnd();
    }

    protected Node parseNode() throws XMLStreamException {
        String lat = this.parser.getAttributeValue(null, "lat");
        String lon = this.parser.getAttributeValue(null, "lon");
        try {
            return this.parseNode(lat, lon, this::readCommon, this::parseNodeTags);
        }
        catch (IllegalDataException e) {
            this.handleIllegalDataException(e);
            return null;
        }
    }

    private void parseNodeTags(Node n) throws IllegalDataException {
        try {
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                if (event == 1) {
                    if ("tag".equals(this.parser.getLocalName())) {
                        this.parseTag(n);
                        continue;
                    }
                    this.parseUnknown();
                    continue;
                }
                if (event != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalDataException(e);
        }
    }

    protected Way parseWay() throws XMLStreamException {
        try {
            return this.parseWay(this::readCommon, this::parseWayNodesAndTags);
        }
        catch (IllegalDataException e) {
            this.handleIllegalDataException(e);
            return null;
        }
    }

    private void parseWayNodesAndTags(Way w, Collection<Long> nodeIds) throws IllegalDataException {
        try {
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                if (event == 1) {
                    switch (this.parser.getLocalName()) {
                        case "nd": {
                            nodeIds.add(this.parseWayNode(w));
                            break;
                        }
                        case "tag": {
                            this.parseTag(w);
                            break;
                        }
                        default: {
                            this.parseUnknown();
                            break;
                        }
                    }
                    continue;
                }
                if (event != 2) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalDataException(e);
        }
    }

    private long parseWayNode(Way w) throws XMLStreamException {
        long id;
        if (this.parser.getAttributeValue(null, "ref") == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", Long.toString(w.getUniqueId())));
        }
        if ((id = this.getLong("ref")) == 0L) {
            this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", Long.toString(id)));
        }
        this.jumpToEnd();
        return id;
    }

    protected Relation parseRelation() throws XMLStreamException {
        try {
            return this.parseRelation(this::readCommon, this::parseRelationMembersAndTags);
        }
        catch (IllegalDataException e) {
            this.handleIllegalDataException(e);
            return null;
        }
    }

    private void parseRelationMembersAndTags(Relation r, Collection<RelationMemberData> members) throws IllegalDataException {
        try {
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                if (event == 1) {
                    switch (this.parser.getLocalName()) {
                        case "member": {
                            members.add(this.parseRelationMember(r));
                            break;
                        }
                        case "tag": {
                            this.parseTag(r);
                            break;
                        }
                        default: {
                            this.parseUnknown();
                            break;
                        }
                    }
                    continue;
                }
                if (event != 2) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalDataException(e);
        }
    }

    private RelationMemberData parseRelationMember(Relation r) throws XMLStreamException {
        RelationMemberData result = null;
        try {
            String ref = this.parser.getAttributeValue(null, "ref");
            String type = this.parser.getAttributeValue(null, "type");
            String role = this.parser.getAttributeValue(null, "role");
            result = this.parseRelationMember(r, ref, type, role);
            this.jumpToEnd();
        }
        catch (IllegalDataException e) {
            this.handleIllegalDataException(e);
        }
        return result;
    }

    private void parseChangeset(Long uploadChangesetId) throws XMLStreamException {
        Long id = null;
        if (this.parser.getAttributeValue(null, "id") != null) {
            id = this.getLong("id");
        }
        if (Objects.equals(id, uploadChangesetId)) {
            this.uploadChangeset = new Changeset(id != null ? id.intValue() : 0);
            while (true) {
                int event;
                if ((event = this.parser.next()) == 1) {
                    if ("tag".equals(this.parser.getLocalName())) {
                        this.parseTag(this.uploadChangeset);
                        continue;
                    }
                    this.parseUnknown();
                    continue;
                }
                if (event == 2) break;
            }
            return;
        }
        this.jumpToEnd(false);
    }

    private void parseTag(Tagged t) throws XMLStreamException {
        String key = this.parser.getAttributeValue(null, "k");
        String value = this.parser.getAttributeValue(null, "v");
        try {
            this.parseTag(t, key, value);
        }
        catch (IllegalDataException e) {
            this.throwException(e);
        }
        this.jumpToEnd();
    }

    protected void parseUnknown(boolean printWarning) throws XMLStreamException {
        String element = this.parser.getLocalName();
        if (printWarning && ("note".equals(element) || "meta".equals(element))) {
            Logging.debug(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", element));
        } else if (printWarning) {
            Logging.info(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", element));
        }
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.parseUnknown(false);
                continue;
            }
            if (event == 2) break;
        }
    }

    protected void parseUnknown() throws XMLStreamException {
        this.parseUnknown(true);
    }

    protected final void jumpToEnd(boolean printWarning) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.parseUnknown(printWarning);
                continue;
            }
            if (event == 2) break;
        }
    }

    protected final void jumpToEnd() throws XMLStreamException {
        this.jumpToEnd(true);
    }

    private void readCommon(PrimitiveData current) throws IllegalDataException {
        try {
            this.parseId(current, this.getLong("id"));
            this.parseTimestamp(current, this.parser.getAttributeValue(null, "timestamp"));
            this.parseUser(current, this.parser.getAttributeValue(null, "user"), this.parser.getAttributeValue(null, "uid"));
            this.parseVisible(current, this.parser.getAttributeValue(null, "visible"));
            this.parseVersion(current, this.parser.getAttributeValue(null, "version"));
            this.parseAction(current, this.parser.getAttributeValue(null, "action"));
            this.parseChangeset(current, this.parser.getAttributeValue(null, "changeset"));
            if (this.options.contains((Object)Options.SAVE_ORIGINAL_ID)) {
                this.parseTag(current, "current_id", Long.toString(this.getLong("id")));
            }
            if (this.options.contains((Object)Options.CONVERT_UNKNOWN_TO_TAGS)) {
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    if (COMMON_XML_ATTRIBUTES.contains(this.parser.getAttributeLocalName(i))) continue;
                    this.parseTag(current, this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i));
                }
            }
        }
        catch (XMLStreamException | UncheckedParseException e) {
            throw new IllegalDataException(e);
        }
    }

    private long getLong(String name) throws XMLStreamException {
        String value = this.parser.getAttributeValue(null, name);
        try {
            return this.getLong(name, value);
        }
        catch (IllegalDataException e) {
            this.throwException(e);
            return 0L;
        }
    }

    @Override
    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return this.doParseDataSet(source, progressMonitor, ir -> {
            try {
                this.setParser(XmlUtils.newSafeXMLInputFactory().createXMLStreamReader(ir));
                this.parse();
            }
            catch (XmlStreamParsingException | UncheckedParseException e) {
                throw new IllegalDataException(e.getMessage(), e);
            }
            catch (XMLStreamException e) {
                String msg = e.getMessage();
                Pattern p = Pattern.compile("Message: (.+)");
                Matcher m = p.matcher(msg);
                if (m.find()) {
                    msg = m.group(1);
                }
                if (e.getLocation() != null) {
                    throw new IllegalDataException(I18n.tr("Line {0} column {1}: ", e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()) + msg, e);
                }
                throw new IllegalDataException(msg, e);
            }
        });
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(source, progressMonitor, new Options[]{null});
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor, Options ... options) throws IllegalDataException {
        return new OsmReader(options).doParseDataSet(source, progressMonitor);
    }

    static {
        COMMON_XML_ATTRIBUTES.add("id");
        COMMON_XML_ATTRIBUTES.add("timestamp");
        COMMON_XML_ATTRIBUTES.add("user");
        COMMON_XML_ATTRIBUTES.add("uid");
        COMMON_XML_ATTRIBUTES.add("visible");
        COMMON_XML_ATTRIBUTES.add("version");
        COMMON_XML_ATTRIBUTES.add("action");
        COMMON_XML_ATTRIBUTES.add("changeset");
        COMMON_XML_ATTRIBUTES.add("lat");
        COMMON_XML_ATTRIBUTES.add("lon");
    }

    public static enum Options {
        CONVERT_UNKNOWN_TO_TAGS,
        SAVE_ORIGINAL_ID;

    }

    private static final class OsmParsingCanceledException
    extends XmlStreamParsingException
    implements ImportCancelException {
        OsmParsingCanceledException(String msg, Location location) {
            super(msg, location);
        }
    }
}

