/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class UnconnectedWays
extends Test {
    private final int code;
    private final boolean isHighwayTest;
    static final double DETOUR_FACTOR = 4.0;
    protected static final int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    private List<MyWaySegment> waySegments;
    private Set<Node> endnodes;
    private Set<Node> middlenodes;
    private Set<Node> othernodes;
    private QuadBuckets<Node> searchNodes;
    private Set<Way> waysToTest;
    private Set<Node> nodesToTest;
    private Area dsArea;
    private double mindist;
    private double minmiddledist;
    private double maxLen;
    private DataSet ds;

    protected abstract boolean isCandidate(OsmPrimitive var1);

    protected boolean isWantedWay(Way w) {
        return w.isUsable() && this.isCandidate(w);
    }

    protected boolean ignoreUnconnectedEndNode(Node n) {
        return false;
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return super.isPrimitiveUsable(p) && (this.partialSelection && p instanceof Node || this.isCandidate(p));
    }

    protected UnconnectedWays(String title) {
        this(title, 1301, false);
    }

    protected UnconnectedWays(String title, int code, boolean isHighwayTest) {
        super(title, I18n.tr("This test checks if a way has an endpoint very near to another way.", new Object[0]));
        this.code = code;
        this.isHighwayTest = isHighwayTest;
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.waySegments = new ArrayList<MyWaySegment>();
        this.searchNodes = new QuadBuckets();
        this.waysToTest = new HashSet<Way>();
        this.nodesToTest = new HashSet<Node>();
        this.endnodes = new HashSet<Node>();
        this.middlenodes = new HashSet<Node>();
        this.othernodes = new HashSet<Node>();
        this.mindist = Config.getPref().getDouble(PREFIX + ".node_way_distance", 10.0);
        if (this instanceof UnconnectedRailways) {
            this.mindist = Config.getPref().getDouble(PREFIX + ".node_way_distance_railway", 1.0);
        }
        this.minmiddledist = Config.getPref().getDouble(PREFIX + ".way_way_distance", 0.0);
        this.ds = OsmDataManager.getInstance().getActiveDataSet();
        this.dsArea = this.ds == null ? null : this.ds.getDataSourceArea();
    }

    protected Map<Node, MyWaySegment> getHighwayEndNodesNearOtherHighway() {
        HashMap<Node, MyWaySegment> map = new HashMap<Node, MyWaySegment>();
        for (MyWaySegment s : this.waySegments) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            if (s.w.hasTag("highway", "platform")) continue;
            for (Node endnode : s.nearbyNodes(this.mindist)) {
                Way parentWay = this.getWantedParentWay(endnode);
                if (parentWay == null || parentWay.hasTag("highway", "platform") || !Objects.equals(OsmUtils.getLayer(s.w), OsmUtils.getLayer(parentWay)) || s.isConnectedTo(endnode) || s.obstacleBetween(endnode)) continue;
                this.addIfNewOrCloser(map, endnode, s);
            }
        }
        return map;
    }

    protected Map<Node, MyWaySegment> getWayEndNodesNearOtherWay() {
        HashMap<Node, MyWaySegment> map = new HashMap<Node, MyWaySegment>();
        for (MyWaySegment s : this.waySegments) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            if (s.concernsArea) continue;
            for (Node endnode : s.nearbyNodes(this.mindist)) {
                if (s.isConnectedTo(endnode)) continue;
                if (s.w.hasTag("power")) {
                    boolean badConnection = false;
                    Way otherWay = this.getWantedParentWay(endnode);
                    if (otherWay != null) {
                        for (String key : Arrays.asList("voltage", "frequency")) {
                            String v1 = s.w.get(key);
                            String v2 = otherWay.get(key);
                            if (v1 == null || v2 == null || v1.equals(v2)) continue;
                            badConnection = true;
                        }
                    }
                    if (badConnection) continue;
                }
                this.addIfNewOrCloser(map, endnode, s);
            }
        }
        return map;
    }

    protected Map<Node, MyWaySegment> getWayNodesNearOtherWay() {
        HashMap<Node, MyWaySegment> map = new HashMap<Node, MyWaySegment>();
        for (MyWaySegment s : this.waySegments) {
            if (this.isCanceled()) {
                map.clear();
                return map;
            }
            for (Node en : s.nearbyNodes(this.minmiddledist)) {
                if (s.isConnectedTo(en)) continue;
                this.addIfNewOrCloser(map, en, s);
            }
        }
        return map;
    }

    protected Way getWantedParentWay(Node endnode) {
        for (Way w : endnode.getParentWays()) {
            if (!this.isWantedWay(w)) continue;
            return w;
        }
        Logging.error("end node without matching parent way");
        return null;
    }

    private void addIfNewOrCloser(Map<Node, MyWaySegment> map, Node node, MyWaySegment ws) {
        double d2;
        double d1;
        if (this.partialSelection && !this.nodesToTest.contains(node) && !this.waysToTest.contains(ws.w)) {
            return;
        }
        MyWaySegment old = map.get(node);
        if (old != null && (d1 = ws.getDist(node)) > (d2 = old.getDist(node))) {
            return;
        }
        map.put(node, ws);
    }

    protected final void addErrors(Severity severity, Map<Node, MyWaySegment> errorMap, String message) {
        for (Map.Entry<Node, MyWaySegment> error : errorMap.entrySet()) {
            Node node = error.getKey();
            MyWaySegment ws = error.getValue();
            this.errors.add(TestError.builder(this, severity, this.code).message(message).primitives(node, ws.w).highlight(node).build());
        }
    }

    @Override
    public void endTest() {
        if (this.ds == null) {
            return;
        }
        for (Way w : this.ds.getWays()) {
            if (!this.isWantedWay(w) || w.getRealNodesCount() <= 1) continue;
            this.waySegments.addAll(this.getWaySegments(w));
            this.addNode(w.firstNode(), this.endnodes);
            this.addNode(w.lastNode(), this.endnodes);
        }
        this.fillSearchNodes(this.endnodes);
        if (!this.searchNodes.isEmpty()) {
            this.maxLen = 4.0 * this.mindist;
            if (this.isHighwayTest) {
                this.addErrors(Severity.WARNING, this.getHighwayEndNodesNearOtherHighway(), I18n.tr("Way end node near other highway", new Object[0]));
            } else {
                this.addErrors(Severity.WARNING, this.getWayEndNodesNearOtherWay(), I18n.tr("Way end node near other way", new Object[0]));
            }
        }
        boolean includeOther = this.isBeforeUpload ? ValidatorPrefHelper.PREF_OTHER_UPLOAD.get() : ValidatorPrefHelper.PREF_OTHER.get();
        if (this.minmiddledist > 0.0 && includeOther) {
            this.maxLen = 4.0 * this.minmiddledist;
            this.fillSearchNodes(this.middlenodes);
            this.addErrors(Severity.OTHER, this.getWayNodesNearOtherWay(), I18n.tr("Way node near other way", new Object[0]));
            this.fillSearchNodes(this.othernodes);
            this.addErrors(Severity.OTHER, this.getWayNodesNearOtherWay(), I18n.tr("Connected way end node near other way", new Object[0]));
        }
        this.waySegments = null;
        this.endnodes = null;
        this.middlenodes = null;
        this.othernodes = null;
        this.searchNodes = null;
        this.waysToTest = null;
        this.nodesToTest = null;
        this.dsArea = null;
        this.ds = null;
        super.endTest();
    }

    private void fillSearchNodes(Collection<Node> nodes) {
        this.searchNodes.clear();
        for (Node n : nodes) {
            if (this.ignoreUnconnectedEndNode(n) || !n.getCoor().isIn(this.dsArea)) continue;
            this.searchNodes.add(n);
        }
    }

    List<MyWaySegment> getWaySegments(Way w) {
        ArrayList<MyWaySegment> ret = new ArrayList<MyWaySegment>();
        if (!w.isUsable() || w.isKeyTrue("disused")) {
            return ret;
        }
        int size = w.getNodesCount();
        boolean concersArea = w.concernsArea();
        for (int i = 1; i < size; ++i) {
            if (i < size - 1) {
                this.addNode(w.getNode(i), this.middlenodes);
            }
            Node a = w.getNode(i - 1);
            Node b = w.getNode(i);
            if (!a.isLatLonKnown() || !b.isLatLonKnown()) continue;
            MyWaySegment ws = new MyWaySegment(w, a, b, concersArea);
            ret.add(ws);
        }
        return ret;
    }

    @Override
    public void visit(Way w) {
        if (this.partialSelection) {
            this.waysToTest.add(w);
        }
    }

    @Override
    public void visit(Node n) {
        if (this.partialSelection) {
            this.nodesToTest.add(n);
        }
    }

    private void addNode(Node n, Set<Node> s) {
        boolean m = this.middlenodes.contains(n);
        boolean e = this.endnodes.contains(n);
        boolean o = this.othernodes.contains(n);
        if (!(m || e || o)) {
            s.add(n);
        } else if (!o) {
            this.othernodes.add(n);
            if (e) {
                this.endnodes.remove(n);
            } else {
                this.middlenodes.remove(n);
            }
        }
    }

    public static class UnconnectedRailways
    extends UnconnectedWays {
        static final int UNCONNECTED_RAILWAYS = 1321;

        public UnconnectedRailways() {
            super(I18n.tr("Unconnected railways", new Object[0]), 1321, false);
        }

        @Override
        protected boolean isCandidate(OsmPrimitive p) {
            if (p.hasTag("railway", "construction") && p.hasKey("construction")) {
                return p.hasTagDifferent("construction", "platform", "platform_edge", "service_station", "station");
            }
            return p.hasTagDifferent("railway", "proposed", "planned", "abandoned", "razed", "disused", "no", "platform", "platform_edge", "service_station", "station");
        }

        @Override
        protected boolean ignoreUnconnectedEndNode(Node n) {
            if (n.hasTag("railway", "buffer_stop") || n.isKeyTrue("noexit")) {
                return true;
            }
            Way parent = this.getWantedParentWay(n);
            if (parent != null && parent.getNodesCount() > 1) {
                Node next = null;
                if (n == parent.firstNode()) {
                    next = parent.getNode(1);
                } else if (n == parent.lastNode()) {
                    next = parent.getNode(parent.getNodesCount() - 2);
                }
                if (next != null) {
                    return next.hasTag("railway", "buffer_stop");
                }
            }
            return false;
        }
    }

    private class MyWaySegment {
        public final Way w;
        private final Node n1;
        private final Node n2;
        private final boolean concernsArea;

        MyWaySegment(Way w, Node n1, Node n2, boolean concersArea) {
            this.w = w;
            this.n1 = n1;
            this.n2 = n2;
            this.concernsArea = concersArea;
        }

        boolean isConnectedTo(Node startNode) {
            return this.isConnectedTo(startNode, new LinkedHashSet<Node>(), 0.0, this.w);
        }

        private boolean isConnectedTo(Node node, LinkedHashSet<Node> visited, double len, Way parent) {
            if (len > UnconnectedWays.this.maxLen) {
                return false;
            }
            if (this.n1 == node || this.n2 == node) {
                Node uncon = (Node)visited.iterator().next();
                LatLon cl = ProjectionRegistry.getProjection().eastNorth2latlon(this.calcClosest(uncon));
                double detourLen = len + node.greatCircleDistance(cl);
                if (detourLen > UnconnectedWays.this.maxLen) {
                    return false;
                }
                double directDist = this.getDist(uncon);
                if (directDist <= 0.1) {
                    return false;
                }
                return directDist > 0.5 || visited.size() == 2 && directDist * 1.5 > detourLen;
            }
            if (visited != null) {
                visited.add(node);
                List wantedParents = node.getParentWays().stream().filter(pw -> UnconnectedWays.this.isWantedWay((Way)pw)).collect(Collectors.toList());
                if (wantedParents.size() > 1 && wantedParents.indexOf(parent) != wantedParents.size() - 1) {
                    wantedParents.remove(parent);
                    wantedParents.add(parent);
                }
                for (Way way : wantedParents) {
                    ArrayList<Node> nextNodes = new ArrayList<Node>();
                    int pos = way.getNodes().indexOf(node);
                    if (pos > 0) {
                        nextNodes.add(way.getNode(pos - 1));
                    }
                    if (pos + 1 < way.getNodesCount()) {
                        nextNodes.add(way.getNode(pos + 1));
                    }
                    for (Node next : nextNodes) {
                        boolean containsN = visited.contains(next);
                        visited.add(next);
                        if (containsN || !this.isConnectedTo(next, visited, len + node.greatCircleDistance(next), way)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private EastNorth calcClosest(Node n) {
            return Geometry.closestPointToSegment(this.n1.getEastNorth(), this.n2.getEastNorth(), n.getEastNorth());
        }

        double getDist(Node n) {
            EastNorth closest = this.calcClosest(n);
            return n.greatCircleDistance(ProjectionRegistry.getProjection().eastNorth2latlon(closest));
        }

        private boolean nearby(Node n, double dist) {
            if (this.w.containsNode(n)) {
                return false;
            }
            double d = this.getDist(n);
            return !Double.isNaN(d) && d < dist;
        }

        private BBox getBounds(double fudge) {
            double y2;
            double y1;
            double x2;
            double x1 = this.n1.lon();
            if (x1 > (x2 = this.n2.lon())) {
                double tmpx = x1;
                x1 = x2;
                x2 = tmpx;
            }
            if ((y1 = this.n1.lat()) > (y2 = this.n2.lat())) {
                double tmpy = y1;
                y1 = y2;
                y2 = tmpy;
            }
            LatLon topLeft = new LatLon(y2 + fudge, x1 - fudge);
            LatLon botRight = new LatLon(y1 - fudge, x2 + fudge);
            return new BBox(topLeft, botRight);
        }

        Collection<Node> nearbyNodes(double dist) {
            BBox bounds = this.getBounds(dist * (360.0 / (Ellipsoid.WGS84.a * 2.0 * Math.PI)));
            ArrayList<Node> result = null;
            List foundNodes = UnconnectedWays.this.searchNodes.search(bounds);
            for (Node n : foundNodes) {
                if (!this.nearby(n, dist)) continue;
                if (result == null) {
                    result = new ArrayList<Node>();
                }
                result.add(n);
            }
            return result == null ? Collections.emptyList() : result;
        }

        private boolean obstacleBetween(Node endnode) {
            EastNorth en = endnode.getEastNorth();
            EastNorth closest = this.calcClosest(endnode);
            LatLon llClosest = ProjectionRegistry.getProjection().eastNorth2latlon(closest);
            BBox bbox = new BBox(endnode.getCoor(), llClosest);
            for (Way nearbyWay : UnconnectedWays.this.ds.searchWays(bbox)) {
                if (nearbyWay == this.w || !nearbyWay.isUsable() || !this.isObstacle(nearbyWay) || endnode.getParentWays().contains(nearbyWay)) continue;
                Iterator<Node> iter = nearbyWay.getNodes().iterator();
                EastNorth prev = iter.next().getEastNorth();
                while (iter.hasNext()) {
                    EastNorth curr = iter.next().getEastNorth();
                    if (Geometry.getSegmentSegmentIntersection(closest, en, prev, curr) != null) {
                        return true;
                    }
                    prev = curr;
                }
            }
            return false;
        }

        private boolean isObstacle(Way w) {
            return w.hasKey("barrier", "waterway") || UnconnectedWays.isBuilding(w) || w.hasTag("man_made", "embankment", "dyke");
        }
    }

    public static class UnconnectedPower
    extends UnconnectedWays {
        static final int UNCONNECTED_POWER = 1351;

        public UnconnectedPower() {
            super(I18n.tr("Unconnected power ways", new Object[0]), 1351, false);
        }

        @Override
        protected boolean isCandidate(OsmPrimitive p) {
            return p.hasTag("power", "line", "minor_line", "cable");
        }

        @Override
        protected boolean ignoreUnconnectedEndNode(Node n) {
            return n.hasTag("power", "terminal") || n.hasTag("location:transition", "yes");
        }
    }

    public static class UnconnectedNaturalOrLanduse
    extends UnconnectedWays {
        static final int UNCONNECTED_NATURAL_OR_LANDUSE = 1341;

        public UnconnectedNaturalOrLanduse() {
            super(I18n.tr("Unconnected natural lands and landuses", new Object[0]), 1341, false);
        }

        @Override
        protected boolean isCandidate(OsmPrimitive p) {
            return p.hasKey("landuse") || p.hasTagDifferent("natural", "tree_row", "cliff");
        }
    }

    public static class UnconnectedWaterways
    extends UnconnectedWays {
        static final int UNCONNECTED_WATERWAYS = 1331;

        public UnconnectedWaterways() {
            super(I18n.tr("Unconnected waterways", new Object[0]), 1331, false);
        }

        @Override
        protected boolean isCandidate(OsmPrimitive p) {
            return p.hasTagDifferent("waterway", "dam", "lock_gate", "weir");
        }
    }

    public static class UnconnectedHighways
    extends UnconnectedWays {
        static final int UNCONNECTED_HIGHWAYS = 1311;

        public UnconnectedHighways() {
            super(I18n.tr("Unconnected highways", new Object[0]), 1311, true);
        }

        @Override
        protected boolean isCandidate(OsmPrimitive p) {
            return p.hasKey("highway");
        }

        @Override
        protected boolean ignoreUnconnectedEndNode(Node n) {
            return n.hasTag("highway", "turning_circle", "bus_stop", "elevator") || n.hasTag("amenity", "parking_entrance", "ferry_terminal") || n.isKeyTrue("noexit") || n.hasKey("entrance", "barrier") || n.getParentWays().stream().anyMatch(p -> UnconnectedHighways.isBuilding(p) || p.hasTag("railway", "platform", "platform_edge"));
        }
    }
}

