/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoveryManager {
    private static final Log log = LogFactory.getLog(UDPDiscoveryManager.class);
    private static UDPDiscoveryManager INSTANCE = new UDPDiscoveryManager();
    private final Map<String, UDPDiscoveryService> services = new HashMap<String, UDPDiscoveryService>();

    private UDPDiscoveryManager() {
    }

    public static UDPDiscoveryManager getInstance() {
        return INSTANCE;
    }

    public synchronized UDPDiscoveryService getService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr) {
        String key = discoveryAddress + ":" + discoveryPort + ":" + servicePort;
        UDPDiscoveryService service = this.services.get(key);
        if (service == null) {
            if (log.isInfoEnabled()) {
                log.info("Creating service for address:port:servicePort [" + key + "]");
            }
            UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
            attributes.setUdpDiscoveryAddr(discoveryAddress);
            attributes.setUdpDiscoveryPort(discoveryPort);
            attributes.setServicePort(servicePort);
            service = new UDPDiscoveryService(attributes);
            cacheMgr.registerShutdownObserver(service);
            if (cacheMgr instanceof IProvideScheduler) {
                service.setScheduledExecutorService(((IProvideScheduler)((Object)cacheMgr)).getScheduledExecutorService());
            }
            service.startup();
            this.services.put(key, service);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning service [" + service + "] for key [" + key + "]");
        }
        return service;
    }
}

