/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class Relation
extends OsmPrimitive
implements IRelation<RelationMember> {
    static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private RelationMember[] members = new RelationMember[0];
    private BBox bbox;

    @Override
    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMembers(List<RelationMember> members) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            for (RelationMember rm : this.members) {
                rm.getMember().removeReferrer(this);
                rm.getMember().clearCachedStyle();
            }
            this.members = members != null ? members.toArray(new RelationMember[0]) : new RelationMember[0];
            for (RelationMember rm : this.members) {
                rm.getMember().addReferrer(this);
                rm.getMember().clearCachedStyle();
            }
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public int getMembersCount() {
        return this.members.length;
    }

    @Override
    public RelationMember getMember(int index) {
        return this.members[index];
    }

    public void addMember(RelationMember member) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            this.members = Utils.addInArrayCopy(this.members, member);
            member.getMember().addReferrer(this);
            member.getMember().clearCachedStyle();
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(int index, RelationMember member) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            RelationMember[] newMembers = new RelationMember[this.members.length + 1];
            System.arraycopy(this.members, 0, newMembers, 0, index);
            System.arraycopy(this.members, index, newMembers, index + 1, this.members.length - index);
            newMembers[index] = member;
            this.members = newMembers;
            member.getMember().addReferrer(this);
            member.getMember().clearCachedStyle();
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember setMember(int index, RelationMember member) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            RelationMember originalMember = this.members[index];
            this.members[index] = member;
            if (originalMember.getMember() != member.getMember()) {
                member.getMember().addReferrer(this);
                member.getMember().clearCachedStyle();
                originalMember.getMember().removeReferrer(this);
                originalMember.getMember().clearCachedStyle();
                this.fireMembersChanged();
            }
            RelationMember relationMember = originalMember;
            return relationMember;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember removeMember(int index) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            List<RelationMember> members = this.getMembers();
            RelationMember result = members.remove(index);
            this.setMembers(members);
            RelationMember relationMember = result;
            return relationMember;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public long getMemberId(int idx) {
        return this.members[idx].getUniqueId();
    }

    @Override
    public String getRole(int idx) {
        return this.members[idx].getRole();
    }

    @Override
    public OsmPrimitiveType getMemberType(int idx) {
        return this.members[idx].getType();
    }

    @Override
    public void accept(OsmPrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    protected Relation(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Relation() {
        super(0L, false);
    }

    public Relation(Relation clone, boolean clearMetadata, boolean copyMembers) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone, copyMembers);
        if (clearMetadata) {
            this.clearOsmMetadata();
        }
    }

    public Relation(Relation clone, boolean clearMetadata) {
        this(clone, clearMetadata, true);
    }

    public Relation(Relation clone) {
        this(clone, false);
    }

    public Relation(long id) {
        super(id, false);
    }

    public Relation(long id, int version) {
        super(id, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osm, boolean copyMembers) {
        if (!(osm instanceof Relation)) {
            throw new IllegalArgumentException("Not a relation: " + osm);
        }
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm, copyMembers);
            if (copyMembers) {
                this.setMembers(((Relation)osm).getMembers());
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData data) {
        if (!(data instanceof RelationData)) {
            throw new IllegalArgumentException("Not a relation data: " + data);
        }
        boolean locked = this.writeLock();
        try {
            super.load(data);
            RelationData relationData = (RelationData)data;
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
            for (RelationMemberData member : relationData.getMembers()) {
                newMembers.add(new RelationMember(member.getRole(), Optional.ofNullable(this.getDataSet().getPrimitiveById(member)).orElseThrow(() -> new AssertionError((Object)"Data consistency problem - relation with missing member detected"))));
            }
            this.setMembers((List<RelationMember>)newMembers);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public RelationData save() {
        RelationData data = new RelationData();
        this.saveCommonAttributes(data);
        for (RelationMember member : this.getMembers()) {
            data.getMembers().add(new RelationMemberData(member.getRole(), member.getMember()));
        }
        return data;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        result.append("{Relation id=").append(this.getUniqueId()).append(" version=").append(this.getVersion()).append(' ').append(this.getFlagsAsString()).append(" [");
        for (RelationMember rm : this.getMembers()) {
            result.append((Object)OsmPrimitiveType.from(rm.getMember())).append(' ').append(rm.getMember().getUniqueId()).append(", ");
        }
        result.delete(result.length() - 2, result.length()).append("]}");
        return result.toString();
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other, boolean testInterestingTagsOnly) {
        return other instanceof Relation && this.hasEqualSemanticFlags(other) && Arrays.equals(this.members, ((Relation)other).members) && super.hasEqualSemanticAttributes(other, testInterestingTagsOnly);
    }

    public RelationMember firstMember() {
        return this.isIncomplete() || this.members.length == 0 ? null : this.members[0];
    }

    public RelationMember lastMember() {
        return this.isIncomplete() || this.members.length == 0 ? null : this.members[this.members.length - 1];
    }

    public void removeMembersFor(OsmPrimitive primitive) {
        this.removeMembersFor(Collections.singleton(primitive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            for (RelationMember rm : this.members) {
                if (deleted) {
                    rm.getMember().removeReferrer(this);
                    continue;
                }
                rm.getMember().addReferrer(this);
            }
            super.setDeleted(deleted);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public Collection<RelationMember> getMembersFor(Collection<? extends OsmPrimitive> primitives) {
        return SubclassFilteredCollection.filter(this.getMembers(), member -> primitives.contains(member.getMember()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMembersFor(Collection<? extends OsmPrimitive> primitives) {
        this.checkDatasetNotReadOnly();
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            List<RelationMember> members = this.getMembers();
            members.removeAll(this.getMembersFor(primitives));
            this.setMembers(members);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        return this.getMembers().stream().map(RelationMember::getMember).collect(Collectors.toSet());
    }

    public <T extends OsmPrimitive> Collection<T> getMemberPrimitives(Class<T> tClass) {
        return Utils.filteredCollection(this.getMemberPrimitivesList(), tClass);
    }

    @Override
    public List<OsmPrimitive> getMemberPrimitivesList() {
        return Utils.transform(this.getMembers(), RelationMember::getMember);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.isMultipolygon() && !this.isBoundary() ? OsmPrimitiveType.MULTIPOLYGON : OsmPrimitiveType.RELATION;
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() != null && this.bbox != null) {
            return new BBox(this.bbox);
        }
        BBox box = new BBox();
        this.addToBBox(box, new HashSet<PrimitiveId>());
        if (this.getDataSet() != null) {
            this.setBBox(box);
        }
        return new BBox(box);
    }

    private void setBBox(BBox bbox) {
        this.bbox = bbox;
    }

    @Override
    protected void addToBBox(BBox box, Set<PrimitiveId> visited) {
        for (RelationMember rm : this.members) {
            if (!visited.add(rm.getMember())) continue;
            rm.getMember().addToBBox(box, visited);
        }
    }

    @Override
    public void updatePosition() {
        this.setBBox(null);
        this.setBBox(this.getBBox());
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkMembers();
        this.setBBox(null);
    }

    private void checkMembers() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            for (RelationMember rm : this.members) {
                if (rm.getMember().getDataSet() == dataSet) continue;
                throw new DataIntegrityProblemException(String.format("Relation member must be part of the same dataset as relation(%s, %s)", this.getPrimitiveId(), rm.getMember().getPrimitiveId()));
            }
            if (Config.getPref().getBoolean("debug.checkDeleteReferenced", true)) {
                for (RelationMember rm : this.members) {
                    if (!rm.getMember().isDeleted()) continue;
                    throw new DataIntegrityProblemException("Deleted member referenced: " + this.toString());
                }
            }
        }
    }

    private void fireMembersChanged() {
        this.checkMembers();
        if (this.getDataSet() != null) {
            this.getDataSet().fireRelationMembersChanged(this);
        }
    }

    @Override
    public boolean hasIncompleteMembers() {
        for (RelationMember rm : this.members) {
            if (!rm.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<OsmPrimitive> getIncompleteMembers() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember rm : this.members) {
            if (!rm.getMember().isIncomplete()) continue;
            ret.add(rm.getMember());
        }
        return ret;
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        super.keysChangedImpl(originalKeys);
        for (OsmPrimitive member : this.getMemberPrimitivesList()) {
            member.clearCachedStyle();
        }
    }

    @Override
    public boolean concernsArea() {
        return this.isMultipolygon() && this.hasAreaTags();
    }

    @Override
    public boolean isOutsideDownloadArea() {
        return false;
    }

    public Set<String> getMemberRoles() {
        return Stream.of(this.members).map(RelationMember::getRole).filter(role -> !role.isEmpty()).collect(Collectors.toSet());
    }

    @Override
    public List<? extends OsmPrimitive> findRelationMembers(String role) {
        return IRelation.super.findRelationMembers(role).stream().filter(m -> m instanceof OsmPrimitive).map(m -> (OsmPrimitive)m).collect(Collectors.toList());
    }

    @Override
    public UniqueIdGenerator getIdGenerator() {
        return idGenerator;
    }
}

