/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class ValUtil {
    private ValUtil() {
    }

    public static List<List<Way>> getWaysInCell(Way w, Map<Point2D, List<Way>> cellWays) {
        if (w.isEmpty()) {
            return Collections.emptyList();
        }
        Node n1 = w.getNode(0);
        Node n2 = w.getNode(w.getNodesCount() - 1);
        ArrayList<List<Way>> cells = new ArrayList<List<Way>>(2);
        HashSet<Point2D.Double> cellNodes = new HashSet<Point2D.Double>();
        double griddetail = OsmValidator.getGridDetail();
        long x0 = Math.round(n1.getEastNorth().east() * griddetail);
        long y0 = Math.round(n1.getEastNorth().north() * griddetail);
        long x1 = Math.round(n2.getEastNorth().east() * griddetail);
        long y1 = Math.round(n2.getEastNorth().north() * griddetail);
        Point2D.Double cell = new Point2D.Double(x0, y0);
        cellNodes.add(cell);
        cells.add(cellWays.computeIfAbsent(cell, k -> new ArrayList()));
        cell = new Point2D.Double(x1, y1);
        if (!cellNodes.contains(cell)) {
            cellNodes.add(cell);
            cells.add(cellWays.computeIfAbsent(cell, k -> new ArrayList()));
        }
        x0 = (long)Math.floor(n1.getEastNorth().east() * griddetail);
        y0 = (long)Math.floor(n1.getEastNorth().north() * griddetail);
        x1 = (long)Math.floor(n2.getEastNorth().east() * griddetail);
        y1 = (long)Math.floor(n2.getEastNorth().north() * griddetail);
        cell = new Point2D.Double(x0, y0);
        if (!cellNodes.contains(cell)) {
            cellNodes.add(cell);
            cells.add(cellWays.computeIfAbsent(cell, k -> new ArrayList()));
        }
        if (!cellNodes.contains(cell = new Point2D.Double(x1, y1))) {
            cellNodes.add(cell);
            cells.add(cellWays.computeIfAbsent(cell, k -> new ArrayList()));
        }
        return cells;
    }

    public static List<Point2D> getSegmentCells(Node n1, Node n2, double gridDetail) {
        CheckParameterUtil.ensureParameterNotNull(n1, "n1");
        CheckParameterUtil.ensureParameterNotNull(n1, "n2");
        return ValUtil.getSegmentCells(n1.getEastNorth(), n2.getEastNorth(), gridDetail);
    }

    public static List<Point2D> getSegmentCells(EastNorth en1, EastNorth en2, double gridDetail) {
        CheckParameterUtil.ensureParameterNotNull(en1, "en1");
        CheckParameterUtil.ensureParameterNotNull(en2, "en2");
        ArrayList<Point2D> cells = new ArrayList<Point2D>();
        double x0 = en1.east() * gridDetail;
        double x1 = en2.east() * gridDetail;
        double y0 = en1.north() * gridDetail + 1.0;
        double y1 = en2.north() * gridDetail + 1.0;
        if (x0 > x1) {
            double aux = x0;
            x0 = x1;
            x1 = aux;
            aux = y0;
            y0 = y1;
            y1 = aux;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        long stepY = y0 <= y1 ? 1L : -1L;
        long gridX0 = (long)Math.floor(x0);
        long gridX1 = (long)Math.floor(x1);
        long gridY0 = (long)Math.floor(y0);
        long gridY1 = (long)Math.floor(y1);
        long maxSteps = gridX1 - gridX0 + Math.abs(gridY1 - gridY0) + 1L;
        while (gridX0 <= gridX1 && (gridY0 - gridY1) * stepY <= 0L && maxSteps-- > 0L) {
            cells.add(new Point2D.Double(gridX0, gridY0));
            double scanY = dy / dx * ((double)(gridX0 + 1L) - x1) + y1 + (double)(dy < 0.0 ? -1 : 0);
            double scanX = dx / dy * ((double)(gridY0 + (long)(dy < 0.0 ? 0 : 1) * stepY) - y1) + x1;
            double distX = Math.pow((double)(gridX0 + 1L) - x0, 2.0) + Math.pow(scanY - y0, 2.0);
            double distY = Math.pow(scanX - x0, 2.0) + Math.pow((double)(gridY0 + stepY) - y0, 2.0);
            if (distX < distY) {
                ++gridX0;
                continue;
            }
            gridY0 += stepY;
        }
        return cells;
    }
}

