/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class BasicChangesetQueryPanel
extends JPanel {
    private transient Map<BasicQuery, JRadioButton> rbQueries;
    private JCheckBox cbMyChangesetsOnly;

    protected JPanel buildQueriesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        ButtonGroup bgQueries = new ButtonGroup();
        this.rbQueries = new EnumMap<BasicQuery, JRadioButton>(BasicQuery.class);
        SelectQueryHandler selectedQueryHandler = new SelectQueryHandler();
        for (BasicQuery q : BasicQuery.values()) {
            JRadioButton rb = new JRadioButton();
            rb.addItemListener(selectedQueryHandler);
            this.rbQueries.put(q, rb);
            bgQueries.add(rb);
        }
        GBC gc = GBC.eop().fill(2);
        pnl.add((Component)this.rbQueries.get((Object)BasicQuery.MOST_RECENT_CHANGESETS), gc);
        pnl.add((Component)this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS), gc);
        pnl.add((Component)this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW), gc);
        gc.gridwidth = 2;
        gc.insets = new Insets(5, 0, 3, 3);
        this.cbMyChangesetsOnly = new JCheckBox(I18n.tr("Download my changesets only", new Object[0]));
        pnl.add((Component)this.cbMyChangesetsOnly, gc);
        this.cbMyChangesetsOnly.setToolTipText(I18n.tr("<html>Select to restrict the query to your changesets only.<br>Unselect to include all changesets in the query.</html>", new Object[0]));
        pnl.add((Component)new JPanel(), GBC.eol().insets(5, 0, 3, 3).fill());
        return pnl;
    }

    protected JPanel buildInfoPanel() {
        HtmlPanel pnlInfos = new HtmlPanel();
        pnlInfos.setText(I18n.tr("<html>Please select one the following <strong>standard queries</strong>.Select <strong>Download my changesets only</strong> if you only want to download changesets created by yourself.<br>Note that JOSM will download max. 100 changesets.</html>", new Object[0]));
        return pnlInfos;
    }

    protected final void build() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildInfoPanel(), "North");
        this.add((Component)this.buildQueriesPanel(), "Center");
    }

    public BasicChangesetQueryPanel() {
        this.build();
    }

    public void init() {
        JRadioButton lbl = this.rbQueries.get((Object)BasicQuery.MOST_RECENT_CHANGESETS);
        lbl.setText(I18n.tr("<html>Download the latest changesets</html>", new Object[0]));
        lbl = this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS);
        if (UserIdentityManager.getInstance().isAnonymous()) {
            this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS).setEnabled(false);
            lbl.setText(I18n.tr("<html>Download my open changesets<br><em>Disabled. Please enter your OSM user name in the preferences first.</em></html>", new Object[0]));
        } else {
            this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS).setEnabled(true);
            lbl.setText(I18n.tr("<html>Download my open changesets</html>", new Object[0]));
        }
        lbl = this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW);
        if (!MainApplication.isDisplayingMapView()) {
            this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW).setEnabled(false);
            lbl.setText(I18n.tr("<html>Download changesets in the current map view.<br><em>Disabled. There is currently no map view active.</em></html>", new Object[0]));
        } else {
            this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW).setEnabled(true);
            lbl.setText(I18n.tr("<html>Download changesets in the current map view</html>", new Object[0]));
        }
        this.restoreFromPreferences();
    }

    public void rememberInPreferences() {
        BasicQuery q = this.getSelectedQuery();
        if (q == null) {
            Config.getPref().put("changeset-query.basic.query", null);
        } else {
            Config.getPref().put("changeset-query.basic.query", q.toString());
        }
        Config.getPref().putBoolean("changeset-query.basic.my-changesets-only", this.cbMyChangesetsOnly.isSelected());
    }

    public void restoreFromPreferences() {
        BasicQuery q;
        String value = Config.getPref().get("changeset-query.basic.query", null);
        if (value == null) {
            q = BasicQuery.MOST_RECENT_CHANGESETS;
        } else {
            try {
                q = BasicQuery.valueOf(BasicQuery.class, value);
            }
            catch (IllegalArgumentException e) {
                Logging.log(Logging.LEVEL_WARN, I18n.tr("Unexpected value for preference ''{0}'', got ''{1}''. Resetting to default query.", "changeset-query.basic.query", value), e);
                q = BasicQuery.MOST_RECENT_CHANGESETS;
            }
        }
        this.rbQueries.get((Object)q).setSelected(true);
        boolean mineOnly = Config.getPref().getBoolean("changeset-query.basic.my-changesets-only", false);
        mineOnly = mineOnly || q == BasicQuery.MY_OPEN_CHANGESETS;
        this.cbMyChangesetsOnly.setSelected(mineOnly);
    }

    protected BasicQuery getSelectedQuery() {
        for (BasicQuery q : BasicQuery.values()) {
            if (!this.rbQueries.get((Object)q).isSelected()) continue;
            return q;
        }
        return null;
    }

    public ChangesetQuery buildChangesetQuery() {
        BasicQuery q = this.getSelectedQuery();
        ChangesetQuery query = new ChangesetQuery();
        UserIdentityManager im = UserIdentityManager.getInstance();
        if (q == null) {
            return query;
        }
        switch (q) {
            case MOST_RECENT_CHANGESETS: {
                break;
            }
            case MY_OPEN_CHANGESETS: {
                query = query.beingOpen(true);
                break;
            }
            case CHANGESETS_IN_MAP_VIEW: {
                MapView mapView = MainApplication.getMap().mapView;
                Bounds b = mapView.getLatLonBounds(mapView.getBounds());
                query = query.inBbox(b);
            }
        }
        if (this.cbMyChangesetsOnly.isSelected()) {
            if (im.isPartiallyIdentified()) {
                query = query.forUser(im.getUserName());
            } else if (im.isFullyIdentified()) {
                query = query.forUser(im.getUserId()).beingOpen(true);
            } else {
                throw new IllegalStateException(I18n.tr("Cannot create changeset query for open changesets of anonymous user", new Object[0]));
            }
        }
        return query;
    }

    class SelectQueryHandler
    implements ItemListener {
        SelectQueryHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BasicQuery q = BasicChangesetQueryPanel.this.getSelectedQuery();
            if (q == null) {
                return;
            }
            if (q == BasicQuery.MY_OPEN_CHANGESETS) {
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setSelected(true);
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setEnabled(false);
            } else if (!BasicChangesetQueryPanel.this.cbMyChangesetsOnly.isEnabled()) {
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setEnabled(true);
            }
        }
    }

    private static enum BasicQuery {
        MOST_RECENT_CHANGESETS,
        MY_OPEN_CHANGESETS,
        CHANGESETS_IN_MAP_VIEW;

    }
}

