/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SearchNotesDownloadAction
extends JosmAction {
    private static final String HISTORY_KEY = "osm.notes.searchHistory";

    public SearchNotesDownloadAction() {
        super(I18n.tr("Search Notes...", new Object[0]), "note_search", I18n.tr("Download notes from the note search API", new Object[0]), Shortcut.registerShortcut("file:notesearch", I18n.tr("File: {0}", I18n.tr("Search Notes...", new Object[0])), 65535, 5000), false, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HistoryComboBox searchTermBox = new HistoryComboBox();
        searchTermBox.setPossibleItemsTopDown(Config.getPref().getList(HISTORY_KEY, Collections.emptyList()));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.anchor = 23;
        contentPanel.add((Component)new JLabel(I18n.tr("Search the OSM API for notes containing words:", new Object[0])), gc);
        gc.gridy = 1;
        contentPanel.add((Component)searchTermBox, gc);
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Search for notes", new Object[0]), I18n.tr("Search for notes", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(contentPanel).setButtonIcons("note_search", "cancel");
        ed.configureContextsensitiveHelp("/Action/SearchNotesDownload", true);
        if (ed.showDialog().getValue() != 1) {
            return;
        }
        String searchTerm = Optional.ofNullable(searchTermBox.getText()).orElse("").trim();
        if (searchTerm.isEmpty()) {
            new Notification(I18n.tr("You must enter a search term", new Object[0])).setIcon(2).show();
            return;
        }
        searchTermBox.addCurrentItemToHistory();
        Config.getPref().putList(HISTORY_KEY, searchTermBox.getHistory());
        this.performSearch(searchTerm);
    }

    public void performSearch(String searchTerm) {
        String trimmedSearchTerm = searchTerm.trim();
        try {
            long id = Long.parseLong(trimmedSearchTerm);
            new DownloadNotesTask().download(id, null);
            return;
        }
        catch (NumberFormatException ignore) {
            Logging.trace(ignore);
            int noteLimit = Config.getPref().getInt("osm.notes.downloadLimit", 1000);
            int closedLimit = Config.getPref().getInt("osm.notes.daysClosed", 7);
            StringBuilder sb = new StringBuilder(128);
            sb.append(OsmApi.getOsmApi().getBaseUrl()).append("notes/search?limit=").append(noteLimit).append("&closed=").append(closedLimit).append("&q=").append(Utils.encodeUrl(trimmedSearchTerm));
            new DownloadNotesTask().loadUrl(new DownloadParams(), sb.toString(), null);
            return;
        }
    }
}

