/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class Way
extends OsmPrimitive
implements IWay<Node> {
    static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private Node[] nodes = new Node[0];
    private BBox bbox;

    @Override
    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNodes(List<Node> nodes) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            for (Node node : this.nodes) {
                node.removeReferrer(this);
                node.clearCachedStyle();
            }
            this.nodes = nodes == null ? new Node[0] : nodes.toArray(new Node[0]);
            for (Node node : this.nodes) {
                node.addReferrer(this);
                node.clearCachedStyle();
            }
            this.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    private static List<Node> removeDouble(List<Node> nodes) {
        Node last = null;
        int count = nodes.size();
        int i = 0;
        while (i < count && count > 2) {
            Node n = nodes.get(i);
            if (last == n) {
                nodes.remove(i);
                --count;
                continue;
            }
            last = n;
            ++i;
        }
        return nodes;
    }

    @Override
    public int getNodesCount() {
        return this.nodes.length;
    }

    @Override
    public Node getNode(int index) {
        return this.nodes[index];
    }

    @Override
    public long getNodeId(int idx) {
        return this.nodes[idx].getUniqueId();
    }

    @Override
    public List<Long> getNodeIds() {
        return Arrays.stream(this.nodes).map(AbstractPrimitive::getId).collect(Collectors.toList());
    }

    public boolean containsNode(Node node) {
        return node != null && Arrays.asList(this.nodes).contains(node);
    }

    public Set<Node> getNeighbours(Node node) {
        HashSet<Node> neigh = new HashSet<Node>();
        if (node == null) {
            return neigh;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].equals(node)) continue;
            if (i > 0) {
                neigh.add(this.nodes[i - 1]);
            }
            if (i >= this.nodes.length - 1) continue;
            neigh.add(this.nodes[i + 1]);
        }
        return neigh;
    }

    public List<Pair<Node, Node>> getNodePairs(boolean sort) {
        ArrayList<Pair<Node, Node>> chunkSet = new ArrayList<Pair<Node, Node>>();
        if (this.isIncomplete()) {
            return chunkSet;
        }
        Node lastN = null;
        for (Node n : this.nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            Pair<Node, Node> np = new Pair<Node, Node>(lastN, n);
            if (sort) {
                Pair.sort(np);
            }
            chunkSet.add(np);
            lastN = n;
        }
        return chunkSet;
    }

    @Override
    public void accept(OsmPrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    Way(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way original, boolean clearMetadata, boolean copyNodes) {
        super(original.getUniqueId(), true);
        this.cloneFrom(original, copyNodes);
        if (clearMetadata) {
            this.clearOsmMetadata();
        }
    }

    public Way(Way original, boolean clearMetadata) {
        this(original, clearMetadata, true);
    }

    public Way(Way original) {
        this(original, false);
    }

    public Way(long id) {
        super(id, false);
    }

    public Way(long id, int version) {
        super(id, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData data) {
        if (!(data instanceof WayData)) {
            throw new IllegalArgumentException("Not a way data: " + data);
        }
        boolean locked = this.writeLock();
        try {
            super.load(data);
            List<Long> nodeIds = ((WayData)data).getNodeIds();
            if (!nodeIds.isEmpty() && this.getDataSet() == null) {
                throw new AssertionError((Object)"Data consistency problem - way without dataset detected");
            }
            ArrayList<Node> newNodes = new ArrayList<Node>(nodeIds.size());
            for (Long nodeId : nodeIds) {
                Node node = (Node)this.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE);
                if (node != null) {
                    newNodes.add(node);
                    continue;
                }
                throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
            }
            this.setNodes((List<Node>)newNodes);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public WayData save() {
        WayData data = new WayData();
        this.saveCommonAttributes(data);
        for (Node node : this.nodes) {
            data.getNodeIds().add(node.getUniqueId());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osm, boolean copyNodes) {
        if (!(osm instanceof Way)) {
            throw new IllegalArgumentException("Not a way: " + osm);
        }
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm, copyNodes);
            if (copyNodes) {
                this.setNodes(((Way)osm).getNodes());
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public String toString() {
        String nodesDesc = this.isIncomplete() ? "(incomplete)" : "nodes=" + Arrays.toString(this.nodes);
        return "{Way id=" + this.getUniqueId() + " version=" + this.getVersion() + ' ' + this.getFlagsAsString() + ' ' + nodesDesc + '}';
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other, boolean testInterestingTagsOnly) {
        if (!(other instanceof Way)) {
            return false;
        }
        Way w = (Way)other;
        if (this.getNodesCount() != w.getNodesCount()) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other, testInterestingTagsOnly)) {
            return false;
        }
        return IntStream.range(0, this.getNodesCount()).allMatch(i -> this.getNode(i).hasEqualSemanticAttributes(w.getNode(i)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node n) {
        this.checkDatasetNotReadOnly();
        if (n == null || this.isIncomplete()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            int i;
            boolean closed = this.lastNode() == n && this.firstNode() == n;
            List<Node> copy = this.getNodes();
            while ((i = copy.indexOf(n)) >= 0) {
                copy.remove(i);
            }
            i = copy.size();
            if (closed && i > 2) {
                copy.add(copy.get(0));
            } else if (i >= 2 && i <= 3 && copy.get(0) == copy.get(i - 1)) {
                copy.remove(i - 1);
            }
            this.setNodes(Way.removeDouble(copy));
            n.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(Set<? extends Node> selection) {
        this.checkDatasetNotReadOnly();
        if (selection == null || this.isIncomplete()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            this.setNodes(this.calculateRemoveNodes(selection));
            for (Node node : selection) {
                node.clearCachedStyle();
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public List<Node> calculateRemoveNodes(Set<? extends Node> selection) {
        if (selection == null || this.isIncomplete()) {
            return this.getNodes();
        }
        boolean closed = this.isClosed() && selection.contains(this.lastNode());
        List<Node> copy = Arrays.stream(this.nodes).filter(n -> !selection.contains(n)).collect(Collectors.toList());
        int i = copy.size();
        if (closed && i > 2) {
            copy.add(copy.get(0));
        } else if (i >= 2 && i <= 3 && copy.get(0) == copy.get(i - 1)) {
            copy.remove(i - 1);
        }
        return Way.removeDouble(copy);
    }

    public void addNode(Node n) {
        this.checkDatasetNotReadOnly();
        if (n == null) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
            }
            this.clearCachedStyle();
            n.addReferrer(this);
            this.nodes = Utils.addInArrayCopy(this.nodes, n);
            n.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(int offs, Node n) {
        this.checkDatasetNotReadOnly();
        if (n == null) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
            }
            this.clearCachedStyle();
            n.addReferrer(this);
            Node[] newNodes = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, offs);
            System.arraycopy(this.nodes, offs, newNodes, offs + 1, this.nodes.length - offs);
            newNodes[offs] = n;
            this.nodes = newNodes;
            n.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            for (Node n : this.nodes) {
                if (deleted) {
                    n.removeReferrer(this);
                } else {
                    n.addReferrer(this);
                }
                n.clearCachedStyle();
            }
            this.fireNodesChanged();
            super.setDeleted(deleted);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        return this.nodes.length >= 3 && this.nodes[this.nodes.length - 1] == this.nodes[0];
    }

    public boolean isArea() {
        if (this.nodes.length >= 4 && this.isClosed()) {
            Node distinctNode = null;
            for (int i = 1; i < this.nodes.length - 1; ++i) {
                if (distinctNode == null && this.nodes[i] != this.nodes[0]) {
                    distinctNode = this.nodes[i];
                    continue;
                }
                if (distinctNode == null || this.nodes[i] == this.nodes[0] || this.nodes[i] == distinctNode) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Node lastNode() {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[this.nodes.length - 1];
    }

    @Override
    public Node firstNode() {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0];
    }

    @Override
    public boolean isFirstLastNode(INode n) {
        if (this.isIncomplete() || this.nodes.length == 0) {
            return false;
        }
        return n == this.nodes[0] || n == this.nodes[this.nodes.length - 1];
    }

    @Override
    public boolean isInnerNode(INode n) {
        if (this.isIncomplete() || this.nodes.length <= 2) {
            return false;
        }
        if (n == this.nodes[0] && n == this.nodes[this.nodes.length - 1]) {
            return true;
        }
        return IntStream.range(1, this.nodes.length - 1).anyMatch(i -> this.nodes[i] == n);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.isClosed() ? OsmPrimitiveType.CLOSEDWAY : OsmPrimitiveType.WAY;
    }

    private void checkNodes() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            for (Node n : this.nodes) {
                if (n.getDataSet() != dataSet) {
                    throw new DataIntegrityProblemException("Nodes in way must be in the same dataset", I18n.tr("Nodes in way must be in the same dataset", new Object[0]), new OsmPrimitive[0]);
                }
                if (!n.isDeleted()) continue;
                throw new DataIntegrityProblemException("Deleted node referenced: " + this.toString(), "<html>" + I18n.tr("Deleted node referenced by {0}", DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(this)) + "</html>", this, n);
            }
            if (Config.getPref().getBoolean("debug.checkNullCoor", true)) {
                for (Node n : this.nodes) {
                    if (!n.isVisible() || n.isIncomplete() || n.isLatLonKnown()) continue;
                    throw new DataIntegrityProblemException("Complete visible node with null coordinates: " + this.toString(), "<html>" + I18n.tr("Complete node {0} with null coordinates in way {1}", DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(n), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(this)) + "</html>", this, n);
                }
            }
        }
    }

    private void fireNodesChanged() {
        this.checkNodes();
        if (this.getDataSet() != null) {
            this.getDataSet().fireWayNodesChanged(this);
        }
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkNodes();
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() == null) {
            return new BBox(this);
        }
        if (this.bbox == null) {
            this.bbox = new BBox(this);
        }
        return new BBox(this.bbox);
    }

    @Override
    protected void addToBBox(BBox box, Set<PrimitiveId> visited) {
        box.add(this.getBBox());
    }

    @Override
    public void updatePosition() {
        this.bbox = new BBox(this);
        this.clearCachedStyle();
    }

    public boolean hasIncompleteNodes() {
        return Arrays.stream(this.nodes).anyMatch(AbstractPrimitive::isIncomplete);
    }

    public boolean hasOnlyLocatableNodes() {
        return Arrays.stream(this.nodes).allMatch(ILatLon::isLatLonKnown);
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.hasIncompleteNodes();
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && this.hasOnlyLocatableNodes();
    }

    public double getLength() {
        double length = 0.0;
        Node lastN = null;
        for (Node n : this.nodes) {
            if (lastN != null) {
                LatLon lastNcoor = lastN.getCoor();
                LatLon coor = n.getCoor();
                if (lastNcoor != null && coor != null) {
                    length += coor.greatCircleDistance(lastNcoor);
                }
            }
            lastN = n;
        }
        return length;
    }

    public double getLongestSegmentLength() {
        double length = 0.0;
        Node lastN = null;
        for (Node n : this.nodes) {
            if (lastN != null) {
                double l;
                LatLon lastNcoor = lastN.getCoor();
                LatLon coor = n.getCoor();
                if (lastNcoor != null && coor != null && (l = coor.greatCircleDistance(lastNcoor)) > length) {
                    length = l;
                }
            }
            lastN = n;
        }
        return length;
    }

    public int isOneway() {
        String oneway = this.get("oneway");
        if (oneway != null) {
            if ("-1".equals(oneway)) {
                return -1;
            }
            Boolean isOneway = OsmUtils.getOsmBoolean(oneway);
            if (isOneway != null && isOneway.booleanValue()) {
                return 1;
            }
        }
        return 0;
    }

    public Node firstNode(boolean respectOneway) {
        return !respectOneway || this.isOneway() != -1 ? this.firstNode() : this.lastNode();
    }

    public Node lastNode(boolean respectOneway) {
        return !respectOneway || this.isOneway() != -1 ? this.lastNode() : this.firstNode();
    }

    @Override
    public boolean concernsArea() {
        return this.hasAreaTags();
    }

    @Override
    public boolean isOutsideDownloadArea() {
        return Arrays.stream(this.nodes).anyMatch(Node::isOutsideDownloadArea);
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        super.keysChangedImpl(originalKeys);
        this.clearCachedNodeStyles();
    }

    public void clearCachedNodeStyles() {
        for (Node n : this.nodes) {
            n.clearCachedStyle();
        }
    }

    public synchronized List<Pair<Double, Node>> getAngles() {
        ArrayList<Pair<Double, Node>> angles = new ArrayList<Pair<Double, Node>>();
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            Node n0 = this.nodes[i - 1];
            Node n1 = this.nodes[i];
            Node n2 = this.nodes[i + 1];
            double angle = Geometry.getNormalizedAngleInDegrees(Geometry.getCornerAngle(n0.getEastNorth(), n1.getEastNorth(), n2.getEastNorth()));
            angles.add(new Pair<Double, Node>(angle, n1));
        }
        angles.add(new Pair<Double, Node>(Geometry.getNormalizedAngleInDegrees(Geometry.getCornerAngle(this.nodes[this.nodes.length - 2].getEastNorth(), this.nodes[0].getEastNorth(), this.nodes[1].getEastNorth())), this.nodes[0]));
        return angles;
    }

    @Override
    public UniqueIdGenerator getIdGenerator() {
        return idGenerator;
    }
}

