/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractMergePanel
extends JPanel {
    protected int currentRow;

    protected AbstractMergePanel() {
        super(new GridBagLayout());
    }

    protected void buildRows() {
        this.getRows().forEach(row -> row.addTo(this));
    }

    protected abstract List<? extends MergeRow> getRows();

    protected static abstract class AbstractUndecideRow
    extends MergeRow {
        protected AbstractUndecideRow() {
        }

        @Override
        protected JComponent merged() {
            AbstractAction actUndecide = this.createAction();
            JButton button = new JButton(actUndecide);
            button.setName(this.getButtonName());
            return button;
        }

        protected abstract AbstractAction createAction();

        protected abstract String getButtonName();

        @Override
        protected void addConstraints(GBC constraints, int columnIndex) {
            super.addConstraints(constraints, columnIndex);
            constraints.fill(0);
        }
    }

    protected static class TitleRow
    extends MergeRow {
        @Override
        protected JComponent mineField() {
            JLabel label = new JLabel(I18n.tr("My version (local dataset)", new Object[0]));
            label.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset", new Object[0]));
            label.setHorizontalAlignment(0);
            return label;
        }

        @Override
        protected JComponent merged() {
            JLabel label = new JLabel(I18n.tr("Merged version", new Object[0]));
            label.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied.", new Object[0]));
            label.setHorizontalAlignment(0);
            return label;
        }

        @Override
        protected JComponent theirsField() {
            JLabel label = new JLabel(I18n.tr("Their version (server dataset)", new Object[0]));
            label.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset", new Object[0]));
            label.setHorizontalAlignment(0);
            return label;
        }
    }

    protected static class MergeRowWithoutButton
    extends MergeRow {
        protected MergeRowWithoutButton() {
        }

        @Override
        protected JComponent[] getColumns() {
            return new JComponent[]{this.rowTitle(), this.mineField(), null, this.merged(), this.theirsField(), null};
        }

        @Override
        protected void addConstraints(GBC constraints, int columnIndex) {
            super.addConstraints(constraints, columnIndex);
            if (columnIndex == 1 || columnIndex == 4) {
                constraints.gridwidth = 2;
            }
        }
    }

    protected static class MergeRow {
        protected int marginTop = 5;

        protected JComponent rowTitle() {
            return null;
        }

        protected JComponent mineField() {
            return null;
        }

        protected JComponent mineButton() {
            return null;
        }

        protected JComponent merged() {
            return null;
        }

        protected JComponent theirsButton() {
            return null;
        }

        protected JComponent theirsField() {
            return null;
        }

        void addTo(AbstractMergePanel panel) {
            JComponent[] buttons = this.getColumns();
            for (int columnIndex = 0; columnIndex < buttons.length; ++columnIndex) {
                if (buttons[columnIndex] == null) continue;
                GBC constraints = GBC.std(columnIndex, panel.currentRow);
                this.addConstraints(constraints, columnIndex);
                panel.add((Component)buttons[columnIndex], constraints);
            }
            ++panel.currentRow;
        }

        protected JComponent[] getColumns() {
            return new JComponent[]{this.rowTitle(), this.mineField(), this.mineButton(), this.merged(), this.theirsButton(), this.theirsField()};
        }

        protected void addConstraints(GBC constraints, int columnIndex) {
            constraints.anchor(10);
            constraints.fill = 1;
            constraints.weight(0.0, 0.0);
            constraints.insets(3, this.marginTop, 3, 0);
            if (columnIndex == 1 || columnIndex == 3 || columnIndex == 5) {
                constraints.weightx = 1.0;
            }
        }
    }
}

