/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class LongParagraphRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_PARAGRAPH";
    private static final int DEFAULT_MAX_WORDS = 80;
    private static final Pattern NON_WORD_REGEX = Pattern.compile("[.?!\u2026:;,~\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]\\-\u2013\u2014*\u00d7\u2217\u00b7+\u00f7/=]");
    private static final boolean DEFAULT_ACTIVATION = false;
    protected int maxWords = 80;

    public LongParagraphRule(ResourceBundle messages, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages);
        int confWords;
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            this.maxWords = confWords;
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public LongParagraphRule(ResourceBundle messages, UserConfig userConfig, int defaultWords) {
        this(messages, userConfig, defaultWords, false);
    }

    public LongParagraphRule(ResourceBundle messages, UserConfig userConfig) {
        this(messages, userConfig, -1, false);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int getDefaultValue() {
        return this.maxWords;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 5;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 200;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("guiLongParagraphsText");
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_msg"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String msg = this.getMessage();
        int pos = 0;
        int startPos = 0;
        int wordCount = 0;
        AnalyzedTokenReadings lastToken = null;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings token : tokens = sentence.getTokens()) {
                String sToken = token.getToken();
                if (!(token.isWhitespace() || token.isSentenceStart() || token.isSentenceEnd() || NON_WORD_REGEX.matcher(sToken).matches())) {
                    if (wordCount == 0) {
                        startPos = token.getStartPos() + pos;
                    }
                    ++wordCount;
                    lastToken = token;
                    continue;
                }
                if (!"\n".equals(sToken) && !"\r\n".equals(sToken) && !"\n\r".equals(sToken)) continue;
                if (wordCount > this.maxWords) {
                    RuleMatch ruleMatch = new RuleMatch(this, startPos, lastToken.getEndPos() + pos, msg);
                    ruleMatches.add(ruleMatch);
                }
                wordCount = 0;
            }
            pos += sentence.getText().length();
        }
        if (wordCount > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, startPos, lastToken.getEndPos() + (pos -= sentences.get(sentences.size() - 1).getText().length()), msg);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

