/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseAccessLimitLogEntry;
import org.languagetool.server.DatabaseCacheStatsLogEntry;
import org.languagetool.server.DatabaseCheckErrorLogEntry;
import org.languagetool.server.DatabaseCheckLogEntry;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DatabaseRuleMatchLogEntry;
import org.languagetool.server.DetectedLanguage;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.RemoteRuleMatch;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.ResultExtender;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.UserLimits;
import org.languagetool.tools.Tools;

abstract class TextChecker {
    protected static final int CONTEXT_SIZE = 40;
    protected final HTTPServerConfig config;
    private static final String ENCODING = "UTF-8";
    private static final int CACHE_STATS_PRINT = 500;
    private final Map<String, Integer> languageCheckCounts = new HashMap<String, Integer>();
    private final boolean internalServer;
    private Queue<Runnable> workQueue;
    private RequestCounter reqCounter;
    private final LanguageIdentifier identifier;
    private final ExecutorService executorService;
    private final ResultCache cache;
    private final DatabaseLogger logger;
    private final Long logServerId;

    protected abstract void setHeaders(HttpExchange var1);

    protected abstract String getResponse(AnnotatedText var1, DetectedLanguage var2, Language var3, List<RuleMatch> var4, List<RuleMatch> var5, String var6);

    @NotNull
    protected abstract List<String> getPreferredVariants(Map<String, String> var1);

    protected abstract DetectedLanguage getLanguage(String var1, Map<String, String> var2, List<String> var3);

    protected abstract boolean getLanguageAutoDetect(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getEnabledRuleIds(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getDisabledRuleIds(Map<String, String> var1);

    TextChecker(HTTPServerConfig config, boolean internalServer, Queue<Runnable> workQueue, RequestCounter reqCounter) {
        this.config = config;
        this.internalServer = internalServer;
        this.workQueue = workQueue;
        this.reqCounter = reqCounter;
        this.identifier = new LanguageIdentifier();
        this.identifier.enableFasttext(config.getFasttextBinary(), config.getFasttextModel());
        this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("lt-textchecker-thread-%d").build());
        this.cache = config.getCacheSize() > 0 ? new ResultCache(config.getCacheSize()) : null;
        this.logger = DatabaseLogger.getInstance();
        this.logServerId = this.logger.isLogging() ? DatabaseAccess.getInstance().getOrCreateServerId() : null;
    }

    void shutdownNow() {
        this.executorService.shutdownNow();
    }

    void checkText(final AnnotatedText aText, HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        List<RuleMatch> matches;
        this.checkParams(parameters);
        long timeStart = System.currentTimeMillis();
        UserLimits limits = ServerTools.getUserLimits(parameters, this.config);
        String agent = parameters.get("useragent") != null ? parameters.get("useragent") : "-";
        Long agentId = null;
        Long userId = null;
        if (this.logger.isLogging()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            agentId = db.getOrCreateClientId(parameters.get("useragent"));
            userId = limits.getPremiumUid();
        }
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        String userAgent = httpExchange.getRequestHeaders().getFirst("User-Agent");
        if (aText.getPlainText().length() > limits.getMaxTextLength()) {
            String msg = "limit: " + limits.getMaxTextLength() + ", size: " + aText.getPlainText().length();
            this.logger.log(new DatabaseAccessLimitLogEntry("MaxCharacterSizeExceeded", this.logServerId, agentId, userId, msg, referrer, userAgent));
            throw new TextTooLongException("Your text exceeds the limit of " + limits.getMaxTextLength() + " characters (it's " + aText.getPlainText().length() + " characters). Please submit a shorter text.");
        }
        final UserConfig userConfig = new UserConfig(limits.getPremiumUid() != null ? this.getUserDictWords(limits.getPremiumUid()) : Collections.emptyList(), new HashMap<String, Integer>(), this.config.getMaxSpellingSuggestions());
        boolean autoDetectLanguage = this.getLanguageAutoDetect(parameters);
        List<String> preferredVariants = this.getPreferredVariants(parameters);
        DetectedLanguage detLang = this.getLanguage(aText.getPlainText(), parameters, preferredVariants);
        final Language lang = detLang.getGivenLanguage();
        Integer count = this.languageCheckCounts.get(lang.getShortCodeWithCountryAndVariant());
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        String motherTongueParam = parameters.get("motherTongue");
        final Language motherTongue = motherTongueParam != null ? Languages.getLanguageForShortCode(motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(parameters.get("enabledOnly")) || "true".equals(parameters.get("enabledOnly"));
        List<String> enabledRules = this.getEnabledRuleIds(parameters);
        List<String> disabledRules = this.getDisabledRuleIds(parameters);
        List<CategoryId> enabledCategories = this.getCategoryIds("enabledCategories", parameters);
        List<CategoryId> disabledCategories = this.getCategoryIds("disabledCategories", parameters);
        if ((disabledRules.size() > 0 || disabledCategories.size() > 0) && useEnabledOnly) {
            throw new IllegalArgumentException("You cannot specify disabled rules or categories using enabledOnly=true");
        }
        if (enabledRules.size() == 0 && enabledCategories.size() == 0 && useEnabledOnly) {
            throw new IllegalArgumentException("You must specify enabled rules or categories when using enabledOnly=true");
        }
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0 || enabledCategories.size() > 0 || disabledCategories.size() > 0;
        boolean allowIncompleteResults = "true".equals(parameters.get("allowIncompleteResults"));
        boolean enableHiddenRules = "true".equals(parameters.get("enableHiddenRules"));
        JLanguageTool.Mode mode = ServerTools.getMode(parameters);
        final QueryParams params = new QueryParams(enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, mode);
        Long textSessionId = null;
        try {
            if (parameters.containsKey("textSessionId")) {
                textSessionId = Long.valueOf(parameters.get("textSessionId"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int textSize = aText.getPlainText().length();
        final List ruleMatchesSoFar = Collections.synchronizedList(new ArrayList());
        Future<List<RuleMatch>> future = this.executorService.submit(new Callable<List<RuleMatch>>(){

            @Override
            public List<RuleMatch> call() throws Exception {
                return TextChecker.this.getRuleMatches(aText, lang, motherTongue, params, userConfig, f -> ruleMatchesSoFar.add(f));
            }
        });
        String incompleteResultReason = null;
        if (limits.getMaxCheckTimeMillis() < 0L) {
            matches = future.get();
        } else {
            try {
                matches = future.get(limits.getMaxCheckTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                future.cancel(true);
                if (ExceptionUtils.getRootCause(e) instanceof ErrorRateTooHighException) {
                    this.logger.log(new DatabaseCheckErrorLogEntry("ErrorRateTooHigh", this.logServerId, agentId, userId, lang, detLang.getDetectedLanguage(), textSize, "matches: " + ruleMatchesSoFar.size()));
                }
                if (params.allowIncompleteResults && ExceptionUtils.getRootCause(e) instanceof ErrorRateTooHighException) {
                    ServerTools.print(e.getMessage() + " - returning " + ruleMatchesSoFar.size() + " matches found so far. Detected language: " + detLang);
                    matches = new ArrayList<RuleMatch>(ruleMatchesSoFar);
                    incompleteResultReason = "Results are incomplete: " + ExceptionUtils.getRootCause(e).getMessage();
                }
                if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e.getCause();
                }
                throw new RuntimeException(e.getMessage() + ", detected: " + detLang, e);
            }
            catch (TimeoutException e) {
                String loadInfo;
                boolean cancelled = future.cancel(true);
                Path loadFile = Paths.get("/proc/loadavg", new String[0]);
                String string = loadInfo = loadFile.toFile().exists() ? Files.readAllLines(loadFile).toString() : "(unknown)";
                if (errorRequestLimiter != null) {
                    errorRequestLimiter.logAccess(remoteAddress);
                }
                String message = "Text checking took longer than allowed maximum of " + limits.getMaxCheckTimeMillis() + " milliseconds (cancelled: " + cancelled + ", lang: " + lang.getShortCodeWithCountryAndVariant() + ", detected: " + detLang + ", #" + count + ", " + aText.getPlainText().length() + " characters of text, h: " + this.reqCounter.getHandleCount() + ", r: " + this.reqCounter.getRequestCount() + ", system load: " + loadInfo + ")";
                if (params.allowIncompleteResults) {
                    ServerTools.print(message + " - returning " + ruleMatchesSoFar.size() + " matches found so far");
                    matches = new ArrayList<RuleMatch>(ruleMatchesSoFar);
                    incompleteResultReason = "Results are incomplete: text checking took longer than allowed maximum of " + String.format(Locale.ENGLISH, "%.2f", (double)limits.getMaxCheckTimeMillis() / 1000.0) + " seconds";
                }
                this.logger.log(new DatabaseCheckErrorLogEntry("MaxCheckTimeExceeded", this.logServerId, agentId, limits.getPremiumUid(), lang, detLang.getDetectedLanguage(), textSize, "load: " + loadInfo));
                throw new RuntimeException(message, e);
            }
        }
        this.setHeaders(httpExchange);
        List<RuleMatch> hiddenMatches = new ArrayList<RuleMatch>();
        if (this.config.getHiddenMatchesServer() != null && params.enableHiddenRules && this.config.getHiddenMatchesLanguages().contains(lang)) {
            ResultExtender resultExtender = new ResultExtender(this.config.getHiddenMatchesServer(), this.config.getHiddenMatchesServerTimeout());
            try {
                long start = System.currentTimeMillis();
                List<RemoteRuleMatch> extensionMatches = resultExtender.getExtensionMatches(aText.getPlainText(), lang);
                hiddenMatches = resultExtender.getFilteredExtensionMatches(matches, extensionMatches);
                long end = System.currentTimeMillis();
                ServerTools.print("Hidden matches: " + extensionMatches.size() + " -> " + hiddenMatches.size() + " in " + (end - start) + "ms");
            }
            catch (Exception e) {
                ServerTools.print("Warn: Failed to query hidden matches server at " + this.config.getHiddenMatchesServer() + ": " + e.getClass() + ": " + e.getMessage());
            }
        }
        String response = this.getResponse(aText, detLang, motherTongue, matches, hiddenMatches, incompleteResultReason);
        String messageSent = "sent";
        String languageMessage = lang.getShortCodeWithCountryAndVariant();
        try {
            httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        if (motherTongue != null) {
            languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortCodeWithCountryAndVariant() + ")";
        }
        if (autoDetectLanguage) {
            languageMessage = languageMessage + "[auto]";
        }
        this.languageCheckCounts.put(lang.getShortCodeWithCountryAndVariant(), count);
        int computationTime = (int)(System.currentTimeMillis() - timeStart);
        ServerTools.print("Check done: " + aText.getPlainText().length() + " chars, " + languageMessage + ", #" + count + ", " + referrer + ", " + matches.size() + " matches, " + computationTime + "ms, agent:" + agent + ", " + messageSent + ", q:" + (this.workQueue != null ? Integer.valueOf(this.workQueue.size()) : "?") + ", h:" + this.reqCounter.getHandleCount() + ", distinctH:" + this.reqCounter.getDistinctIps() + ", r:" + this.reqCounter.getRequestCount());
        int matchCount = matches.size();
        DatabaseCheckLogEntry logEntry = new DatabaseCheckLogEntry(userId, agentId, this.logServerId, textSize, matchCount, lang, detLang.getDetectedLanguage(), computationTime, textSessionId);
        HashMap<String, Integer> ruleMatchCount = new HashMap<String, Integer>();
        for (RuleMatch ruleMatch : matches) {
            String ruleId = ruleMatch.getRule().getId();
            ruleMatchCount.put(ruleId, ruleMatchCount.getOrDefault(ruleId, 0) + 1);
        }
        for (Map.Entry entry : ruleMatchCount.entrySet()) {
            logEntry.addRuleMatch(new DatabaseRuleMatchLogEntry((String)entry.getKey(), (Integer)entry.getValue()));
        }
        this.logger.log(logEntry);
    }

    private List<String> getUserDictWords(Long userId) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        return db.getUserDictWords(userId);
    }

    protected void checkParams(Map<String, String> parameters) {
        if (parameters.get("text") == null && parameters.get("data") == null) {
            throw new IllegalArgumentException("Missing 'text' or 'data' parameter");
        }
    }

    private List<RuleMatch> getRuleMatches(AnnotatedText aText, Language lang, Language motherTongue, QueryParams params, UserConfig userConfig, RuleMatchListener listener) throws Exception {
        if (this.cache != null && this.cache.requestCount() > 0.0 && this.cache.requestCount() % 500.0 == 0.0) {
            double hitRate = this.cache.hitRate();
            String hitPercentage = String.format(Locale.ENGLISH, "%.2f", hitRate * 100.0);
            ServerTools.print("Cache stats: " + hitPercentage + "% hit rate");
            this.logger.log(new DatabaseCacheStatsLogEntry(this.logServerId, (float)hitRate));
        }
        JLanguageTool lt = this.getLanguageToolInstance(lang, motherTongue, params, userConfig);
        return lt.check(aText, true, JLanguageTool.ParagraphHandling.NORMAL, listener, params.mode);
    }

    @NotNull
    private List<CategoryId> getCategoryIds(String paramName, Map<String, String> parameters) {
        List<String> stringIds = this.getCommaSeparatedStrings(paramName, parameters);
        ArrayList<CategoryId> ids = new ArrayList<CategoryId>();
        for (String stringId : stringIds) {
            ids.add(new CategoryId(stringId));
        }
        return ids;
    }

    @NotNull
    protected List<String> getCommaSeparatedStrings(String paramName, Map<String, String> parameters) {
        String disabledParam = parameters.get(paramName);
        ArrayList<String> result = new ArrayList<String>();
        if (disabledParam != null) {
            result.addAll(Arrays.asList(disabledParam.split(",")));
        }
        return result;
    }

    Language detectLanguageOfString(String text, String fallbackLanguage, List<String> preferredVariants) {
        Language lang = this.identifier.detectLanguage(text);
        if (lang == null) {
            lang = Languages.getLanguageForShortCode(fallbackLanguage != null ? fallbackLanguage : "en");
        }
        if (preferredVariants.size() > 0) {
            for (String preferredVariant : preferredVariants) {
                if (!preferredVariant.contains("-")) {
                    throw new IllegalArgumentException("Invalid format for 'preferredVariants', expected a dash as in 'en-GB': '" + preferredVariant + "'");
                }
                String preferredVariantLang = preferredVariant.split("-")[0];
                if (!preferredVariantLang.equals(lang.getShortCode()) || (lang = Languages.getLanguageForShortCode(preferredVariant)) != null) continue;
                throw new IllegalArgumentException("Invalid 'preferredVariants', no such language/variant found: '" + preferredVariant + "'");
            }
        } else if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return lang;
    }

    private JLanguageTool getLanguageToolInstance(Language lang, Language motherTongue, QueryParams params, UserConfig userConfig) throws Exception {
        JLanguageTool lt = new JLanguageTool(lang, motherTongue, this.cache, userConfig);
        lt.setMaxErrorsPerWordRate(this.config.getMaxErrorsPerWordRate());
        if (this.config.getLanguageModelDir() != null) {
            lt.activateLanguageModelRules(this.config.getLanguageModelDir());
        }
        if (this.config.getWord2VecModelDir() != null) {
            lt.activateWord2VecModelRules(this.config.getWord2VecModelDir());
        }
        if (this.config.getRulesConfigFile() != null) {
            this.configureFromRulesFile(lt, lang);
        } else {
            this.configureFromGUI(lt, lang);
        }
        if (params.useQuerySettings) {
            Tools.selectRules(lt, new HashSet<CategoryId>(params.disabledCategories), new HashSet<CategoryId>(params.enabledCategories), new HashSet<String>(params.disabledRules), new HashSet<String>(params.enabledRules), params.useEnabledOnly);
        }
        return lt;
    }

    private void configureFromRulesFile(JLanguageTool langTool, Language lang) throws IOException {
        ServerTools.print("Using options configured in " + this.config.getRulesConfigFile());
        if (this.config.getRulesConfigFile() == null) {
            throw new RuntimeException("config.getRulesConfigFile() is null");
        }
        org.languagetool.gui.Tools.configureFromRules(langTool, new Configuration(this.config.getRulesConfigFile().getCanonicalFile().getParentFile(), this.config.getRulesConfigFile().getName(), lang));
    }

    private void configureFromGUI(JLanguageTool langTool, Language lang) throws IOException {
        Configuration config = new Configuration(lang);
        if (this.internalServer && config.getUseGUIConfig()) {
            ServerTools.print("Using options configured in the GUI");
            org.languagetool.gui.Tools.configureFromRules(langTool, config);
        }
    }

    private static class QueryParams {
        final List<String> enabledRules;
        final List<String> disabledRules;
        final List<CategoryId> enabledCategories;
        final List<CategoryId> disabledCategories;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;
        final boolean allowIncompleteResults;
        final boolean enableHiddenRules;
        final JLanguageTool.Mode mode;

        QueryParams(List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, JLanguageTool.Mode mode) {
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.enabledCategories = enabledCategories;
            this.disabledCategories = disabledCategories;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
            this.allowIncompleteResults = allowIncompleteResults;
            this.enableHiddenRules = enableHiddenRules;
            this.mode = Objects.requireNonNull(mode);
        }
    }
}

