/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.feature;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.model.perceptron.common.IStringIdMap;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.tagset.CWSTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.POSTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class FeatureMap
implements IStringIdMap,
ICacheAble {
    public TagSet tagSet;
    public boolean mutable;

    public abstract int size();

    public int[] allLabels() {
        return this.tagSet.allTags();
    }

    public int bosTag() {
        return this.tagSet.size();
    }

    public FeatureMap(TagSet tagSet) {
        this(tagSet, false);
    }

    public FeatureMap(TagSet tagSet, boolean mutable) {
        this.tagSet = tagSet;
        this.mutable = mutable;
    }

    public abstract Set<Map.Entry<String, Integer>> entrySet();

    public FeatureMap(boolean mutable) {
        this.mutable = mutable;
    }

    public FeatureMap() {
        this(false);
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        this.tagSet.save(out);
        out.writeInt(this.size());
        for (Map.Entry<String, Integer> entry : this.entrySet()) {
            out.writeUTF(entry.getKey());
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.loadTagSet(byteArray);
        int size = byteArray.nextInt();
        for (int i = 0; i < size; ++i) {
            this.idOf(byteArray.nextUTF());
        }
        return true;
    }

    protected final void loadTagSet(ByteArray byteArray) {
        TaskType type = TaskType.values()[byteArray.nextInt()];
        switch (type) {
            case CWS: {
                this.tagSet = new CWSTagSet();
                break;
            }
            case POS: {
                this.tagSet = new POSTagSet();
                break;
            }
            case NER: {
                this.tagSet = new NERTagSet();
                break;
            }
            case CLASSIFICATION: {
                this.tagSet = new TagSet(TaskType.CLASSIFICATION);
            }
        }
        this.tagSet.load(byteArray);
    }
}

