/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.databroker.ResourceDataBroker;

public class CommonWords {
    private static final Map<String, List<Language>> word2langs = Collections.synchronizedMap(new HashMap());
    private static final Pattern numberPattern = Pattern.compile("[0-9.,%-]+");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonWords() throws IOException {
        Map<String, List<Language>> map = word2langs;
        synchronized (map) {
            if (!word2langs.isEmpty()) return;
            for (Language lang : Languages.get()) {
                if (lang.isVariant() && !lang.getShortCode().equals("no")) continue;
                ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
                String path = lang.getCommonWordsPath();
                InputStream stream = null;
                try {
                    if (path != null) {
                        if (dataBroker.resourceExists(path)) {
                            stream = dataBroker.getFromResourceDirAsStream(path);
                        } else {
                            if (!new File(path).exists()) throw new IOException("Common words file not found for " + lang + ": " + path);
                            stream = new FileInputStream(path);
                        }
                    } else {
                        System.out.println("WARN: no common words file defined for " + lang + " - this language might not be correctly auto-detected");
                        continue;
                    }
                    Scanner scanner = new Scanner(stream, "utf-8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String key;
                            String line = scanner.nextLine();
                            if (line.isEmpty() || line.startsWith("#") || (key = line.toLowerCase()).length() == 1 && Character.isSpaceChar(key.charAt(0))) continue;
                            List<Language> languages = word2langs.get(key);
                            if (languages == null) {
                                List<Language> l = Collections.synchronizedList(new LinkedList());
                                l.add(lang);
                                word2langs.put(key, l);
                                continue;
                            }
                            languages.add(lang);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return;
        }
    }

    public Map<Language, Integer> getKnownWordsPerLanguage(String text) {
        String[] words;
        HashMap<Language, Integer> result = new HashMap<Language, Integer>();
        if (!text.endsWith(" ")) {
            text = text.replaceFirst("\\p{L}+$", "");
        }
        for (String word : words = text.split("[(),.:;!?\u201e\u201c\"\u00a1\u00bf\\s\\[\\]{}-]")) {
            List<Language> languages;
            if (numberPattern.matcher(word).matches() || (languages = word2langs.get(word.toLowerCase())) == null) continue;
            for (Language lang : languages) {
                if (result.containsKey(lang)) {
                    result.put(lang, (Integer)result.get(lang) + 1);
                    continue;
                }
                result.put(lang, 1);
            }
        }
        return result;
    }
}

